[#ftl]
[#-- V1.2.0 --]
/*!
    \file    hs0_usbh_usr.h
    \brief   user application layer header file

    \version 2025-10-21, V1.0.0,  firmware for GD32H75E
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef __HS0_USBH_USR_H
#define __HS0_USBH_USR_H

#ifdef __cplusplus
extern "C" {
#endif

/* External Includes*/
#include "ff.h"
#include "drv_usb_hw.h"
#include "usbh_core.h"
#include "hs0_usb_conf.h"
#include "usbh_msc_core.h"
#include "usbh_msc_scsi.h"
#include "usbh_msc_bbb.h"
#include <stdio.h>
#include <string.h>
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Shared Macros */
/* State Machine for the USBH_USR_ApplicationState */
#define HS0_USBH_USR_FS_INIT             0U
#define HS0_USBH_USR_FS_READLIST         1U
#define HS0_USBH_USR_FS_WRITEFILE        2U
#define HS0_USBH_USR_FS_DRAW             3U
#define HS0_USBH_USR_FS_DEMOEND          4U
/* user code [Shared Macros] begin */

/* user code [Shared Macros] end */

/* External Constants */
/* user code [External Constants] begin */

/* user code [External Constants] end */

/* External Variables */
extern usbh_user_cb hs0_usr_cb;
extern uint8_t USBH_USR_ApplicationState;
/* user code [External Variables] begin */

/* user code [External Variables] end */

/* Public Functions */
/* user operation for host-mode initialization */
void hs0_usbh_user_init                          (void);
/* deinitialize user state and associated variables */
void hs0_usbh_user_deinit                        (void);
/* user operation for device attached */
void hs0_usbh_user_device_connected              (void);
/* user operation for unrecoverable error happens */
void hs0_usbh_user_unrecovered_error             (void);
/* user operation for device disconnect event */
void hs0_usbh_user_device_disconnected(void);
/* user operation for reset USB Device */
void hs0_usbh_user_device_reset(void);
/* user operation for detecting device speed */
void hs0_usbh_user_device_speed_detected(uint32_t DeviceSpeed);
/* user operation when device descriptor is available */
void hs0_usbh_user_device_desc_available(void *device_desc);
/* USB device is successfully assigned the address */
void hs0_usbh_user_device_address_assigned(void);
/* user operation when configuration descriptor is available */
void hs0_usbh_user_configuration_descavailable(usb_desc_config *cfgDesc,
                                               usb_desc_itf *itfDesc,
                                               usb_desc_ep *epDesc);
/* user operation when manufacturer string exists */
void hs0_usbh_user_manufacturer_string(void *manufacturer_string);
/* user operation when product string exists */
void hs0_usbh_user_product_string(void *product_string);
/* user operation when serial string exists */
void hs0_usbh_user_serialnum_string(void *serial_num_string);
/* user response request is displayed to ask for application jump to class */
void hs0_usbh_user_enumeration_finish(void);
/* user operation when device is not supported */
void hs0_usbh_user_device_not_supported(void);
/* user action for application state entry */
usbh_user_status hs0_usbh_user_userinput(void);
/* user action for device overcurrent detection event */
void hs0_usbh_user_over_current_detected(void);

/* user action for application state entry */
usbh_user_status hs0_usbh_user_userinput(void);
/* demo application for mass storage */
int hs0_usbh_usr_msc_application(void);
/* user code [Public Functions] begin */

/* user code [Public Functions] end */

#ifdef __cplusplus
}
#endif

#endif /*__HS0_USBH_USR_H */
