[#ftl]
[#-- V1.2.0 --]
/*!
    \file    hs1_usbh_usr.c
    \brief   some user routines

    \version 2025-10-21, V1.0.0,  firmware for GD32H75E
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* External Includes*/
#include "hs1_usbh_usr.h"
#include "usbh_hid_core.h"
#include "usbh_standard_hid.h"
#include "gd32h75e_init.h"

#include <stdio.h>
#include <string.h>
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
const uint8_t HS1_MSG_HOST_HEADER[] = "USBFS & USBHS HID Host";
const uint8_t HS1_MSG_HOST_FOOTER[] = "USB Host Library v2.0.0";
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* Points to the DEVICE_PROP structure of current device */
usbh_user_cb hs1_usr_cb =
{
    hs1_usbh_user_init,
    hs1_usbh_user_deinit,
    hs1_usbh_user_device_connected,
    hs1_usbh_user_device_reset,
    hs1_usbh_user_device_disconnected,
    hs1_usbh_user_over_current_detected,
    hs1_usbh_user_device_speed_detected,
    hs1_usbh_user_device_desc_available,
    hs1_usbh_user_device_address_assigned,
    hs1_usbh_user_configuration_descavailable,
    hs1_usbh_user_manufacturer_string,
    hs1_usbh_user_product_string,
    hs1_usbh_user_serialnum_string,
    hs1_usbh_user_enumeration_finish,
    hs1_usbh_user_userinput,
    NULL,
    hs1_usbh_user_device_not_supported,
    hs1_usbh_user_unrecovered_error
};

uint16_t hs1_keyboard_char_xpos = 0;
uint16_t hs1_keyboard_char_ypos = 0;
/* user code [Private Variables] begin */

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
extern int16_t XLoc, YLoc;
extern __IO int16_t PrevX, PrevY;
extern hs1_usbh_host hs1_usb_host;
extern usb_core_driver usb_hid_core;
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      user operation for host-mode initialization
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs1_usbh_user_init(void)
{
    static uint8_t startup = 0U;

    /* user code [local 0] begin */

    if(0U == startup) {
        startup = 1U;
        User_Debug_Log("> USB host library started \r\n");
    }

    /* user code [local 0] end */
}

/*!
    \brief      deinit user state and associated variables
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs1_usbh_user_deinit(void)
{
    /* user code [local 0] begin */

    User_Debug_Log("> USB host library deinit.\r\n");

    /* user code [local 0] end */
}

/*!
    \brief      user operation for device attached
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs1_usbh_user_device_connected(void)
{
    /* user code [local 0] begin */

    User_Debug_Log("> Device Attached.\r\n");

    /* user code [local 0] end */
}

/*!
    \brief      user operation for unrecovered error happens
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs1_usbh_user_unrecovered_error(void)
{
    /* user code [local 0] begin */

    User_Debug_Log("> Unrecovered Error State.\r\n");

    /* user code [local 0] end */
}

/*!
    \brief      user operation for device disconnect event
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs1_usbh_user_device_disconnected(void)
{
    /* user code [local 0] begin */

    User_Debug_Log("> Device Disconnected.\r\n");

    /* user code [local 0] end */
}

/*!
    \brief      user operation for reset USB Device
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs1_usbh_user_device_reset(void)
{
    /* user code [local 0] begin */

    User_Debug_Log("> Reset the USB device.\r\n");

    /* user code [local 0] end */
}

/*!
    \brief      user operation for detecting device speed
    \param[in]  DeviceSpeed: device speed
    \param[out] none
    \retval     none
*/
void hs1_usbh_user_device_speed_detected(uint32_t device_speed)
{
    /* user code [local 0] begin */

    if (PORT_SPEED_HIGH == device_speed) {
        User_Debug_Log("> High speed device detected.\r\n");
    } else if(PORT_SPEED_FULL == device_speed) {
        User_Debug_Log("> Full speed device detected.\r\n");
    } else if(PORT_SPEED_LOW == device_speed) {
        User_Debug_Log("> Low speed device detected.\r\n");
    } else {
        User_Debug_Log("> Device Fault.\r\n");
    }

    /* user code [local 0] begin */
}

/*!
    \brief      user operation when device descriptor is available
    \param[in]  device_desc: device descriptor
    \param[out] none
    \retval     none
*/
void hs1_usbh_user_device_desc_available(void *device_desc)
{
    /* user code [local 0] begin */

    usb_desc_dev *pDevStr = device_desc;

    User_Debug_Log("> VID: %04Xh \r\n", (uint32_t)pDevStr->idVendor);
    User_Debug_Log("> PID: %04Xh \r\n", (uint32_t)pDevStr->idProduct);

    /* user code [local 0] end */
}

/*!
    \brief      USB device is successfully assigned the address
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs1_usbh_user_device_address_assigned(void)
{
    /* user code [local 0] begin */

    User_Debug_Log("> Device Address Assigned.\r\n");

    /* user code [local 0] end */
}

/*!
    \brief      user operation when configuration descriptor is available
    \param[in]  cfg_desc: pointer to configuration descriptor
    \param[in]  itf_desc: pointer to interface descriptor
    \param[in]  ep_desc: pointer to endpoint descriptor
    \param[out] none
    \retval     none
*/
void hs1_usbh_user_configuration_descavailable(usb_desc_config *cfg_desc,
  											   usb_desc_itf *itf_desc,
                                               usb_desc_ep *ep_desc)
{
    /* user code [local 0] begin */

    usb_desc_itf *id = itf_desc;

    if (0x08U == (*id).bInterfaceClass) {
        User_Debug_Log("> Mass storage device connected.\r\n");
    } else if (0x03U == (*id).bInterfaceClass) {
        User_Debug_Log("> HID device connected.\r\n");
    }

    /* user code [local 0] end */
}

/*!
    \brief      user operation when manufacturer string exists
    \param[in]  manufacturer_string: manufacturer string of usb device
    \param[out] none
    \retval     none
*/
void hs1_usbh_user_manufacturer_string(void *manufacturer_string)
{
    /* user code [local 0] begin */

    User_Debug_Log("> Manufacturer: %s\r\n", (char *)manufacturer_string);

    /* user code [local 0] end */
}

/*!
    \brief      user operation when manufacturer string exists
    \param[in]  product_string: product string of usb device
    \param[out] none
    \retval     none
*/
void hs1_usbh_user_product_string(void *product_string)
{
    /* user code [local 0] begin */

    User_Debug_Log("> Product: %s\r\n", (char *)product_string);

    /* user code [local 0] end */
}

/*!
    \brief      user operation when serialnum string exists
    \param[in]  serial_num_string: serialNum string of usb device
    \param[out] none
    \retval     none
*/
void hs1_usbh_user_serialnum_string(void *serial_num_string)
{
    /* user code [local 0] begin */

    User_Debug_Log("> Serial Number: %s\r\n", (char *)serial_num_string);

    /* user code [local 0] end */
}

/*!
    \brief      user response request is displayed to ask for application jump to class
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs1_usbh_user_enumeration_finish(void)
{
    /* user code [local 0] begin */

    User_Debug_Log("> Enumeration completed.\r\n");
    User_Debug_Log("> ----------------------\r\n");
    User_Debug_Log("> To start the HID class operations: \r\n");

    /* user code [local 0] end */
}

/*!
    \brief      user operation when device is not supported
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs1_usbh_user_device_not_supported(void)
{
    /* user code [local 0] begin */

    User_Debug_Log("> Device not supported.\r\n");

    /* user code [local 0] end */
}

/*!
    \brief      user action for application state entry
    \param[in]  none
    \param[out] none
    \retval     user response for user key
*/
usbh_user_status hs1_usbh_user_userinput(void)
{
    /* user code [local 0] begin */

    usbh_user_status usbh_usr_status = USBH_USER_NO_RESP;

    usbh_usr_status = USBH_USER_RESP_OK;

    return usbh_usr_status;

    /* user code [local 0] end */
}

/*!
    \brief      user action for device overcurrent detection event
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs1_usbh_user_over_current_detected(void)
{
    /* user code [local 0] begin */

    User_Debug_Log("> Overcurrent detected.\r\n");

    /* user code [local 0] end */
}

/*!
    \brief      init mouse window
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs1_usr_mouse_init(void)
{
    /* user code [local 0] begin */

    User_Debug_Log("> HID Demo Device : Mouse.\r\n");

    /* user code [local 0] end */
}

/*!
    \brief      process mouse data
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs1_usr_mouse_process_data(hid_mouse_info *data)
{
    /* user code [local 0] begin */

    if ((0U != data->x) && (0U != data->y)) {
       User_Debug_Log("> X = %d, Y = %d.\r\n", data->x, data->y);
    }

    /* user code [local 0] end */
}

/*!
    \brief      init keyboard window
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs1_usr_keybrd_init(void)
{
    /* user code [local 0] begin */

    User_Debug_Log("> HID Demo Device : Keyboard.\r\n");
    User_Debug_Log("> Use Keyboard to type in characters: \r\n");

    /* user code [local 0] end */
}

/*!
    \brief      process keyboard data
    \param[in]  data: keyboard data to be displayed
    \param[out] none
    \retval     none
*/
void hs1_usr_keybrd_process_data(uint8_t data)
{
    /* user code [local 0] begin */

    User_Debug_Log("> User type in %c\n", data);

    /* user code [local 0] end */
}

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Function Implementations] begin */

/* user code [Private Function Implementations] end */

