[#ftl]
[#-- V1.3.0 --]
/*!
    \file    hs1_usbh_conf.h
    \brief   USB host driver configuration

    \version 2025-10-21, V1.0.0,  firmware for GD32H75E
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef __HS1_USBH_CONF_H
#define __HS1_USBH_CONF_H

#ifdef __cplusplus
extern "C" {
#endif

/* External Includes*/
#include "hs1_usb_conf.h"
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Type Definitions] begin */

/* user code [Type Definitions] end */

/* Shared Macros */
#define HS1_HOST_MAX_EP_NUM                         ${USB1_HOST_Mode_HumanInterfaceHostClassParametersConfiguration_HostMaximumEndpointNumber}
#define HS1_HOST_MAX_INTERFACES_NUM                 ${USB1_HOST_Mode_HumanInterfaceHostClassParametersConfiguration_HostMaximumInterfaceNumber}
#define HS1_HOST_MAX_ALT_SETTING                    ${USB1_HOST_Mode_HumanInterfaceHostClassParametersConfiguration_HostMaximumAlternateSetting}
#define HS1_HOST_MAX_SUPPORTED_CLASS                ${USB1_HOST_Mode_HumanInterfaceHostClassParametersConfiguration_HostMaximumSupportedClass}
[#if USB1_HOST_Mode_HumanInterfaceHostClassParametersConfiguration_HostConfigureDescriptorKeep == "Enable"]
#define HS1_HOST_CFG_DESC_KEEP                      ENABLE
[#else]
#define HS1_HOST_CFG_DESC_KEEP                      DISABLE
[/#if]
#define HS1_HOST_DATA_BUF_MAX_LEN                   ${USB1_HOST_Mode_HumanInterfaceHostClassParametersConfiguration_HostDataBufferMaximumLength}
#define HS1_HOST_CFGSET_MAX_LEN                     ${USB1_HOST_Mode_HumanInterfaceHostClassParametersConfiguration_HostConfigureSetMaximumLength}
[#if USB1_HOST_Mode_HumanInterfaceHostClassParametersConfiguration_HostUserDebugLog == "Enable"]
#define HS1_HOST_USER_DEBUG_LOG                     ENABLE
[#else]
#define HS1_HOST_USER_DEBUG_LOG                     DISABLE
[/#if]

[#if USBHS1_USB1Host_SOFSignalOutput ??==true]
[#if USBHS1_USB1Host_SOFSignalOutput == "Enable"]
#define HS1_USB_SOF_OUTPUT                          ENABLE
[#elseif USBHS1_USB1Host_SOFSignalOutput == "Disable"]
#define HS1_USB_SOF_OUTPUT                          DISABLE
[/#if]
[/#if]

[#if USBHS1_HostFIFOSize_AllocatedRXFIFOSize ??==true]
#define HS1_RX_FIFO_SIZE                            ${USBHS1_HostFIFOSize_AllocatedRXFIFOSize}
[#else]
#define HS1_RX_FIFO_SIZE                            512
[/#if]
[#if USBHS1_HostFIFOSize_AllocatedPeriodicTXFIFOSize ??==true]
#define HS1_USB_HTX_PFIFO_SIZE                      ${USBHS1_HostFIFOSize_AllocatedPeriodicTXFIFOSize}
[#else]
#define HS1_USB_HTX_PFIFO_SIZE                      256
[/#if]
[#if USBHS1_HostFIFOSize_AllocatedNonperiodicTXFIFOSize ??==true]
#define HS1_USB_HTX_NPFIFO_SIZE                     ${USBHS1_HostFIFOSize_AllocatedNonperiodicTXFIFOSize}
[#else]
#define HS1_USB_HTX_NPFIFO_SIZE                     256
[/#if]

[#if USBHS1_GeneralConfiguration_InternalDMA ??== true && USBHS1_GeneralConfiguration_InternalDMA == "Enable"]
#define HS1_USB_INTERNAL_DMA_ENABLED
[/#if]

#if (ENABLE == HS1_HOST_USER_DEBUG_LOG)
#define User_Debug_Log(...) do { \
                                 \
                                 printf(__VA_ARGS__);\
                               } while (0)
#else
#define User_Debug_Log(...) do {} while (0)
#endif

extern uint32_t hs1_usbh_irq (void);
extern void hs1_usbh_wakeup_irq(void);

/* user code [Shared Macros] begin */

/* user code [Shared Macros] end */


/* External Constants */
/* user code [External Constants] begin */

/* user code [External Constants] end */

/* External Variables */
/* user code [External Variables] begin */

/* user code [External Variables] end */

/* Public Functions */
void msd_usbhs1_host_init(void);
/* user code [Public Functions] begin */

/* user code [Public Functions] end */

#ifdef __cplusplus
}
#endif

#endif /* __HS1_USBH_CONF_H */
