/*!
    \file    drv_usbh_int.h.h
    \brief   USB host mode interrupt management header file

    \version 2025-10-21, V1.0.0,  firmware for GD32H75E
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef __DRV_USBH_INT_H
#define __DRV_USBH_INT_H

#include "drv_usb_host.h"
#include "usbh_core.h"

#if (defined USE_USBHS0_HOST_HID) || (defined USE_USBHS0_HOST_MSC)
typedef struct _hs0_usbh_int_cb
{
    uint8_t (*connect)          (hs0_usbh_host *uhost);
    uint8_t (*disconnect)       (hs0_usbh_host *uhost);
    uint8_t (*port_enabled)     (hs0_usbh_host *uhost);
    uint8_t (*port_disabled)    (hs0_usbh_host *uhost);
    uint8_t (*SOF)              (hs0_usbh_host *uhost);
} hs0_usbh_int_cb;

extern hs0_usbh_int_cb *hs0_usbh_int_fop;
#endif /* USE_USBHS0_HOST_HID || USE_USBHS0_HOST_MSC */

#if (defined USE_USBHS1_HOST_HID) || (defined USE_USBHS1_HOST_MSC)
typedef struct _hs1_usbh_int_cb
{
    uint8_t (*connect)          (hs1_usbh_host *uhost);
    uint8_t (*disconnect)       (hs1_usbh_host *uhost);
    uint8_t (*port_enabled)     (hs1_usbh_host *uhost);
    uint8_t (*port_disabled)    (hs1_usbh_host *uhost);
    uint8_t (*SOF)              (hs1_usbh_host *uhost);
} hs1_usbh_int_cb;

extern hs1_usbh_int_cb *hs1_usbh_int_fop;
#endif /* USE_USBHS1_HOST_HID || USE_USBHS1_HOST_MSC */

/* function declarations */
#if (defined USE_USBHS0_HOST_HID) || (defined USE_USBHS0_HOST_MSC)
/* handle global host interrupt */
uint32_t hs0_usbh_irq (void);
void hs0_usbh_wakeup_irq(void);
#endif /* USE_USBHS0_HOST_HID || USE_USBHS0_HOST_MSC */

#if (defined USE_USBHS1_HOST_HID) || (defined USE_USBHS1_HOST_MSC)
/* handle global host interrupt */
uint32_t hs1_usbh_irq (void);
void hs1_usbh_wakeup_irq(void);
#endif /* USE_USBHS1_HOST_HID || USE_USBHS1_HOST_MSC */

#endif /* __DRV_USBH_INT_H */
