[#ftl]
[#-- V1.4.0 --]
/*!
    \file    hs0_usbd_conf.h
    \brief   the header file of USB device configuration

    \version 2025-10-21, V1.0.0,  firmware for GD32H75E
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef __HS0_USBD_CONF_H
#define __HS0_USBD_CONF_H

#ifdef __cplusplus
extern "C" {
#endif

/* External Includes*/
#include "hs0_usb_conf.h"
#include "drv_usb_hw.h"
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Shared Macros */
#define HS0_DEVICE_MAX_CONF_NUM             ${USB0_DEVICE_Mode_AudioDeviceClassParametersConfiguration_DeviceMaxConfigurationNumber}
#define HS0_DEVICE_MAX_ITF_NUM              ${USB0_DEVICE_Mode_AudioDeviceClassParametersConfiguration_DeviceMaxInterfaceNumber}
#define HS0_DEVICE_BOS_DESC_LEN             ${USB0_DEVICE_Mode_AudioDeviceClassParametersConfiguration_DeviceBOSDescriptorLength}
[#if USB0_DEVICE_Mode_AudioDeviceClassParametersConfiguration_DeviceSelfPowered == "Enable"]
#define HS0_DEVICE_SELF_POWERED             ENABLE
[#else]
#define HS0_DEVICE_SELF_POWERED             DISABLE
[/#if]

#define HS0_USBD_SPEAKER_FREQ               ${USB0_DEVICE_Mode_AudioDeviceClassParametersConfiguration_AudioSpeakerFrequency}

[#if USBHS0_USB0Device_SOFSignalOutput == "Enable"]
#define HS0_USB_SOF_OUTPUT                  ENABLE
[#else]
#define HS0_USB_SOF_OUTPUT                  DISABLE
[/#if]
[#if USBHS0_USB0Device_LowPowerMode == "Enable"]
#define HS0_USB_LOW_POWER                   ENABLE
[#else]
#define HS0_USB_LOW_POWER                   DISABLE
[/#if]
[#if USBHS0_USB0Device_VBUSSensingConfiguration == "Enable"]
#define HS0_VBUS_SENSING                    ENABLE
[#else]
#define HS0_VBUS_SENSING                    DISABLE
[/#if]
[#if USBHS0_USB0Device_LinkPowerManagement == "Enable"]
#define HS0_LPM_ENABLE                      ENABLE
[#else]
#define HS0_LPM_ENABLE                      DISABLE
[/#if]
[#if USBHS0_USB0Device_DedicatedEndpoint1Configuration == "Enable"]
#define HS0_DEDICATED_EP1_ENABLED

extern uint32_t hs0_usbd_int_dedicated_ep1out (void);
extern uint32_t hs0_usbd_int_dedicated_ep1in (void);
[/#if]

[#if USBHS0_GeneralConfiguration_InternalDMA ??== true && USBHS0_GeneralConfiguration_InternalDMA == "Enable"]
#define HS0_USB_INTERNAL_DMA_ENABLED
[/#if]

#if HS0_VBUS_SENSING
#define VBUS_SENSING_ENABLED
#endif

#if HS0_BCD_ENABLE
#define Battery_Charging_Detection_ENABLED
#endif

#if HS0_LPM_ENABLE
#define HS0_USE_BOS_DESC   ENABLE
#endif

#if !defined (HS0_USE_BOS_DESC)
[#if USBHS0_USB0Device_BOSDescriptorConfiguration == "Enable"]
#define HS0_USE_BOS_DESC   ENABLE
[#else]
#define HS0_USE_BOS_DESC   DISABLE
[/#if]
#endif

extern void hs0_usbd_irq (void);
extern void hs0_usbd_wakeup_irq(void);

/* user code [Shared Macros] begin */

/* user code [Shared Macros] end */

/* External Constants  */
/* user code [External Constants] begin */

/* user code [External Constants] end */

/* External Variables */
/* user code [External Variables] begin */

/* user code [External Variables] end */

/* Public Functions */
void hs0_string_get(void);
void msd_usbhs0_device_init(void);
/* user code [Public Functions] begin */

/* user code [Public Functions] end */

#ifdef __cplusplus
}
#endif

#endif /* __HS0_USBD_CONF_H */
