[#ftl]
[#-- V1.4.0 --]
/*!
    \file    hs1_usbd_conf.h
    \brief   the header file of USB device configuration

    \version 2025-10-21, V1.0.0,  firmware for GD32H75E
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef __HS1_USBD_CONF_H
#define __HS1_USBD_CONF_H

#ifdef __cplusplus
extern "C" {
#endif

/* External Includes*/
#include "hs1_usb_conf.h"
#include "drv_usb_hw.h"
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Shared Macros */
#define HS1_DEVICE_MAX_CONF_NUM             ${USB1_DEVICE_Mode_MassStorageClassParametersConfiguration_DeviceMaxConfigurationNumber}
#define HS1_DEVICE_MAX_ITF_NUM              ${USB1_DEVICE_Mode_MassStorageClassParametersConfiguration_DeviceMaxInterfaceNumber}
#define HS1_DEVICE_BOS_DESC_LEN             ${USB1_DEVICE_Mode_MassStorageClassParametersConfiguration_DeviceBOSDescriptorLength}
[#if USB1_DEVICE_Mode_MassStorageClassParametersConfiguration_DeviceSelfPowered == "Enable"]
#define HS1_DEVICE_SELF_POWERED             ENABLE
[#else]
#define HS1_DEVICE_SELF_POWERED             DISABLE
[/#if]

#define HS1_MSC_MEDIA_PACKET_SIZE           ${USB1_DEVICE_Mode_MassStorageClassParametersConfiguration_StorageMediaPacketBufferSize}

[#if USBHS1_USB1Device_SOFSignalOutput == "Enable"]
#define HS1_USB_SOF_OUTPUT                  ENABLE
[#else]
#define HS1_USB_SOF_OUTPUT                  DISABLE
[/#if]
[#if USBHS1_USB1Device_LowPowerMode == "Enable"]
#define HS1_USB_LOW_POWER                   ENABLE
[#else]
#define HS1_USB_LOW_POWER                   DISABLE
[/#if]
[#if USBHS1_USB1Device_VBUSSensingConfiguration == "Enable"]
#define HS1_VBUS_SENSING                    ENABLE
[#else]
#define HS1_VBUS_SENSING                    DISABLE
[/#if]
[#if USBHS1_USB1Device_LinkPowerManagement == "Enable"]
#define HS1_LPM_ENABLE                      ENABLE
[#else]
#define HS1_LPM_ENABLE                      DISABLE
[/#if]
[#if USBHS1_USB1Device_DedicatedEndpoint1Configuration == "Enable"]
#define HS1_DEDICATED_EP1_ENABLED

extern uint32_t hs1_usbd_int_dedicated_ep1out (void);
extern uint32_t hs1_usbd_int_dedicated_ep1in (void);
[/#if]

[#if USBHS1_GeneralConfiguration_InternalDMA == "Enable"]
#define HS1_USB_INTERNAL_DMA_ENABLED
[/#if]

#if HS1_VBUS_SENSING
#define VBUS_SENSING_ENABLED
#endif

#if HS1_BCD_ENABLE
#define Battery_Charging_Detection_ENABLED
#endif

#if HS1_LPM_ENABLE
#define HS1_USE_BOS_DESC   ENABLE
#endif

#if !defined (HS1_USE_BOS_DESC)
[#if USBHS1_USB1Device_BOSDescriptorConfiguration == "Enable"]
#define HS1_USE_BOS_DESC   ENABLE
[#else]
#define HS1_USE_BOS_DESC   DISABLE
[/#if]
#endif

/* class layer parameter */
#define HS1_MSC_IN_EP                   EP1_IN
#define HS1_MSC_OUT_EP                  EP1_OUT

[#if USBHS1_GeneralConfiguration_Speed == "High Speed"]
#define HS1_MSC_DATA_PACKET_SIZE        512
[#else]
#define HS1_MSC_DATA_PACKET_SIZE        64U
[/#if]
#define HS1_MEM_LUN_NUM                 1U

#define HS1_USBD_MSC_INTERFACE          0U

extern void hs1_usbd_irq (void);
extern void hs1_usbd_wakeup_irq(void);




/* user code [Shared Macros] begin */

/* user code [Shared Macros] end */

/* External Constants  */
/* user code [External Constants] begin */

/* user code [External Constants] end */

/* External Variables */
/* user code [External Variables] begin */

/* user code [External Variables] end */

/* Public Functions */
void hs1_string_get(void);
void msd_usbhs1_device_init(void);
/* user code [Public Functions] begin */

/* user code [Public Functions] end */

#ifdef __cplusplus
}
#endif

#endif /* __HS1_USBD_CONF_H */
