[#ftl]
/*!
    \file    hs_usbh_usr.c
    \brief   some user routines

    \version 2025-07-30, V1.0.0, firmware for GD32F5xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/


#include "hs_usbh_usr.h"
#include "usbh_hid_core.h"
#include "usbh_standard_hid.h"
#include "gd32f527_init.h"

#include <stdio.h>
#include <string.h>

/* External Includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

#if (1U ==  HS_HOST_USER_DEBUG_LOG)
#define User_Debug_Log(...) do { \
                                 \
                                 printf(__VA_ARGS__);\
                               } while (0)
#else
#define User_Debug_Log(__type__,...) \
    do { \
        User_Debug_LCD_Log(__type__, __VA_ARGS__); \
    } while (0)
#endif
uint16_t hs_keyboard_char_xpos = 0;
uint16_t hs_keyboard_char_ypos = 0;
/* user code [Private Type Definitions] end */

/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Extern Variables */
/* user code [Extern Variables] begin */
extern int16_t XLoc, YLoc;
extern __IO int16_t PrevX, PrevY;
extern hs_usbh_host hs_usb_host;
extern usb_core_driver usb_hid_core;
/* user code [Extern Variables] end */

/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Points to the DEVICE_PROP structure of current device */
usbh_user_cb hs_usr_cb =
{
    hs_usbh_user_init,
    hs_usbh_user_deinit,
    hs_usbh_user_device_connected,
    hs_usbh_user_device_reset,
    hs_usbh_user_device_disconnected,
    hs_usbh_user_over_current_detected,
    hs_usbh_user_device_speed_detected,
    hs_usbh_user_device_desc_available,
    hs_usbh_user_device_address_assigned,
    hs_usbh_user_configuration_descavailable,
    hs_usbh_user_manufacturer_string,
    hs_usbh_user_product_string,
    hs_usbh_user_serialnum_string,
    hs_usbh_user_enumeration_finish,
    hs_usbh_user_userinput,
    NULL,
    hs_usbh_user_device_not_supported,
    hs_usbh_user_unrecovered_error
};

const uint8_t HS_MSG_HOST_HEADER[] = "USBHS HID Host";
const uint8_t HS_MSG_HOST_FOOTER[] = "USB Host Library v3.0.0";

/*!
    \brief      user operation for host-mode initialization
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs_usbh_user_init(void)
{
    static uint8_t startup = 0U;
    /* user code [hs_usbh_user_init local 0] begin */

    /* user code [hs_usbh_user_init local 0] end */
    if(0U == startup) {
        startup = 1U;
        /* user code [hs_usbh_user_init local 1] begin */
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
        User_Debug_Log("> USB host library started \r\n");
#else
        User_Debug_Log(LCD_LOG_TYPE_USER, "> USB host library started \r\n");
#endif
        /* user code [hs_usbh_user_init local 1] end */
    }
    /* user code [hs_usbh_user_init local 2] begin */

    /* user code [hs_usbh_user_init local 2] end */
}

/*!
    \brief      deinit user state and associated variables
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs_usbh_user_deinit(void)
{
    /* user code [hs_usbh_user_deinit local 0] begin */

    /* user code [hs_usbh_user_deinit local 0] end */
}

/*!
    \brief      user operation for device attached
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs_usbh_user_device_connected(void)
{
    /* user code [hs_usbh_user_device_connected local 0] begin */
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
    User_Debug_Log("> Device Attached.\r\n");
#else
    User_Debug_Log(LCD_LOG_TYPE_USER, "> Device Attached.\r\n");
#endif
    /* user code [hs_usbh_user_device_connected local 0] end */
}

/*!
    \brief      user operation for unrecovered error happens
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs_usbh_user_unrecovered_error(void)
{
    /* user code [hs_usbh_user_unrecovered_error local 0] begin */
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
    User_Debug_Log("> Unrecovered Error State.\r\n");
#else
    User_Debug_Log(LCD_LOG_TYPE_ERROR, "> Unrecovered Error State.\r\n");
#endif
    /* user code [hs_usbh_user_unrecovered_error local 0] end */
}

/*!
    \brief      user operation for device disconnect event
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs_usbh_user_device_disconnected(void)
{
    /* user code [hs_usbh_user_device_disconnected local 0] begin */
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
    User_Debug_Log("> Device Disconnected.\r\n");
#else
    User_Debug_Log(LCD_LOG_TYPE_USER, "> Device Disconnected.\r\n");
#endif
    /* user code [hs_usbh_user_device_disconnected local 0] end */
}

/*!
    \brief      user operation for reset USB Device
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs_usbh_user_device_reset(void)
{
    /* user code [hs_usbh_user_device_reset local 0] begin */
    /* users can do their application actions here for the USB-Reset */
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
    User_Debug_Log("> Reset the USB device.\r\n");
#else
    User_Debug_Log(LCD_LOG_TYPE_USER, "> Reset the USB device.\r\n");
#endif
    /* user code [hs_usbh_user_device_reset local 0] end */
}

/*!
    \brief      user operation for detecting device speed
    \param[in]  DeviceSpeed: device speed
    \param[out] none
    \retval     none
*/
void hs_usbh_user_device_speed_detected(uint32_t device_speed)
{
    /* user code [hs_usbh_user_device_speed_detected local 0] begin */
    if (PORT_SPEED_HIGH == device_speed) {
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
        User_Debug_Log("> High speed device detected.\r\n");
#else
        User_Debug_Log(LCD_LOG_TYPE_USER, "> High speed device detected.\r\n");
#endif
    } else if(PORT_SPEED_FULL == device_speed) {
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
        User_Debug_Log("> Full speed device detected.\r\n");
#else
        User_Debug_Log(LCD_LOG_TYPE_USER, "> Full speed device detected.\r\n");
#endif
    } else if(PORT_SPEED_LOW == device_speed) {
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
        User_Debug_Log("> Low speed device detected.\r\n");
#else
        User_Debug_Log(LCD_LOG_TYPE_USER, "> Low speed device detected.\r\n");
#endif
    } else {
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
        User_Debug_Log("> Device Fault.\r\n");
#else
        User_Debug_Log(LCD_LOG_TYPE_ERROR, "> Device Fault.\r\n");
#endif
    }
    /* user code [hs_usbh_user_device_speed_detected local 0] end */
}

/*!
    \brief      user operation when device descriptor is available
    \param[in]  device_desc: device descriptor
    \param[out] none
    \retval     none
*/
void hs_usbh_user_device_desc_available(void *device_desc)
{
    usb_desc_dev *pDevStr = device_desc;
    /* user code [hs_usbh_user_device_desc_available local 0] begin */

#if (1U ==  HS_HOST_USER_DEBUG_LOG)
    User_Debug_Log("> VID: %04Xh \r\n", (uint32_t)pDevStr->idVendor);
    User_Debug_Log("> PID: %04Xh \r\n", (uint32_t)pDevStr->idProduct);
#else
    User_Debug_Log(LCD_LOG_TYPE_USER, "> VID: %04Xh \r\n", (uint32_t)pDevStr->idVendor);
    User_Debug_Log(LCD_LOG_TYPE_USER, "> PID: %04Xh \r\n", (uint32_t)pDevStr->idProduct);
#endif
    /* user code [hs_usbh_user_device_desc_available local 0] end */
}

/*!
    \brief      USB device is successfully assigned the address
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs_usbh_user_device_address_assigned(void)
{
    /* user code [hs_usbh_user_device_address_assigned local 0] begin */

    /* user code [hs_usbh_user_device_address_assigned local 0] end */
}

/*!
    \brief      user operation when configuration descriptor is available
    \param[in]  cfg_desc: pointer to configuration descriptor
    \param[in]  itf_desc: pointer to interface descriptor
    \param[in]  ep_desc: pointer to endpoint descriptor
    \param[out] none
    \retval     none
*/
void hs_usbh_user_configuration_descavailable(usb_desc_config *cfg_desc,
                                               usb_desc_itf *itf_desc,
                                               usb_desc_ep *ep_desc)
{
    usb_desc_itf *id = itf_desc;
    /* user code [hs_usbh_user_configuration_descavailable local 0] begin */
    if (0x08U == (*id).bInterfaceClass) {
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
        User_Debug_Log("> Mass storage device connected.\r\n");
#else
        User_Debug_Log(LCD_LOG_TYPE_USER, "> Mass storage device connected.\r\n");
#endif
    } else if (0x03U == (*id).bInterfaceClass) {
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
        User_Debug_Log("> HID device connected.\r\n");
#else
        User_Debug_Log(LCD_LOG_TYPE_USER, "> HID device connected.\r\n");
#endif
    }
    /* user code [hs_usbh_user_configuration_descavailable local 0] end */
}

/*!
    \brief      user operation when manufacturer string exists
    \param[in]  manufacturer_string: manufacturer string of usb device
    \param[out] none
    \retval     none
*/
void hs_usbh_user_manufacturer_string(void *manufacturer_string)
{
    /* user code [hs_usbh_user_manufacturer_string local 0] begin */
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
    User_Debug_Log("> Manufacturer: %s\r\n", (char *)manufacturer_string);
#else
    User_Debug_Log(LCD_LOG_TYPE_INFO, "> Manufacturer: %s\r\n", (char *)manufacturer_string);
#endif
    /* user code [hs_usbh_user_manufacturer_string local 0] end */
}

/*!
    \brief      user operation when manufacturer string exists
    \param[in]  product_string: product string of usb device
    \param[out] none
    \retval     none
*/
void hs_usbh_user_product_string(void *product_string)
{
    /* user code [hs_usbh_user_product_string local 0] begin */
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
    User_Debug_Log("> Product: %s\r\n", (char *)product_string);
#else
    User_Debug_Log(LCD_LOG_TYPE_INFO, "> Product: %s\r\n", (char *)product_string);
#endif
    /* user code [hs_usbh_user_product_string local 0] end */
}

/*!
    \brief      user operation when serialnum string exists
    \param[in]  serial_num_string: serialNum string of usb device
    \param[out] none
    \retval     none
*/
void hs_usbh_user_serialnum_string(void *serial_num_string)
{
    /* user code [hs_usbh_user_serialnum_string local 0] begin */
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
    User_Debug_Log("> Serial Number: %s\r\n", (char *)serial_num_string);
#else
    User_Debug_Log(LCD_LOG_TYPE_INFO, "> Serial Number: %s\r\n", (char *)serial_num_string);
#endif
    /* user code [hs_usbh_user_serialnum_string local 0] end */
}

/*!
    \brief      user response request is displayed to ask for application jump to class
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs_usbh_user_enumeration_finish(void)
{
    /* user code [hs_usbh_user_enumeration_finish local 0] begin */
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
    User_Debug_Log("> Enumeration completed.\r\n");
    User_Debug_Log("> ----------------------\r\n");
    User_Debug_Log("> To start the HID class operations: \r\n");
#else
    User_Debug_Log(LCD_LOG_TYPE_USER, "> Enumeration completed.\r\n");
    User_Debug_Log(LCD_LOG_TYPE_USER, "> ----------------------\r\n");
    User_Debug_Log(LCD_LOG_TYPE_USER, "> To start the HID class operations: \r\n");
#endif
    /* user code [hs_usbh_user_enumeration_finish local 0] end */
}

/*!
    \brief      user operation when device is not supported
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs_usbh_user_device_not_supported(void)
{
    /* user code [hs_usbh_user_device_not_supported local 0] begin */
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
    User_Debug_Log("> Device not supported.\r\n");
#else
    User_Debug_Log(LCD_LOG_TYPE_ERROR, "> Device not supported.\r\n");
#endif
    /* user code [hs_usbh_user_device_not_supported local 0] end */
}

/*!
    \brief      user action for application state entry
    \param[in]  none
    \param[out] none
    \retval     user response for user key
*/
usbh_user_status hs_usbh_user_userinput(void)
{
    usbh_user_status usbh_usr_status = USR_IN_NO_RESP;

    /* user code [hs_usbh_user_userinput local 0] begin */
    usbh_usr_status = USR_IN_RESP_OK;
    /* user code [hs_usbh_user_userinput local 0] end */

    return usbh_usr_status;
}

/*!
    \brief      user action for device overcurrent detection event
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs_usbh_user_over_current_detected(void)
{
    /* user code [hs_usbh_user_over_current_detected local 0] begin */
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
    User_Debug_Log("> Overcurrent detected.\r\n");
#else
    User_Debug_Log(LCD_LOG_TYPE_ERROR, "> Overcurrent detected.\r\n");
#endif
    /* user code [hs_usbh_user_over_current_detected local 0] end */
}

/*!
    \brief      init mouse window
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs_usr_mouse_init(void)
{
    /* user code [hs_usr_mouse_init local 0] begin */
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
    User_Debug_Log("> HID Demo Device : Mouse.\r\n");
#else
    User_Debug_Log(LCD_LOG_TYPE_USER, "> HID Demo Device : Mouse.\r\n");
#endif
    /* user code [hs_usr_mouse_init local 0] end */
}

/*!
    \brief      process mouse data
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs_usr_mouse_process_data(mouse_report_data *data)
{
    /* user code [hs_usr_mouse_process_data local 0] begin */
    if ((0U != data->x) && (0U != data->y)) {
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
        User_Debug_Log("> X = %d, Y = %d.\r\n", data->x, data->y);
#else
        User_Debug_Log(LCD_LOG_TYPE_USER, "> X = %d, Y = %d.\r\n", data->x, data->y);
#endif
    }
    /* user code [hs_usr_mouse_process_data local 0] end */
}

/*!
    \brief      init keyboard window
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs_usr_keybrd_init(void)
{
    /* user code [hs_usr_keybrd_init local 0] begin */
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
    User_Debug_Log("> HID Demo Device : Keyboard.\r\n");
    User_Debug_Log("> Use Keyboard to type in characters: \r\n");
#else
    User_Debug_Log(LCD_LOG_TYPE_USER, "> HID Demo Device : Keyboard.\r\n");
    User_Debug_Log(LCD_LOG_TYPE_USER, "> Use Keyboard to type in characters: \r\n");
#endif
    /* user code [hs_usr_keybrd_init local 0] end */
}

/*!
    \brief      process keyboard data
    \param[in]  data: keyboard data to be displayed
    \param[out] none
    \retval     none
*/
void hs_usr_keybrd_process_data(uint8_t data)
{
    /* user code [hs_usr_keybrd_process_data local 0] begin */
#if (1U ==  HS_HOST_USER_DEBUG_LOG)
    User_Debug_Log("> User type in %c\n", data);
#else
    User_Debug_Log(LCD_LOG_TYPE_USER, "> User type in %c\n", data);
#endif
    /* user code [hs_usr_keybrd_process_data local 0] end */
}

/* user code [Private Function Implementations] begin */

/* user code [Private Function Implementations] end */

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */