[#ftl]
[#-- V1.2.0 --]
/*!
    \file    hs_usbd_desc.c
    \brief   the descriptor file of USB device

    \version 2025-07-30, V1.0.0, firmware for GD32F5xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "usbd_enum.h"

char* HS_LANG_ID_STR = "${USBHS_DEVICE_Mode_AudioDeviceClassStringConfiguration_LanguageID}";
char* HS_MANUFACTURER_STR = "${USBHS_DEVICE_Mode_AudioDeviceClassStringConfiguration_ManufacturerString}";
char* HS_PRODUCT_STR = "${USBHS_DEVICE_Mode_AudioDeviceClassStringConfiguration_ProductString}";
char* HS_CONFIGURATION_STR = "${USBHS_DEVICE_Mode_AudioDeviceClassStringConfiguration_ConfigurationString}";
char* HS_INTERFACE_STR = "${USBHS_DEVICE_Mode_AudioDeviceClassStringConfiguration_InterfaceString}";
char* HS_SERIAL_STR = "MCU F5xx";

extern usb_desc_dev hs_uac_dev_desc;

#define STRING_LENGTH(len) 2*len+2

/* USB language ID Descriptor */
__ALIGN_BEGIN usb_desc_LANGID hs_usbd_language_id_desc __ALIGN_END =
{
    .header =
     {
         .bLength         = sizeof(usb_desc_LANGID),
         .bDescriptorType = USB_DESCTYPE_STR
     }
};

/* USB manufacture string */
__ALIGN_BEGIN usb_desc_str hs_manufacturer_string __ALIGN_END =
{
    .header =
     {
         .bLength         = USB_STRING_LEN(10U),
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USB product string */
__ALIGN_BEGIN usb_desc_str hs_product_string __ALIGN_END =
{
    .header =
     {
         .bLength         = USB_STRING_LEN(14U),
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USBD serial string */
__ALIGN_BEGIN usb_desc_str hs_serial_string __ALIGN_END =
{
    .header =
     {
         .bLength         = USB_STRING_LEN(12U),
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USB configure string */
 __ALIGN_BEGIN usb_desc_str hs_configure_string __ALIGN_END =
{
    .header =
     {
         .bLength         = USB_STRING_LEN(15U),
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USB interface string */
__ALIGN_BEGIN usb_desc_str hs_interface_string __ALIGN_END =
{
    .header =
     {
         .bLength         = USB_STRING_LEN(12U),
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USB string descriptor */
void *hs_uac_strings_desc[] =
{
    [STR_IDX_LANGID]  = (uint8_t *)&hs_usbd_language_id_desc,
    [STR_IDX_MFC]     = (uint8_t *)&hs_manufacturer_string,
    [STR_IDX_PRODUCT] = (uint8_t *)&hs_product_string,
    [STR_IDX_SERIAL]  = (uint8_t *)&hs_serial_string,
    [STR_IDX_ITF]     = (uint8_t *)&hs_interface_string,
    [STR_IDX_CONFIG]  = (uint8_t *)&hs_configure_string
};

/*!
    \brief      initialize device descirptor and serial string descriptor
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs_string_get(void)
{
	uint16_t *unicode_str =  hs_uac_strings_desc[STR_IDX_SERIAL];
    /* set string serial */
    if (6U != (unicode_str[0] & 0x00FFU)) {
        uint32_t DeviceSerial0, DeviceSerial1, DeviceSerial2;

        DeviceSerial0 = *(uint32_t *)DEVICE_ID1;
        DeviceSerial1 = *(uint32_t *)DEVICE_ID2;
        DeviceSerial2 = *(uint32_t *)DEVICE_ID3;

        DeviceSerial0 += DeviceSerial2;

        if (0U != DeviceSerial0) {
            int_to_unicode(DeviceSerial0, (uint8_t *)&(unicode_str[1]), 8U);
            int_to_unicode(DeviceSerial1, (uint8_t *)&(unicode_str[9]), 4U);
        }
    } else {
        uint32_t device_serial = *(uint32_t *)DEVICE_ID;

        if(0U != device_serial) {
        	unicode_str[1] = (uint16_t)(device_serial & 0x0000FFFFU);
        	unicode_str[2] = (uint16_t)((device_serial & 0xFFFF0000U) >> 16U);
        }
    }

    /* set language ID */
    hs_usbd_language_id_desc.wLANGID = string_to_id(HS_LANG_ID_STR);
    /* set manufacturer, product and serial string */
    hs_manufacturer_string.header.bLength    = STRING_LENGTH(string_to_unicode(HS_MANUFACTURER_STR,(uint8_t*)&(hs_manufacturer_string.unicode_string[0])));
    string_to_unicode(HS_MANUFACTURER_STR, (uint8_t *)&(hs_manufacturer_string.unicode_string[0]));

    hs_product_string.header.bLength    = STRING_LENGTH(string_to_unicode(HS_PRODUCT_STR,(uint8_t*)&(hs_product_string.unicode_string[0])));
    string_to_unicode(HS_PRODUCT_STR, (uint8_t *)&(hs_product_string.unicode_string[0]));
    
    hs_configure_string.header.bLength    = STRING_LENGTH(string_to_unicode(HS_CONFIGURATION_STR,(uint8_t*)&(hs_configure_string.unicode_string[0])));
    string_to_unicode(HS_CONFIGURATION_STR, (uint8_t *)&(hs_configure_string.unicode_string[0]));

    hs_interface_string.header.bLength    = STRING_LENGTH(string_to_unicode(HS_INTERFACE_STR,(uint8_t*)&(hs_interface_string.unicode_string[0])));
    string_to_unicode(HS_INTERFACE_STR,(uint8_t*)&(hs_interface_string.unicode_string[0]));
}    
