[#ftl]
[#-- V1.0 --]
/*!
    \file    hs_usbd_conf.h
    \brief   the header file of USB device configuration

    \version 2025-07-30, V1.0.0, firmware for GD32F5xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef __HS_USBD_CONF_H
#define __HS_USBD_CONF_H

#include "hs_usb_conf.h"
#include "drv_usb_hw.h"

extern void hs_usbd_irq (void);
extern void hs_usbd_wakeup_irq(void);
extern void hs_string_get(void);

#define HS_VID_STR                         ${USBHS_DEVICE_Mode_MassStorageClassStringConfiguration_VendorID}
#define HS_PID_STR                         ${USBHS_DEVICE_Mode_MassStorageClassStringConfiguration_ProductID}
#define HS_DEVICE_MAX_CONF_NUM             ${USBHS_DEVICE_Mode_MassStorageClassParametersConfiguration_DeviceMaxConfigurationNumber}
#define HS_DEVICE_MAX_ITF_NUM              ${USBHS_DEVICE_Mode_MassStorageClassParametersConfiguration_DeviceMaxInterfaceNumber}
#define HS_DEVICE_BOS_DESC_LEN             ${USBHS_DEVICE_Mode_MassStorageClassParametersConfiguration_DeviceBOSDescriptorLength}
[#if USBHS_DEVICE_Mode_MassStorageClassParametersConfiguration_DeviceSelfPowered == "Enable"]
#define HS_DEVICE_SELF_POWERED             ENABLE
[#else]
#define HS_DEVICE_SELF_POWERED             DISABLE
[/#if]

#define HS_MSC_MEDIA_PACKET_SIZE           ${USBHS_DEVICE_Mode_MassStorageClassParametersConfiguration_StorageMediaPacketBufferSize}

[#if USBHS_USBHSDevice_SOFSignalOutput == "Enable"]
#define HS_USB_SOF_OUTPUT                  ENABLE
[#else]
#define HS_USB_SOF_OUTPUT                  DISABLE
[/#if]
[#if USBHS_USBHSDevice_LowPowerMode == "Enable"]
#define HS_USB_LOW_POWER                   ENABLE
[#else]
#define HS_USB_LOW_POWER                   DISABLE
[/#if]
[#if USBHS_USBHSDevice_VBUSSensingConfiguration == "Enable"]
#define HS_VBUS_SENSING                    ENABLE
[#else]
#define HS_VBUS_SENSING                    DISABLE
[/#if]
[#if USBHS_USBHSDevice_LinkPowerManagement == "Enable"]
#define HS_LPM_ENABLE                      ENABLE
[#else]
#define HS_LPM_ENABLE                      DISABLE
[/#if]

[#if USBHS_USBHSDevice_DedicatedEndpoint1Configuration == "Enable"]
#define USB_HS_DEDICATED_EP1_ENABLED

extern uint32_t usbd_int_dedicated_ep1out (void);
extern uint32_t usbd_int_dedicated_ep1in (void);
[/#if]

[#if USBHS_GeneralConfiguration_InternalDMA ??== true && USBHS_GeneralConfiguration_InternalDMA == "Enable"]
#define USB_HS_INTERNAL_DMA_ENABLED
[/#if]

#if HS_VBUS_SENSING
#define HS_VBUS_SENSING_ENABLED
#endif

#if HS_LPM_ENABLE
#define HS_USE_BOS_DESC   ENABLE
#endif

#if !defined (HS_USE_BOS_DESC)
[#if USBHS_USBHSDevice_BOSDescriptorConfiguration == "Enable"]
#define HS_USE_BOS_DESC   ENABLE
[#else]
#define HS_USE_BOS_DESC   DISABLE
[/#if]
#endif

/* class layer parameter */
#define HS_MSC_IN_EP                   EP1_IN
#define HS_MSC_OUT_EP                  EP1_OUT

[#if USBHS_GeneralConfiguration_Speed == "High Speed"]
#define HS_MSC_DATA_PACKET_SIZE        512U
[#else]
#define HS_MSC_DATA_PACKET_SIZE        64U
[/#if]
#define HS_MEM_LUN_NUM                 1U

#define HS_USBD_MSC_INTERFACE          0U

#ifdef USB_HS_DEDICATED_EP1_ENABLED
#define hs_usbd_int_dedicated_ep1out() usbd_int_dedicated_ep1out()
#define hs_usbd_int_dedicated_ep1in() usbd_int_dedicated_ep1in()
#endif

void msd_usbhs_device_init(void);

#endif /* __HS_USBD_CONF_H */
