/*!
    \file    usbd_msc_core.h
    \brief   the header file of USB MSC device class core functions

    \version 2025-02-23, V1.0.0, firmware for GD32F5xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/

#ifndef __USBD_MSC_CORE_H
#define __USBD_MSC_CORE_H

#include "usbd_core.h"
#include "usb_msc.h"

#define USB_MSC_CONFIG_DESC_SIZE          32U

#ifdef USE_USBFS_DEVICE
#define FS_MSC_EPIN_SIZE                 FS_MSC_DATA_PACKET_SIZE
#define FS_MSC_EPOUT_SIZE                FS_MSC_DATA_PACKET_SIZE

extern usb_desc fs_msc_desc;
extern usb_class_core fs_msc_class;
#endif /* USE_USBFS_DEVICE */
#ifdef USE_USBHS_DEVICE
#define HS_MSC_EPIN_SIZE                 HS_MSC_DATA_PACKET_SIZE
#define HS_MSC_EPOUT_SIZE                HS_MSC_DATA_PACKET_SIZE

extern usb_desc hs_msc_desc;
extern usb_class_core hs_msc_class;
#endif /* USE_USBHS_DEVICE */

/* USB configuration descriptor structure */
typedef struct
{
    usb_desc_config         config;

    usb_desc_itf            msc_itf;
    usb_desc_ep             msc_epin;
    usb_desc_ep             msc_epout;
} usb_desc_config_set;

#endif /* __USBD_MSC_CORE_H */
