[#ftl]
[#-- V1.0 --]
/*!
    \file    fs_usbd_conf.h
    \brief   the header file of USB device configuration

    \version 2025-07-30, V1.0.0, firmware for GD32F5xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef __FS_USBD_CONF_H
#define __FS_USBD_CONF_H

#include "fs_usb_conf.h"
#include "drv_usb_hw.h"

extern void fs_usbd_irq (void);
extern void fs_usbd_wakeup_irq(void);
extern void fs_string_get(void);

#define FS_VID_STR 			   ${USBFS_DEVICE_Mode_HumanInterfaceDeviceStringConfiguration_VendorID}
#define FS_PID_STR 			   ${USBFS_DEVICE_Mode_HumanInterfaceDeviceStringConfiguration_ProductID}

#define FS_DEVICE_MAX_CONF_NUM             ${USBFS_DEVICE_Mode_HumanInterfaceDeviceParametersConfiguration_DeviceMaxConfigurationNumber}
#define FS_DEVICE_MAX_ITF_NUM              ${USBFS_DEVICE_Mode_HumanInterfaceDeviceParametersConfiguration_DeviceMaxInterfaceNumber}
#define FS_DEVICE_BOS_DESC_LEN             ${USBFS_DEVICE_Mode_HumanInterfaceDeviceParametersConfiguration_DeviceBOSDescriptorLength}
[#if USBFS_DEVICE_Mode_HumanInterfaceDeviceParametersConfiguration_DeviceSelfPowered == "Enable"]
#define FS_DEVICE_SELF_POWERED             ENABLE
[#else]
#define FS_DEVICE_SELF_POWERED             DISABLE
[/#if]

[#if USBFS_DEVICE_Mode_HumanInterfaceDeviceParametersConfiguration_DeviceRemoteWakeup == "Enable"]
#define FS_DEVICE_REMOTE_WAKEUP            ENABLE
[#else]
#define FS_DEVICE_REMOTE_WAKEUP            DISABLE
[/#if]
#define FS_HID_INTERVAL                    ${USBFS_DEVICE_Mode_HumanInterfaceDeviceParametersConfiguration_HIDIntervalFrameNumber}

[#if USBFS_USBFSDevice_SOFSignalOutput == "Enable"]
#define FS_USB_SOF_OUTPUT                  ENABLE
[#else]
#define FS_USB_SOF_OUTPUT                  DISABLE
[/#if]
[#if USBFS_USBFSDevice_LowPowerMode == "Enable"]
#define FS_USB_LOW_POWER                   ENABLE
[#else]
#define FS_USB_LOW_POWER                   DISABLE
[/#if]
[#if USBFS_USBFSDevice_VBUSSensingConfiguration == "Enable"]
#define FS_VBUS_SENSING                    ENABLE
[#else]
#define FS_VBUS_SENSING                    DISABLE
[/#if]
[#if USBFS_USBFSDevice_LinkPowerManagement == "Enable"]
#define FS_LPM_ENABLE                      ENABLE
[#else]
#define FS_LPM_ENABLE                      DISABLE
[/#if]

#if FS_VBUS_SENSING
#define FS_VBUS_SENSING_ENABLED
#endif

#if FS_LPM_ENABLE
#define FS_USE_BOS_DESC   ENABLE
#endif

#if !defined (FS_USE_BOS_DESC)
[#if USBFS_USBFSDevice_BOSDescriptorConfiguration == "Enable"]
#define FS_USE_BOS_DESC   ENABLE
[#else]
#define FS_USE_BOS_DESC   DISABLE
[/#if]
#endif

void msd_usbfs_device_init(void);

#endif /* __FS_USBD_CONF_H */
