[#ftl]
/*!
    \file    usbd_desc.c
    \brief   the descriptor file of USB device

    \version 2023-08-01, V1.0.0, HAL firmware for GD32F3x0
*/

/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc. 

    Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/

#ifndef __USBD_CONF_H
#define __USBD_CONF_H
#include "usbd_enum.h"

char* VID_STR = "${USBFS_DEVICE_StringConfiguration_VendorID}";
char* PID_STR = "${USBFS_DEVICE_StringConfiguration_ProductID}";
char* LANG_ID_STR = "${USBFS_DEVICE_StringConfiguration_LanguageID}";
char* MANUFACTURER_STR = "${USBFS_DEVICE_StringConfiguration_Manufacturerstring}";
char* PRODUCT_STR = "${USBFS_DEVICE_StringConfiguration_Productstring}";
char* CONFIGURATION_STR = "${USBFS_DEVICE_StringConfiguration_Configurationstring}";
char* INTERFACE_STR = "${USBFS_DEVICE_StringConfiguration_Interfacestring}";
char* SERIAL_STR = "MCU F350";

extern usb_desc_dev ${middleType}_dev_desc;

#define STRING_LENGTH(len) 2*len+2 

/* USB language ID Descriptor */
usb_desc_LANGID usbd_language_id_desc = 
{
    .header = 
     {
         .bLength         = sizeof(usb_desc_LANGID), 
         .bDescriptorType = USB_DESCTYPE_STR
     }
};

/* USB manufacture string */
usb_desc_str manufacturer_string = 
{
    .header = 
     {
         .bLength         = USB_STRING_LEN(10U), 
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USB product string */
usb_desc_str product_string = 
{
    .header = 
     {
         .bLength         = USB_STRING_LEN(17U), 
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USBD serial string */
 usb_desc_str serial_string = 
{
    .header = 
     {
         .bLength         = USB_STRING_LEN(12U), 
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USB configure string */
 usb_desc_str configure_string = 
{
    .header = 
     {
         .bLength         = USB_STRING_LEN(12U), 
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USB interface string */
 usb_desc_str interface_string = 
{
    .header = 
     {
         .bLength         = USB_STRING_LEN(12U), 
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USB string descriptor */
void *${middleType}_strings_desc[] = 
{
    [STR_IDX_LANGID]  = (uint8_t *)&usbd_language_id_desc,
    [STR_IDX_MFC]     = (uint8_t *)&manufacturer_string,
    [STR_IDX_PRODUCT] = (uint8_t *)&product_string,
    [STR_IDX_SERIAL]  = (uint8_t *)&serial_string,
    [STR_IDX_ITF]     = (uint8_t *)&interface_string,
    [STR_IDX_CONFIG]  = (uint8_t *)&configure_string
};

/*!
    \brief      initialize device descirptor and serial string descriptor
    \param[in]  none
    \param[out] none
    \retval     none
*/
void string_get(void)
{
    /* initialize device descirptor and language id serial string descriptor */
    ${middleType}_dev_desc.idVendor  = string_to_id(VID_STR);
    ${middleType}_dev_desc.idProduct = string_to_id(PID_STR);
    usbd_language_id_desc.wLANGID = string_to_id(LANG_ID_STR);
    /* initialize manufacturer?product and serial string descriptor */
    manufacturer_string.header.bLength = STRING_LENGTH(string_to_unicode(MANUFACTURER_STR,(uint8_t*)&(manufacturer_string.unicode_string[0])));
    product_string.header.bLength      = STRING_LENGTH(string_to_unicode(PRODUCT_STR,(uint8_t*)&(product_string.unicode_string[0])));
    serial_string.header.bLength       = STRING_LENGTH(string_to_unicode(SERIAL_STR,(uint8_t*)&(serial_string.unicode_string[0])));
    /* initialize interface and configuration string descriptor */
    configure_string.header.bLength    = STRING_LENGTH(string_to_unicode(CONFIGURATION_STR,(uint8_t*)&(configure_string.unicode_string[0])));
    interface_string.header.bLength    = STRING_LENGTH(string_to_unicode(INTERFACE_STR,(uint8_t*)&(interface_string.unicode_string[0])));
}

#endif /* __USBD_CONF_H */
