/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
#include "gd32f3x0r_hal_eval.h"

hal_rtc_irq_struct  rtc_irq;
void rtc_show_time(void);
void func_b(void *ptr);
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */

    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */

    /* user code [local 1] end */
    msd_gpio_init();
    msd_rtc_init();

    /* user code [local 2] begin */
    gd_eval_com_init(EVAL_COM);
    gd_eval_led_off(LED1);
    gd_eval_led_off(LED2);
    hal_rtc_struct_init(HAL_RTC_IRQ_STRUCT, &rtc_irq);
    rtc_irq.rtc_timestamp_handle = func_b;
    hal_rtc_irq_handle_set(&rtc_info, &rtc_irq);

    /* user code [local 2] end */

    while(1) {
        /* user code [local 3] begin */
        rtc_show_time();
        hal_sys_basetick_delay_ms(1000);
        /* user code [local 3] end */
    }
}
/* user code [global 1] begin */

/*!
\brief      display the current time
\param[in]  none
\param[out] none
\retval     none
*/
void rtc_show_time(void)
{
    hal_rtc_init_struct rtc_init;
    uint32_t time_subsecond = 0;
    uint8_t subsecond_ss = 0, subsecond_ts = 0, subsecond_hs = 0;

    hal_rtc_current_time_get(&rtc_init);

    /* convert the subsecond value into fractional format */
    time_subsecond = rtc_init.rtc_subsecond;
    subsecond_ss = (1000 - (time_subsecond * 1000 + 1000) / 400) / 100;
    subsecond_ts = (1000 - (time_subsecond * 1000 + 1000) / 400) % 100 / 10;
    subsecond_hs = (1000 - (time_subsecond * 1000 + 1000) / 400) % 10;

    printf("Current time: %0.2d:%0.2d:%0.2d.%d%d%d \n\r", \
           rtc_init.rtc_hour, rtc_init.rtc_minute, rtc_init.rtc_second, \
           subsecond_ss, subsecond_ts, subsecond_hs);
}

/*!
    \brief      timestamp interrupt callback
    \param[in]  none
    \param[out] none
    \retval     none
*/
void func_b(void *ptr)
{
    hal_rtc_timestamp_struct rtc_timestamp;
    uint32_t ts_subsecond = 0;
    uint8_t ts_subsecond_ss, ts_subsecond_ts, ts_subsecond_hs ;

    gd_eval_led_toggle(LED1);

    hal_rtc_struct_init(HAL_RTC_TIMESTAMP_STRUCT, &rtc_timestamp);
    hal_rtc_timestamp_get(&rtc_timestamp);

    /* get the subsecond value of timestamp time, and convert it into fractional format */
    ts_subsecond = rtc_timestamp.rtc_timestamp_subsecond;
    ts_subsecond_ss = (1000 - (ts_subsecond * 1000 + 1000) / 400) / 100;
    ts_subsecond_ts = (1000 - (ts_subsecond * 1000 + 1000) / 400) % 100 / 10;
    ts_subsecond_hs = (1000 - (ts_subsecond * 1000 + 1000) / 400) % 10;

    printf("Get the time-stamp time: %0.2d:%0.2d:%0.2d.%d%d%d \n\r", \
           rtc_timestamp.rtc_timestamp_hour, rtc_timestamp.rtc_timestamp_minute, rtc_timestamp.rtc_timestamp_second, \
           ts_subsecond_ss, ts_subsecond_ts, ts_subsecond_hs);
}
/* user code [global 1] end */
