/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
#include "gd32f3x0r_hal_eval.h"
#define DATASIZE 256

uint16_t Rbuff[DATASIZE]={0};
uint16_t Tbuff[DATASIZE] = {
    0x0300, 0x0300, 0x0600, 0x0600, 0x0800, 0x0800, 0x0400, 0x0400,
    0x0600, 0x0600, 0x0C00, 0x0C00, 0x0500, 0x0500, 0x0300, 0x0300,
    0x0700, 0x0700, 0x0B00, 0x0B00, 0x0F00, 0x0F00, 0xFEFF, 0xFEFF,
    0xF0FF, 0xF0FF, 0xFFF7, 0xFFF7, 0xFFF9, 0xFFF9, 0xFFF8, 0xFFF8,
    0xF3FF, 0xF3FF, 0xE5FF, 0xE5FF, 0xE4FF, 0xE4FF, 0xE3FF, 0xE3FF,
    0xFFE5, 0xFFE5, 0xFFE5, 0xFFE5, 0xFFE7, 0xFFE7, 0xFFE5, 0xFFE5,
    0xE3FF, 0xE3FF, 0xE7FF, 0xE7FF, 0xF0FF, 0xF0FF, 0xF4FF, 0xF4FF,
    0xF800, 0xF800, 0xFFF3, 0xFFF3, 0xFFF2, 0xFFF2, 0xFF26, 0xFF26,
    0x1C00, 0x1C00, 0x2100, 0x2100, 0x5600, 0x5600, 0x4D00, 0x4D00,
    0x5800, 0x5800, 0x005B, 0x005B, 0x0045, 0x0045, 0x0053, 0x0053,
    0x2300, 0x2300, 0xFBFF, 0xFBFF, 0x0E00, 0x0E00, 0xFAFF, 0xFAFF,
    0xF8FF, 0xF8FF, 0xEFFF, 0xEFFF, 0xE3FF, 0xE3FF, 0x1800, 0x1800,
    0x1500, 0x1500, 0x1300, 0x1300, 0x5400, 0x5400, 0x7C00, 0x7C00,
    0x8200, 0x8200, 0x0088, 0x0088, 0x007A, 0x007A, 0x0087, 0x0087,
    0x7B00, 0x7B00, 0x5A00, 0x5A00, 0x4400, 0x4400, 0x3800, 0x3800,
    0x21FF, 0x21FF, 0x001B, 0x001B, 0x00C8, 0x00C8, 0xFF3C, 0xFF3C,
    0xFEFE, 0xFEFE, 0xFEEB, 0xFEEB, 0xFEAD, 0xFEAD, 0xFE3E, 0xFE3E,
    0x15FE, 0x15FE, 0xDCFD, 0xDCFD, 0xAEFD, 0xAEFD, 0x73FD, 0x73FD,
    0x93FD, 0x93FD, 0xAEFD, 0xAEFD, 0xEBFD, 0xEBFD, 0x01FE, 0x01FE,
    0xF800, 0xF800, 0xFFF3, 0xFFF3, 0xFFF2, 0xFFF2, 0xFF26, 0xFF26,
    0x1C00, 0x1C00, 0x2100, 0x2100, 0x5600, 0x5600, 0x4D00, 0x4D00,
    0x5800, 0x5800, 0x005B, 0x005B, 0x0045, 0x0045, 0x0053, 0x0053,
    0x2300, 0x2300, 0xFBFF, 0xFBFF, 0x0E00, 0x0E00, 0xFAFF, 0xFAFF,
    0xF8FF, 0xF8FF, 0xEFFF, 0xEFFF, 0xE3FF, 0xE3FF, 0x1800, 0x1800,
    0x1500, 0x1500, 0x1300, 0x1300, 0x5400, 0x5400, 0x7C00, 0x7C00,
    0x8200, 0x8200, 0x0088, 0x0088, 0x007A, 0x007A, 0x0087, 0x0087,
    0x7B00, 0x7B00, 0x5A00, 0x5A00, 0x4400, 0x4400, 0x3800, 0x3800,
    0x21FF, 0x21FF, 0x001B, 0x001B, 0x00C8, 0x00C8, 0xFF3C, 0xFF3C,
    0xFEFE, 0xFEFE, 0xFEEB, 0xFEEB, 0xFEAD, 0xFEAD, 0xFE3E, 0xFE3E,
    0x15FE, 0x15FE, 0xDCFD, 0xDCFD, 0xAEFD, 0xAEFD, 0x73FD, 0x73FD,
    0x93FD, 0x93FD, 0xAEFD, 0xAEFD, 0xEBFD, 0xEBFD, 0x01FE, 0x01FE,
    0x5800, 0x5800, 0x005B, 0x005B, 0x0045, 0x0045, 0x0053, 0x0053
};

extern hal_i2s_dev_struct i2s0_info;

hal_i2s_user_callback_struct user_call;

#if defined I2S_MASTER_USED
    extern hal_dma_dev_struct dma_i2s0_tx_info;
#endif

#if defined I2S_SLAVE_USED
    extern hal_dma_dev_struct dma_i2s0_rx_info;
#endif

ErrStatus memory_compare(uint16_t *src, uint16_t *dst, uint16_t length);

void i2s_callback(hal_i2s_dev_struct *i2s)
{
#if defined I2S_SLAVE_USED
#if defined I2S_INTERRUPT_USED

    if(ERROR != memory_compare(Rbuff, Tbuff, DATASIZE)) {
        printf("\n\r  I2S slave interrupt receive success ");
    } else {
        printf("\n\r  I2S slave interrupt receive error ");
    }
#endif

#if defined I2S_DMA_USED

    if(ERROR != memory_compare(Rbuff, Tbuff, DATASIZE)) {
        printf("\n\r  I2S slave DMA receive success ");
    } else {
        printf("\n\r  I2S slave DMA receive error ");
    }
#endif
#endif

}

void i2s_error_callback(hal_i2s_dev_struct *i2s)
{
#if defined I2S_SLAVE_USED
#if defined I2S_INTERRUPT_USED
    printf("\n\r  I2S slave interrupt receive error ");
#endif

#if defined I2S_DMA_USED
    printf("\n\r  I2S slave DMA receive error ");
#endif
#endif

}
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */
    user_call.complete_func = i2s_callback;
    user_call.error_func = i2s_error_callback;
    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */

    /* user code [local 1] end */
    msd_gpio_init();
    msd_dma_init();
    msd_i2s0_init();

    /* user code [local 2] begin */
    gd_eval_com_init(EVAL_COM);
    /* user code [local 2] end */


#if defined I2S_SLAVE_USED
    while(1) {
#if defined I2S_POLLING_USED
        hal_i2s_receive_poll(&i2s0_info, Rbuff, DATASIZE, 60000);
        if(ERROR != memory_compare(Rbuff, Tbuff, DATASIZE)) {
            printf("\n\r  I2S slave polling receive success ");
        } else {
            printf("\n\r  I2S slave polling receive error ");
        }
#endif

#if defined I2S_INTERRUPT_USED
        hal_i2s_receive_interrupt(&i2s0_info, Rbuff, DATASIZE, &user_call);
#endif
#if defined I2S_DMA_USED
        hal_i2s_receive_dma(&i2s0_info, Rbuff, DATASIZE, &user_call);
#endif
    }
#endif

#if defined I2S_MASTER_USED
    while(1) {
        /* user code [local 3] begin */
        while(hals_gpio_input_bit_get(GPIOA, GPIO_PIN_0)== 0);

        hal_sys_basetick_delay_ms(500);

#if defined I2S_POLLING_USED
        hal_i2s_transmit_poll(&i2s0_info, Tbuff, DATASIZE, 6000);
        __HAL_I2S_DISABLE(&i2s0_info);
#endif

#if defined I2S_INTERRUPT_USED
        hal_i2s_transmit_interrupt(&i2s0_info, Tbuff, DATASIZE, &user_call);
#endif

#if defined I2S_DMA_USED
        hal_i2s_transmit_dma(&i2s0_info, Tbuff, DATASIZE, &user_call);
#endif
        /* user code [local 3] end */

    }
#endif
}
/* user code [global 1] begin */
ErrStatus memory_compare(uint16_t *src, uint16_t *dst, uint16_t length)
{
    while(length--) {
        if(*src++ != *dst++) {
            return ERROR;
        }
    }
    return SUCCESS;
}
/* user code [global 1] end */
