/*
    \file  gd32f3x0_hal_init.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
hal_i2s_dev_struct i2s0_info;
hal_dma_dev_struct dma_i2s0_tx_info;
hal_dma_dev_struct dma_i2s0_rx_info;

/* user code [global 0] end */
hal_i2s_dev_struct i2s0_info;
hal_dma_dev_struct dma_i2s0_rx_info;

void msd_system_init(void)
{
    /* user code [system_init local 0] begin */
    /* user code [system_init local 0] end */
    hal_rcu_periph_clk_enable(RCU_CFGCMP);
    hal_nvic_irq_priority_group_set(NVIC_PRIGROUP_PRE3_SUB1);
    hal_sys_timesource_init(SYS_TIMEBASE_SOURCE_SYSTICK);

    hal_nvic_set_priority(NonMaskableInt_IRQn, 0, 0);
    hal_nvic_set_priority(SVCall_IRQn, 0, 0);
    hal_nvic_set_priority(PendSV_IRQn, 0, 0);
    hal_nvic_set_priority(SysTick_IRQn, 0, 0);
    /* user code [system_init local 1] begin */
    /* user code [system_init local 1] end */
}

void msd_clock_init(void)
{
    /* user code [clock_init local 0] begin */
    /* user code [clock_init local 0] end */
    hal_rcu_clk_struct rcu_clk_parameter;
    hal_rcu_osci_struct rcu_osci_parameter;

    hal_rcu_struct_init(HAL_RCU_CLK_STRUCT, &rcu_clk_parameter);
    hal_rcu_struct_init(HAL_RCU_OSCI_STRUCT, &rcu_osci_parameter);

    rcu_osci_parameter.hxtal.need_configure = ENABLE;
    rcu_osci_parameter.hxtal.state = RCU_OSC_ON;
    rcu_osci_parameter.irc8m.need_configure = ENABLE;
    rcu_osci_parameter.irc8m.state = RCU_OSC_ON;
    rcu_osci_parameter.irc8m.adjust_value = 0;
    rcu_osci_parameter.pll.need_configure = ENABLE;
    rcu_osci_parameter.pll.state = RCU_OSC_ON;
    rcu_osci_parameter.pll.pll_source = RCU_PLL_SRC_HXTAL_IRC48M;
    rcu_osci_parameter.pll.pll_mul = RCU_PLL_MULT27;
    rcu_osci_parameter.pll.pll_presel = RCU_PLL_PRESEL_HXTAL;
    rcu_osci_parameter.pll.pre_div = RCU_PLL_PREDIV2;
    if(HAL_ERR_NONE != hal_rcu_osci_config(&rcu_osci_parameter)){
        while(1);
    }

    rcu_clk_parameter.clock_type = RCU_CLKTYPE_SYSCLK | RCU_CLKTYPE_AHBCLK | RCU_CLKTYPE_APB1CLK | RCU_CLKTYPE_APB2CLK | RCU_CLKTYPE_CK48MCLK;
    rcu_clk_parameter.sysclk_source = RCU_SYSCLK_SRC_PLL;
    rcu_clk_parameter.ahbclk_divider = RCU_SYSCLK_AHBDIV1;
    rcu_clk_parameter.apb1clk_divider = RCU_AHBCLK_APB1DIV2;
    rcu_clk_parameter.apb2clk_divider = RCU_AHBCLK_APB2DIV2;
    rcu_clk_parameter.ck48mclk_source = RCU_USB_CK48MSRC_IRC48M;
    if(HAL_ERR_NONE != hal_rcu_clock_config(&rcu_clk_parameter)){
        while(1);
    }

    /* user code [clock_init local 1] begin */
    /* user code [clock_init local 1] end */
}

void msd_dma_init(void)
{
    /* user code [dma_init local 0] begin */
    /* user code [dma_init local 0] end */
    hal_rcu_periph_clk_enable(RCU_DMA);
    hal_nvic_irq_enable(DMA_Channel1_2_IRQn, 0, 0);
    /* user code [dma_init local 1] begin */
    /* user code [dma_init local 1] end */
}

void msd_dma_deinit(void)
{
    /* user code [dma_deinit local 0] begin */
    /* user code [dma_deinit local 0] end */
    hal_rcu_periph_clk_disable(RCU_DMA);
    /* user code [dma_deinit local 1] begin */
    /* user code [dma_deinit local 1] end */
}

void msd_gpio_init(void)
{
    /* user code [gpio_init local 0] begin */
    /* user code [gpio_init local 0] end */
    hal_rcu_periph_clk_enable(RCU_GPIOF);
    hal_rcu_periph_clk_enable(RCU_GPIOA);
    /* user code [gpio_init local 1] begin */
    /* user code [gpio_init local 1] end */
}

void msd_gpio_deinit(void)
{
    /* user code [gpio_deinit local 0] begin */
    /* user code [gpio_deinit local 0] end */
    hal_rcu_periph_clk_disable(RCU_GPIOF);
    hal_rcu_periph_clk_disable(RCU_GPIOA);
    /* user code [gpio_deinit local 1] begin */
    /* user code [gpio_deinit local 1] end */
}

void msd_i2s0_init(void)
{
    hal_gpio_init_struct gpio_init_parameter;
    hal_i2s_init_struct i2s0_init_parameter;
    hal_dma_init_struct dma_i2s0_rx_init_parameter;
    hal_dma_init_struct dma_i2s0_tx_init_parameter;

    hal_gpio_struct_init(&gpio_init_parameter);

    /* user code [i2s0_init local 0] begin */
    hal_rcu_periph_clk_enable(RCU_SPI0);
    /* user code [i2s0_init local 0] end */

    gpio_init_parameter.mode = GPIO_MODE_AF_PP;
    gpio_init_parameter.pull = GPIO_PULL_NONE;
    gpio_init_parameter.ospeed = GPIO_OSPEED_50MHZ;
    gpio_init_parameter.af = GPIO_AF_0;
    hal_gpio_init(GPIOA, GPIO_PIN_4, &gpio_init_parameter);

    gpio_init_parameter.mode = GPIO_MODE_AF_PP;
    gpio_init_parameter.pull = GPIO_PULL_NONE;
    gpio_init_parameter.ospeed = GPIO_OSPEED_50MHZ;
    gpio_init_parameter.af = GPIO_AF_0;
    hal_gpio_init(GPIOA, GPIO_PIN_5, &gpio_init_parameter);

    gpio_init_parameter.mode = GPIO_MODE_AF_PP;
    gpio_init_parameter.pull = GPIO_PULL_NONE;
    gpio_init_parameter.ospeed = GPIO_OSPEED_50MHZ;
    gpio_init_parameter.af = GPIO_AF_0;
    hal_gpio_init(GPIOA, GPIO_PIN_7, &gpio_init_parameter);

    hal_i2s_struct_init(HAL_I2S_INIT_STRUCT, &i2s0_init_parameter);
    hal_i2s_struct_init(HAL_I2S_DEV_STRUCT, &i2s0_info);

    i2s0_init_parameter.standard = I2S_STD_PHILLIPS;
    i2s0_init_parameter.frameformat = I2S_FRAMEFORMAT_DT16B_CH16B;
    i2s0_init_parameter.audiosample = I2S_AUDIOSAMPLE_8K;
    i2s0_init_parameter.ckpl = I2S_CKPL_LOW;
    i2s0_init_parameter.mckout = I2S_MCKOUT_DISABLE;
#if defined I2S_MASTER_USED
    i2s0_init_parameter.mode = I2S_MODE_MASTERTX;
#endif

#if defined I2S_SLAVE_USED
    i2s0_init_parameter.mode = I2S_MODE_SLAVERX;
#endif

    hal_i2s_init(&i2s0_info, SPI0, &i2s0_init_parameter);

    hal_dma_struct_init(HAL_DMA_INIT_STRUCT, &dma_i2s0_rx_init_parameter);
    hal_dma_struct_init(HAL_DMA_DEV_STRUCT, &dma_i2s0_rx_info);

    dma_i2s0_rx_init_parameter.direction = DMA_DIR_PERIPH_TO_MEMORY;
    dma_i2s0_rx_init_parameter.periph_inc = DISABLE;
    dma_i2s0_rx_init_parameter.memory_inc = ENABLE;
    dma_i2s0_rx_init_parameter.periph_width = DMA_PERIPH_SIZE_16BITS;
    dma_i2s0_rx_init_parameter.memory_width = DMA_MEMORY_SIZE_16BITS;
    dma_i2s0_rx_init_parameter.mode = DMA_NORMAL_MODE;
    dma_i2s0_rx_init_parameter.priority = DMA_PRIORITY_LEVEL_HIGH;
    hal_dma_init(&dma_i2s0_rx_info, DMA_CH1, &dma_i2s0_rx_init_parameter);

    hal_periph_dma_info_bind(i2s0_info, p_dma_rx, dma_i2s0_rx_info);

    hal_dma_struct_init(HAL_DMA_INIT_STRUCT, &dma_i2s0_tx_init_parameter);
    hal_dma_struct_init(HAL_DMA_DEV_STRUCT, &dma_i2s0_tx_info);

    dma_i2s0_tx_init_parameter.direction = DMA_DIR_MEMORY_TO_PERIPH;
    dma_i2s0_tx_init_parameter.periph_inc = DISABLE;
    dma_i2s0_tx_init_parameter.memory_inc = ENABLE;
    dma_i2s0_tx_init_parameter.periph_width = DMA_PERIPH_SIZE_16BITS;
    dma_i2s0_tx_init_parameter.memory_width = DMA_MEMORY_SIZE_16BITS;
    dma_i2s0_tx_init_parameter.mode = DMA_NORMAL_MODE;
    dma_i2s0_tx_init_parameter.priority = DMA_PRIORITY_LEVEL_ULTRA_HIGH;
    hal_dma_init(&dma_i2s0_tx_info, DMA_CH2, &dma_i2s0_tx_init_parameter);

    hal_periph_dma_info_bind(i2s0_info, p_dma_tx, dma_i2s0_tx_info);

    hal_nvic_irq_enable(SPI0_IRQn, 0, 0);
    /* user code [i2s0_init local 1] begin */
    /* user code [i2s0_init local 1] end */
}

void msd_i2s0_deinit(void)
{
    /* user code [i2s0_deinit local 0] begin */
    /* user code [i2s0_deinit local 0] end */
    hal_rcu_periph_clk_disable(RCU_SPI0);
    hal_gpio_deinit(GPIOA, GPIO_PIN_4);
    hal_gpio_deinit(GPIOA, GPIO_PIN_5);
    hal_gpio_deinit(GPIOA, GPIO_PIN_7);
    hal_i2s_deinit(&i2s0_info);
    hal_dma_deinit(&dma_i2s0_rx_info);
    /* user code [i2s0_deinit local 1] begin */
    /* user code [i2s0_deinit local 1] end */
}

/* user code [global 1] begin */

/* user code [global 1] end */
