/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
#define DATA32(addr)                  (*(uint32_t *)(uint32_t)(addr))
#define DATA8(addr)                   (*(uint8_t *)(uint32_t)(addr))
uint8_t src_data[0x80] ={
    0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
    0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
    0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
    0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
    0x60,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f
};
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */
    uint8_t counter = 0U;
    uint8_t data[0x88U];
    uint32_t start_addr = 0U;
    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */

    /* user code [local 1] end */
    msd_gpio_init();
    msd_usart0_init();

    /* user code [local 2] begin */
    /* enable or disable write protection with address range */
    hal_fmc_unlock();
    printf("###### Program word/halfword and erase page ######\r\n");
    hal_fmc_page_erase(0x8008000);
    hal_fmc_word_program(0x8008000,0x01234567);
    hal_fmc_halfword_program(0x8008004,0xaaaa);
    printf("after program, address 0x8008000 - 0x8008008 value is %x%x\r\n", \
            DATA32(0x8008000),DATA32(0x8008004));
    hal_fmc_page_erase(0x8008000);
    printf("after erase, address 0x8008000 - 0x8008008 value is %x%x\r\n",\
            DATA32(0x8008000),DATA32(0x8008004));
    
    printf("###### read region , program region and erase region ######\r\n");
    hal_fmc_word_program(0x8008000,0xABCDDCBA);
    hal_fmc_region_write(0x8008008, src_data, 0x80);  
    start_addr = 0x8008000U;
    printf("###### reserve original data and program region ######\r\n");
    for (counter = 0U; counter < 0x11U; counter++){
        printf("%x %x %x %x %x %x %x %x \r\n", DATA8(start_addr + 8*counter),\
                DATA8(start_addr + 8*counter + 1U),DATA8(start_addr + 8*counter + 2U),\
                DATA8(start_addr + 8*counter + 3U),DATA8(start_addr + 8*counter + 4U), \
                DATA8(start_addr + 8*counter + 5U),DATA8(start_addr + 8*counter + 6U), \
                DATA8(start_addr + 8*counter + 7U));
    }
    hal_fmc_region_read(0x8008000, data, 0x88);
    hal_fmc_region_write(0x8008100, data, 0x88); 
    start_addr = 0x8008100U;
    printf("###### program data array which is obtained by previous reading ###### \r\n");
     for (counter = 0U; counter < 0x11U; counter++){
        printf("%x %x %x %x %x %x %x %x \r\n", DATA8(start_addr + 8*counter), \
                DATA8(start_addr + 8*counter + 1U),DATA8(start_addr + 8*counter + 2U), \
                DATA8(start_addr + 8*counter + 3U),DATA8(start_addr + 8*counter + 4U), \
                DATA8(start_addr + 8*counter + 5U),DATA8(start_addr + 8*counter + 6U), \
                DATA8(start_addr + 8*counter + 7U));
    }
    hal_fmc_region_erase(0x8008010, 0x100);
    start_addr = 0x8008000U;
    printf("###### reserve original data and erase region ######\r\n");
    for (counter = 0U; counter < 0x40U; counter++){
        printf("%x %x %x %x %x %x %x %x \r\n", DATA8(start_addr + 8*counter), \
                DATA8(start_addr + 8*counter + 1U),DATA8(start_addr + 8*counter + 2U), \
                DATA8(start_addr + 8*counter + 3U),DATA8(start_addr + 8*counter + 4U), \
                DATA8(start_addr + 8*counter + 5U),DATA8(start_addr + 8*counter + 6U), \
                DATA8(start_addr + 8*counter + 7U));
    }
    /* user code [local 2] end */

    while(1){
    /* user code [local 3] begin */

    /* user code [local 3] end */
    }
}
/* user code [global 1] begin */
/*!
    \brief      retarget the C library printf function to the USART
    \param[in]  none
    \param[out] none
    \retval     none
*/
#ifdef __GNUC__
/* With GCC, small printf (option LD Linker->Libraries->Small printf
   set to 'Yes') calls __io_putchar() */
#define PUTCHAR_PROTOTYPE int __io_putchar(int ch)
    int __io_putchar(int ch)
    {
        hal_uart_transmit_poll(&uart0_info, (uint8_t*)&ch, 1, 0x1FFFFF);
        return ch;
    }
#else
#define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
    int fputc(int ch, FILE *f)
    {
        hal_uart_transmit_poll(&uart0_info, (uint8_t*)&ch, 1, 0x1FFFFF);
        return ch;
    }
#endif /* __GNUC__ */
/* user code [global 1] end */
