/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
__IO uint8_t rxstatus = 0U;
__IO uint8_t txstatus = 0U;

uint8_t StartTx       = 0x0;

uint32_t Tx_Size      = 0x0;
uint8_t Rx_Burrer[CEC_MAX_BUFFER_LEN] = {0};
uint8_t Tx_Burrer[CEC_MAX_BUFFER_LEN];

void HAL_CEC_TxCpltCallback(hal_cec_dev_struct *cec_dev)
{
    /* End of transmission */
    txstatus =1;
}

void HAL_CEC_RxCpltCallback(hal_cec_dev_struct *cec_dev)
{
    rxstatus = 1;
}

void HAL_CEC_ErrCallback(hal_cec_dev_struct *cec_dev)
{
    rxstatus = 2;
}
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */
    hal_gpio_init_struct GPIO;

    cec_info.err_callback = HAL_CEC_ErrCallback;
    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */
    hal_rcu_periph_clk_enable(RCU_GPIOA);

    GPIO.af = GPIO_AF_0;
    GPIO.mode = GPIO_MODE_INPUT;
    GPIO.ospeed = GPIO_OSPEED_50MHZ;
    GPIO.pull = GPIO_PULL_NONE;
    hal_gpio_init(GPIOA,GPIO_PIN_0,&GPIO);

    GPIO.af = GPIO_AF_0;
    GPIO.mode = GPIO_MODE_OUTPUT_PP;
    GPIO.ospeed = GPIO_OSPEED_50MHZ;
    GPIO.pull = GPIO_PULL_NONE;
    hal_gpio_init(GPIOA,GPIO_PIN_1|GPIO_PIN_2,&GPIO);
    
    hal_rcu_periph_clk_enable(RCU_GPIOC);

    GPIO.af = GPIO_AF_0;
    GPIO.mode = GPIO_MODE_OUTPUT_PP;
    GPIO.ospeed = GPIO_OSPEED_50MHZ;
    GPIO.pull = GPIO_PULL_NONE;
    hal_gpio_init(GPIOC,GPIO_PIN_10|GPIO_PIN_11,&GPIO);
    /* user code [local 1] end */
    msd_gpio_init();
    msd_cec_init();

    /* user code [local 2] begin */
    hal_cec_receive_interrupt(&cec_info, Rx_Burrer, HAL_CEC_RxCpltCallback);

    hal_cec_start(&cec_info);
    /* user code [local 2] end */

    while(1){
    /* user code [local 3] begin */
      /* test whether the Wakeup key is pressed */
      if(1 == hals_gpio_input_bit_get(GPIOA,GPIO_PIN_0)){
          StartTx = 1;

          Tx_Burrer[0] = 0xa5;
          Tx_Burrer[1] = 0x5a;
          Tx_Size    = 0x02;
          /* waiting for the Tamper key up */
          while(1 == hals_gpio_input_bit_get(GPIOA,GPIO_PIN_0));
      }

      while((StartTx == 1)&&(rxstatus == 0U))
      {
          hal_cec_transmit_interrupt(&cec_info, Tx_Size, Tx_Burrer, 1, 2, HAL_CEC_TxCpltCallback);

          while(txstatus == 0U);
          StartTx  = 0;
          txstatus = 0;
      }

      if(rxstatus == 1U) {
          if((Rx_Burrer[1] == 0xA5U) && (Rx_Burrer[2] == 0x5AU)) {
              hals_gpio_bit_toggle(GPIOA,GPIO_PIN_1);
              hals_gpio_bit_toggle(GPIOC,GPIO_PIN_10);
          }
          if((Rx_Burrer[1] == 0x5AU) && (Rx_Burrer[2] == 0xA5U)) {
              hals_gpio_bit_toggle(GPIOA,GPIO_PIN_1);
              hals_gpio_bit_toggle(GPIOC,GPIO_PIN_10);
          }
          rxstatus = 0U;
      }
      else if (rxstatus == 2U)    /* a reception error occured */
      {
          hals_gpio_bit_toggle(GPIOA,GPIO_PIN_2);
          hals_gpio_bit_toggle(GPIOC,GPIO_PIN_11);
          rxstatus = 0U;
      }
    /* user code [local 3] end */
    }
}
/* user code [global 1] begin */

/* user code [global 1] end */
