/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
#include "gd32f3x0r_hal_eval.h"
uint16_t adc_value;
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */

    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */

    /* user code [local 1] end */
    msd_gpio_init();
    msd_adc_init();
    msd_timer2_init();

    /* user code [local 2] begin */
    gd_eval_com_init(EVAL_COM);
    /* output message through EVAL_COM */
    printf("\r\n ADC inserted channel trigger with TIMER2 CH3 demo! \r\n");
    /* start TIMER pwm mode */
    hal_timer_output_compare_start(&timer2_info, TIMER_CH_3);
    /* enable ADC and start the conversion of inserted group */
    hal_adc_inserted_start(&adc_info);
    /* user code [local 2] end */

    while(1){
        /* user code [local 3] begin */
        /* basetick delay for 1500ms */
        hal_sys_basetick_delay_ms(1500);

        /* get inserted sequence conversion result */
        adc_value = hal_adc_inserted_value_get(&adc_info, ADC_INSERTED_SEQUENCE_0);
        /* print ADC inserted channel conversion value through EVAL_COM */
        printf("\r\n ADC inserted channel value is: 0x%x\r\n", adc_value);
        /* user code [local 3] end */
    }
}
/* user code [global 1] begin */

/* user code [global 1] end */	
