/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
#include "gd32f3x0r_hal_eval.h"
hal_adc_irq_struct adc_irq_parameter;
float temperature;
float vref_value;
extern hal_adc_dev_struct adc_info;

void adc_irq_config(void);
void adc_irq_inserted_sequence(void *ptr);
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */

    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */

    /* user code [local 1] end */
    msd_gpio_init();
    msd_adc_init();

    /* user code [local 2] begin */
    adc_irq_config();

    gd_eval_com_init(EVAL_COM);
    /* user code [local 2] end */

    while(1){
    /* user code [local 3] begin */
    /* basetick delay for 1500ms */
    hal_sys_basetick_delay_ms(1500);

    /* start ADC EOIC interrupt */
    hal_adc_inserted_start_interrupt(&adc_info, &adc_irq_parameter);
    /* user code [local 3] end */
    }
}
/* user code [global 1] begin */

/*!
\brief      configuration adc interrupt
\param[in]  none
\param[out] none
\retval     none
*/
void adc_irq_config(void)
{
    hal_adc_struct_init(HAL_ADC_IRQ_STRUCT, &adc_irq_parameter);

    adc_irq_parameter.adc_eoic_handle = adc_irq_inserted_sequence;
}

/*!
\brief      adc watchdog interrupt
\param[in]  ptr
\param[out] none
\retval     none
*/
void adc_irq_inserted_sequence(void *ptr)
{
    /* value convert */
    temperature = (1.43f - ADC_IDATA0 * 3.3f/4096) * 1000 / 4.3f + 25;
    vref_value = (ADC_IDATA1 * 3.3f / 4096);

    /* value print */
    printf(" \r\n ==================================\r\n");
    printf(" the current Temperature value is %2.0f degrees Celsius,\r\n", temperature);
    printf(" the current Reference voltage value VREFINT is %5.3fV. \r\n", vref_value);
}
/* user code [global 1] end */	
