[#ftl]
[#--V1.0.1 --]
/*
    \file  main.c
*/
/*
    Copyright (c) ${CurrentData}, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "${MCUPart}.h"
#include "${MCUPart}_init.h"

/* External Includes*/
[#if Peripherals?contains("#USBHS0#") == true || Peripherals?contains("#USBHS1#") == true]
[#if Peripherals?contains("#USB0_HOST#") == true || Peripherals?contains("#USB1_HOST#") == true]
#include "usbh_core.h"
[/#if]
[/#if]
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */

/* user code [Private Variables] end */

/* Private Function Declaration */
[#if Peripherals?contains("#FREERTOS#") == true]
static void default_task(void *pvParameters);
[/#if]
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */

    /* user code [local 0] end */

    msd_system_init();
[#if Peripherals?contains("PMU") == true]
    msd_pmu_init();
[/#if]
    msd_clock_init();

    /* user code [local 1] begin */

    /* user code [local 1] end */

[#if PosMain_GPIO != ""]
${PosMain_GPIO}
[/#if]
[#if PosMain_DMA != ""]
${PosMain_DMA}
[/#if]
[#if PosMain_MDMA != ""]
${PosMain_MDMA}
[/#if]
[#if Peripherals?contains("#ADC0#") == true]
    msd_adc0_init();
[/#if]
[#if Peripherals?contains("#ADC1#") == true]
    msd_adc1_init();
[/#if]
[#if Peripherals?contains("#ADC2#") == true]
    msd_adc2_init();
[/#if]
[#if Peripherals?contains("#CAN0#") == true]
    msd_can0_init();
[/#if]
[#if Peripherals?contains("#CAN1#") == true]
    msd_can1_init();
[/#if]
[#if Peripherals?contains("#CAN2#") == true]
    msd_can2_init();
[/#if]
[#if Peripherals?contains("#CRC#") == true]
    msd_crc_init();
[/#if]
[#if Peripherals?contains("#CTC#") == true]
    msd_ctc_init();
[/#if]
[#if Peripherals?contains("#DAC0#") == true]
    msd_dac0_init();
[/#if]
[#if Peripherals?contains("#FWDGT#") == true]
    msd_fwdgt_init();
[/#if]
[#if Peripherals?contains("#EXMC#") == true]
    msd_exmc_init();
[/#if]
[#if Peripherals?contains("#I2C0#") == true]
    msd_i2c0_init();
[/#if]
[#if Peripherals?contains("#I2C1#") == true]
    msd_i2c1_init();
[/#if]
[#if Peripherals?contains("#I2C2#") == true]
    msd_i2c2_init();
[/#if]
[#if Peripherals?contains("#I2C3#") == true]
    msd_i2c3_init();
[/#if]
[#if Peripherals?contains("#I2S0#") == true]
    msd_i2s0_init();
[/#if]
[#if Peripherals?contains("#I2S1#") == true]
    msd_i2s1_init();
[/#if]
[#if Peripherals?contains("#I2S2#") == true]
    msd_i2s2_init();
[/#if]
[#if Peripherals?contains("#I2S5#") == true]
    msd_i2s5_init();
[/#if]
[#if Peripherals?contains("#RTC#") == true]
    msd_rtc_init();
[/#if]
[#if Peripherals?contains("#SPI0#") == true]
    msd_spi0_init();
[/#if]
[#if Peripherals?contains("#SPI1#") == true]
    msd_spi1_init();
[/#if]
[#if Peripherals?contains("#SPI2#") == true]
    msd_spi2_init();
[/#if]
[#if Peripherals?contains("#SPI3#") == true]
    msd_spi3_init();
[/#if]
[#if Peripherals?contains("#SPI4#") == true]
    msd_spi4_init();
[/#if]
[#if Peripherals?contains("#SPI5#") == true]
    msd_spi5_init();
[/#if]
[#if Peripherals?contains("#TIMER0#") == true]
    msd_timer0_init();
[/#if]
[#if Peripherals?contains("#TIMER1#") == true]
    msd_timer1_init();
[/#if]
[#if Peripherals?contains("#TIMER2#") == true]
    msd_timer2_init();
[/#if]
[#if Peripherals?contains("#TIMER3#") == true]
    msd_timer3_init();
[/#if]
[#if Peripherals?contains("#TIMER4#") == true]
    msd_timer4_init();
[/#if]
[#if Peripherals?contains("#TIMER5#") == true]
    msd_timer5_init();
[/#if]
[#if Peripherals?contains("#TIMER6#") == true]
    msd_timer6_init();
[/#if]
[#if Peripherals?contains("#TIMER7#") == true]
    msd_timer7_init();
[/#if]
[#if Peripherals?contains("#TIMER14#") == true]
    msd_timer14_init();
[/#if]
[#if Peripherals?contains("#TIMER15#") == true]
    msd_timer15_init();
[/#if]
[#if Peripherals?contains("#TIMER16#") == true]
    msd_timer16_init();
[/#if]
[#if Peripherals?contains("#TIMER22#") == true]
    msd_timer22_init();
[/#if]
[#if Peripherals?contains("#TIMER23#") == true]
    msd_timer23_init();
[/#if]
[#if Peripherals?contains("#TIMER40#") == true]
    msd_timer40_init();
[/#if]
[#if Peripherals?contains("#TIMER41#") == true]
    msd_timer41_init();
[/#if]
[#if Peripherals?contains("#TIMER42#") == true]
    msd_timer42_init();
[/#if]
[#if Peripherals?contains("#TIMER43#") == true]
    msd_timer43_init();
[/#if]
[#if Peripherals?contains("#TIMER44#") == true]
    msd_timer44_init();
[/#if]
[#if Peripherals?contains("#TIMER50#") == true]
    msd_timer50_init();
[/#if]
[#if Peripherals?contains("#TIMER51#") == true]
    msd_timer51_init();
[/#if]
[#if Peripherals?contains("#UART3#") == true]
    msd_uart3_init();
[/#if]
[#if Peripherals?contains("#UART4#") == true]
    msd_uart4_init();
[/#if]
[#if Peripherals?contains("#UART6#") == true]
    msd_uart6_init();
[/#if]
[#if Peripherals?contains("#UART7#") == true]
    msd_uart7_init();
[/#if]
[#if Peripherals?contains("#USART0#") == true]
    msd_usart0_init();
[/#if]
[#if Peripherals?contains("#USART1#") == true]
    msd_usart1_init();
[/#if]
[#if Peripherals?contains("#USART2#") == true]
    msd_usart2_init();
[/#if]
[#if Peripherals?contains("#USART5#") == true]
    msd_usart5_init();
[/#if]
[#if Peripherals?contains("#RAMECCMU#") == true]
    msd_rameccmu_init();
[/#if]
[#if Peripherals?contains("#TMU#") == true]
    msd_tmu_init();
[/#if]
[#if Peripherals?contains("#OSPI0#") == true]
    msd_ospi0_init();
[/#if]
[#if Peripherals?contains("#VREF#") == true]
    msd_vref_init();
[/#if]
[#if Peripherals?contains("#LPDTS#") == true]
    msd_lpdts_init();
[/#if]
[#if Peripherals?contains("#EDOUT#") == true]
    msd_edout_init();
[/#if]
[#if Peripherals?contains("#CMP0#") == true]
    msd_cmp0_init();
[/#if]
[#if Peripherals?contains("#CMP1#") == true]
    msd_cmp1_init();
[/#if]
[#if Peripherals?contains("#HPDF#") == true]
    msd_hpdf_init();
[/#if]
[#if Peripherals?contains("#FAC#") == true]
    msd_fac_init();
[/#if]
[#if Peripherals?contains("#USBHS0#") == true]
[#if USBHS0_USB0Mode == "USB0 Device"]
    msd_usbhs0_device_init();
[/#if]
[#if USBHS0_USB0Mode == "USB0 Host"]
    msd_usbhs0_host_init();
[/#if]
[/#if]
[#if Peripherals?contains("#USBHS1#") == true]
[#if USBHS1_USB1Mode == "USB1 Device"]
    msd_usbhs1_device_init();
[/#if]
[#if USBHS1_USB1Mode == "USB1 Host"]
    msd_usbhs1_host_init();
[/#if]
[/#if]
[#if Peripherals?contains("#WWDGT#") == true]
    msd_wwdgt_init();
[/#if]
[#if Peripherals?contains("#TRNG#") == true]
    msd_trng_init();
[/#if]
[#if Peripherals?contains("#TRIGSEL#") == true]
    msd_trigsel_init();
[/#if]

    /* user code [local 2] begin */

    /* user code [local 2] end */

    while(1){
        /* user code [local 3] begin */

        /* user code [local 3] end */
[#if Peripherals?contains("#USBHS0#") == true]
[#if Peripherals?contains("#USB0_HOST#") == true]
        hs0_usbh_core_task();
[/#if]
[/#if]
[#if Peripherals?contains("#USBHS1#") == true]
[#if Peripherals?contains("#USB1_HOST#") == true]
        hs1_usbh_core_task();
[/#if]
[/#if]
    }
}

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Function Implementations] begin */
[#if Peripherals?contains("#FREERTOS#") == true]
/*!
    \brief      default task
    \param[in]  pvParameters not used
    \param[out] none
    \retval     none
*/
void default_task(void *pvParameters)
{
[#if Peripherals?contains("#LWIP#") == true]
[#if LWIP_LWIPEnable_TRUELWIPInformation_LWIPDependencyFreeRTOS == "Enable"]
    /* initialize the LwIP stack */
    lwip_stack_init();
[/#if]
[/#if]

[#if Peripherals?contains("#FREERTOS#") == true && Peripherals?contains("#LWIP#") == true]
    /* user code [local 4] begin */

    for(;;) {
        vTaskDelete(NULL);
    }

    /* user code [local 4] end */
[/#if]
[#if Peripherals?contains("#FREERTOS#") == true && Peripherals?contains("#LWIP#") != true]
    /* user code [local 5] begin */

    for(;;) {
        vTaskDelay(1);
    }

    /* user code [local 5] end */
[/#if]
}
[#else]

[/#if]
/* user code [Private Function Implementations] end */
