[#ftl]
[#-- V1.0.7 --]

[#if RCU_HighSpeedCrystalOscillator == "Clock Bypass"]
    rcu_osci_bypass_mode_enable(RCU_HXTAL);
[/#if]
[#if RCU_LowSpeedCrystalOscillator == "Clock Bypass"]
    rcu_osci_bypass_mode_enable(RCU_LXTAL);
[/#if]

[#if SCS == "RCU_CKSYSSRC_IRC64MDIV" || SCS == ""]
    rcu_osci_on(RCU_IRC64M);
    rcu_irc64m_adjust_value_set(${RCU_ResetAndClockAdjustParameters_IRC64MClockTrimAdjustValue});
    while(rcu_osci_stab_wait(RCU_IRC64M) != SUCCESS);
    rcu_irc64mdiv_clock_config(${IRC64MDIV});

    rcu_ahb_clock_config(${AHBAXIPrescaler});
    rcu_apb1_clock_config(${APB1Prescaler});
    rcu_apb2_clock_config(${APB2Prescaler});
    rcu_apb3_clock_config(${APB3Prescaler});
    rcu_apb4_clock_config(${APB4Prescaler});

    rcu_system_clock_source_config(RCU_CKSYSSRC_IRC64MDIV);
    while(RCU_SCSS_IRC64MDIV != rcu_system_clock_source_get());
[#elseif SCS == "RCU_CKSYSSRC_HXTAL"]
    rcu_osci_on(RCU_HXTAL);
    while(rcu_osci_stab_wait(RCU_HXTAL) != SUCCESS);

    rcu_ahb_clock_config(${AHBAXIPrescaler});
    rcu_apb1_clock_config(${APB1Prescaler});
    rcu_apb2_clock_config(${APB2Prescaler});
    rcu_apb3_clock_config(${APB3Prescaler});
    rcu_apb4_clock_config(${APB4Prescaler});

    rcu_system_clock_source_config(RCU_CKSYSSRC_HXTAL);
    while(RCU_SCSS_HXTAL != rcu_system_clock_source_get());
[#elseif SCS == "RCU_CKSYSSRC_LPIRC4M"]
    rcu_osci_on(RCU_LPIRC4M);
    rcu_lpirc4m_adjust_value_set(${RCU_ResetAndClockAdjustParameters_LPIRC4MClockTrimAdjustValue});
    while(rcu_osci_stab_wait(RCU_LPIRC4M) != SUCCESS);

    rcu_ahb_clock_config(${AHBAXIPrescaler});
    rcu_apb1_clock_config(${APB1Prescaler});
    rcu_apb2_clock_config(${APB2Prescaler});
    rcu_apb3_clock_config(${APB3Prescaler});
    rcu_apb4_clock_config(${APB4Prescaler});

    rcu_system_clock_source_config(RCU_CKSYSSRC_LPIRC4M);
    while(RCU_SCSS_HXTAL != rcu_system_clock_source_get());
[#elseif SCS == "RCU_CKSYSSRC_PLL0P"]
    [#if PLLSEL == "RCU_PLLSRC_IRC64MDIV" || PLLSEL == ""]
        rcu_osci_on(RCU_IRC64M);
        rcu_irc64m_adjust_value_set(${RCU_ResetAndClockAdjustParameters_IRC64MClockTrimAdjustValue});
        while(rcu_osci_stab_wait(RCU_IRC64M) != SUCCESS);
        rcu_irc64mdiv_clock_config(${IRC64MDIV});
    [#elseif PLLSEL == "RCU_PLLSRC_LPIRC4M"]
        rcu_osci_on(RCU_LPIRC4M);
        rcu_lpirc4m_adjust_value_set(${RCU_ResetAndClockAdjustParameters_LPIRC4MClockTrimAdjustValue});
        while(rcu_osci_stab_wait(RCU_LPIRC4M) != SUCCESS);
    [#elseif PLLSEL == "RCU_PLLSRC_HXTAL"]
        rcu_osci_on(RCU_HXTAL);
        while(rcu_osci_stab_wait(RCU_HXTAL) != SUCCESS);
    [/#if]

    rcu_pll_source_config(${PLLSEL});
    [#if PLL0P != "" && PLL0Q != "" && PLL0R != ""]
        rcu_pll0_config((${PLL0PSC}U), (${PLL0N}U), (${PLL0P}U), (${PLL0Q}U), (${PLL0R}U));
    [#elseif PLL0P != "" && PLL0Q != "" && PLL0R = ""]
        rcu_pll0_config((${PLL0PSC}U), (${PLL0N}U), (${PLL0P}U), (${PLL0Q}U), (1U));
    [#elseif PLL0P != "" && PLL0Q = "" && PLL0R != ""]
        rcu_pll0_config((${PLL0PSC}U), (${PLL0N}U), (${PLL0P}U), (2U), (${PLL0R}U));
    [#elseif PLL0P != "" && PLL0Q = "" && PLL0R = ""]
        rcu_pll0_config((${PLL0PSC}U), (${PLL0N}U), (${PLL0P}U), (2U), (1U));
    [#elseif PLL0P = "" && PLL0Q != "" && PLL0R != ""]
        rcu_pll0_config((${PLL0PSC}U), (${PLL0N}U), (1U), (${PLL0Q}U), (${PLL0R}U));
    [#elseif PLL0P = "" && PLL0Q != "" && PLL0R = ""]
        rcu_pll0_config((${PLL0PSC}U), (${PLL0N}U), (1U), (${PLL0Q}U), (1U));
    [#elseif PLL0P = "" && PLL0Q = "" && PLL0R != ""]
        rcu_pll0_config((${PLL0PSC}U), (${PLL0N}U), (1U), (2U), (${PLL0R}U));
    [#elseif PLL0P = "" && PLL0Q = "" && PLL0R = ""]
        rcu_pll0_config((${PLL0PSC}U), (128U), (1U), (2U), (1U));
    [/#if]

    rcu_pll_fractional_config(IDX_PLL0, (${PLL0FRAN}U));
    rcu_pll_fractional_latch_enable(IDX_PLL0);
    [#if RCU_PLLRangeParameter_PLL0InputClockRange == "Between 1 And 2 MHz" && RCU_PLLRangeParameter_PLL0VCORange == "Wide Range(Between 192 And 836 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL0, RCU_PLL0RNG_1M_2M, RCU_PLL0VCO_192M_836M);
    [#elseif RCU_PLLRangeParameter_PLL0InputClockRange == "Between 1 And 2 MHz" && RCU_PLLRangeParameter_PLL0VCORange == "Narrow Range(Between 150 And 420 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL0, RCU_PLL0RNG_1M_2M, RCU_PLL0VCO_150M_420M);
    [#elseif RCU_PLLRangeParameter_PLL0InputClockRange == "Between 2 And 4 MHz" && RCU_PLLRangeParameter_PLL0VCORange == "Wide Range(Between 192 And 836 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL0, RCU_PLL0RNG_2M_4M, RCU_PLL0VCO_192M_836M);
    [#elseif RCU_PLLRangeParameter_PLL0InputClockRange == "Between 2 And 4 MHz" && RCU_PLLRangeParameter_PLL0VCORange == "Narrow Range(Between 150 And 420 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL0, RCU_PLL0RNG_2M_4M, RCU_PLL0VCO_150M_420M);
    [#elseif RCU_PLLRangeParameter_PLL0InputClockRange == "Between 4 And 8 MHz" && RCU_PLLRangeParameter_PLL0VCORange == "Wide Range(Between 192 And 836 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL0, RCU_PLL0RNG_4M_8M, RCU_PLL0VCO_192M_836M);
    [#elseif RCU_PLLRangeParameter_PLL0InputClockRange == "Between 4 And 8 MHz" && RCU_PLLRangeParameter_PLL0VCORange == "Narrow Range(Between 150 And 420 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL0, RCU_PLL0RNG_4M_8M, RCU_PLL0VCO_150M_420M);
    [#elseif RCU_PLLRangeParameter_PLL0InputClockRange == "Between 8 And 16 MHz" && RCU_PLLRangeParameter_PLL0VCORange == "Wide Range(Between 192 And 836 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL0, RCU_PLL0RNG_8M_16M, RCU_PLL0VCO_192M_836M);
    [#elseif RCU_PLLRangeParameter_PLL0InputClockRange == "Between 8 And 16 MHz" && RCU_PLLRangeParameter_PLL0VCORange == "Narrow Range(Between 150 And 420 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL0, RCU_PLL0RNG_8M_16M, RCU_PLL0VCO_150M_420M);
    [/#if]

    rcu_pll_clock_output_enable(RCU_PLL0P);
    rcu_pll_clock_output_enable(RCU_PLL0Q);
    rcu_pll_clock_output_enable(RCU_PLL0R);

    rcu_osci_on(RCU_PLL0_CK);
    while(rcu_osci_stab_wait(RCU_PLL0_CK) != SUCCESS);

    [#if CK_SYS?number > 350]
        syscfg_tcm_wait_state_enable();
    [/#if]

    rcu_ahb_clock_config(${AHBAXIPrescaler});
    rcu_apb1_clock_config(${APB1Prescaler});
    rcu_apb2_clock_config(${APB2Prescaler});
    rcu_apb3_clock_config(${APB3Prescaler});
    rcu_apb4_clock_config(${APB4Prescaler});

    rcu_system_clock_source_config(RCU_CKSYSSRC_PLL0P);
    while(RCU_SCSS_PLL0P != rcu_system_clock_source_get());
[/#if]

[#if RCU_ResetAndClockAdjustParameters_TIMERPrescalerSelection ??== true]
[#if RCU_ResetAndClockAdjustParameters_TIMERPrescalerSelection != "Disable"]
    rcu_timer_clock_prescaler_config(RCU_TIMER_PSC_MUL4);
[/#if]
[/#if]

[#if ((Peripherals?contains("RTC") == true && (RTCSRC == "RCU_RTCSRC_HXTAL_DIV_RTCDIV")) || (CKOUT1SEL == "RCU_CKOUT1SRC_HXTAL") || (CKOUT0SEL == "RCU_CKOUT0SRC_HXTAL")
     || (PLLUSBHS0PRESEL == "RCU_PLLUSBHSPRE_HXTAL") || (PLLUSBHS1PRESEL == "RCU_PLLUSBHSPRE_HXTAL")
     || (CAN0SEL == "RCU_CANSRC_HXTAL") || (CAN1SEL == "RCU_CANSRC_HXTAL") || (CAN2SEL == "RCU_CANSRC_HXTAL") || (PLLSEL == "RCU_PLLSRC_HXTAL")
     || (PERSEL == "RCU_PERSRC_HXTAL") || (SPI3SEL == "RCU_SPISRC_HXTAL") || (SPI4SEL == "RCU_SPISRC_HXTAL") || (SPI5SEL == "RCU_SPISRC_HXTAL"))
     && !((SCS = "RCU_CKSYSSRC_HXTAL") || (SCS == "RCU_CKSYSSRC_PLL0P" && PLLSEL == "RCU_PLLSRC_HXTAL"))]
    rcu_osci_on(RCU_HXTAL);
    while(rcu_osci_stab_wait(RCU_HXTAL) != SUCCESS);
[/#if]

[#if (CKOUT0SEL == "RCU_CKOUT0SRC_IRC48M") || (PLLUSBHS0PRESEL == "RCU_PLLUSBHSPRE_IRC48M") || (USBHS048MSEL == "RCU_USB48MSRC_IRC48M")
    || (PLLUSBHS1PRESEL == "RCU_PLLUSBHSPRE_IRC48M") || Peripherals?contains("CTC") == true || (USBHS148MSEL == "RCU_USB48MSRC_IRC48M") ]
    rcu_osci_on(RCU_IRC48M);
    while(rcu_osci_stab_wait(RCU_IRC48M) != SUCCESS);
[/#if]

[#if (Peripherals?contains("RTC") == true && (RTCSRC == "RCU_RTCSRC_LXTAL")) || (CKOUT0SEL == "RCU_CKOUT0SRC_LXTAL")
    || (USART0SEL == "RCU_USARTSRC_LXTAL") || (USART1SEL == "RCU_USARTSRC_LXTAL") || (USART2SEL == "RCU_USARTSRC_LXTAL") || (USART5SEL == "RCU_USARTSRC_LXTAL")
    || (Peripherals?contains("LPDTS") == true && LPDTS_BasicParameters_ClockReference == "LXTAL") || (Peripherals?contains("CTC") == true && CTC_ReferenceSignalSource == "LXTAL")]
    rcu_periph_clock_enable(RCU_PMU);
    pmu_backup_write_enable();

    rcu_osci_on(RCU_LXTAL);
    while(rcu_osci_stab_wait(RCU_LXTAL) != SUCCESS);
[/#if]

[#if ((CKOUT0SEL == "RCU_CKOUT0SRC_IRC64MDIV") || (CAN0SEL == "RCU_CANSRC_IRC64MDIV") || (CAN1SEL == "RCU_CANSRC_IRC64MDIV") || (CAN2SEL == "RCU_CANSRC_IRC64MDIV")
     || (USART0SEL == "RCU_USARTSRC_IRC64MDIV") || (USART1SEL == "RCU_USARTSRC_IRC64MDIV") || (USART2SEL == "RCU_USARTSRC_IRC64MDIV") || (USART5SEL == "RCU_USARTSRC_IRC64MDIV")
     || (PERSEL == "RCU_PERSRC_IRC64MDIV") || (I2C0SEL == "RCU_I2CSRC_IRC64MDIV") || (I2C1SEL == "RCU_I2CSRC_IRC64MDIV") || (I2C2SEL == "RCU_I2CSRC_IRC64MDIV") || (I2C3SEL == "RCU_I2CSRC_IRC64MDIV")
     || (SPI3SEL == "RCU_SPISRC_IRC64MDIV") || (SPI4SEL == "RCU_SPISRC_IRC64MDIV") || (SPI5SEL == "RCU_SPISRC_IRC64MDIV") || (PLLSEL == "RCU_PLLSRC_IRC64MDIV"))
    && !((SCS == "RCU_CKSYSSRC_IRC64MDIV") || (SCS == "RCU_CKSYSSRC_PLL0P" && PLLSEL == "RCU_PLLSRC_IRC64MDIV"))]
    rcu_osci_on(RCU_IRC64M);
    rcu_irc64m_adjust_value_set(${RCU_ResetAndClockAdjustParameters_IRC64MClockTrimAdjustValue});
    while(rcu_osci_stab_wait(RCU_IRC64M) != SUCCESS);
    rcu_irc64mdiv_clock_config(${IRC64MDIV});
[/#if]

[#if ((CKOUT1SEL == "RCU_CKOUT1SRC_LPIRC4M") || (PLLSEL == "RCU_PLLSRC_LPIRC4M") || (PERSEL == "RCU_PERSRC_LPIRC4M")
      || (I2C0SEL == "RCU_I2CSRC_LPIRC4M") || (I2C1SEL == "RCU_I2CSRC_LPIRC4M") || (I2C2SEL == "RCU_I2CSRC_LPIRC4M") || (I2C3SEL == "RCU_I2CSRC_LPIRC4M")
      || (SPI3SEL == "RCU_SPISRC_LPIRC4M") || (SPI4SEL == "RCU_SPISRC_LPIRC4M") || (SPI5SEL == "RCU_SPISRC_LPIRC4M"))
     && !((SCS == "RCU_CKSYSSRC_LPIRC4M") || (SCS == "RCU_CKSYSSRC_PLL0P" && PLLSEL == "RCU_PLLSRC_LPIRC4M"))]
    rcu_osci_on(RCU_LPIRC4M);
    rcu_lpirc4m_adjust_value_set(${RCU_ResetAndClockAdjustParameters_LPIRC4MClockTrimAdjustValue});
    while(rcu_osci_stab_wait(RCU_LPIRC4M) != SUCCESS);
[/#if]

[#if (Peripherals?contains("RTC") == true && (RTCSRC == "RCU_RTCSRC_IRC32K"))
     || (Peripherals?contains("FWDGT") == true) || (Peripherals?contains("DAC") == true) || (CKOUT1SEL == "RCU_CKOUT1SRC_IRC32K")]
    rcu_osci_on(RCU_IRC32K);
    while(rcu_osci_stab_wait(RCU_IRC32K) != SUCCESS);
[/#if]

[#if ((CKOUT1SEL == "RCU_CKOUT1SRC_PLL0P" || CKOUT0SEL == "RCU_CKOUT0SRC_PLL0P" || USBHS148MSEL == "RCU_USB48MSRC_PLL0R" || HPDFASEL == "RCU_HPDFASRC_PLL0Q" || EXMCSEL == "RCU_EXMCSRC_PLL0Q"
    || SPI2SEL == "RCU_SPISRC_PLL0Q" || SPI1SEL == "RCU_SPISRC_PLL0Q" || EXMCSEL == "RCU_EXMC_CKSRC_CK_PLL0Q" || USBHS048MSEL == "RCU_USB48MSRC_PLL0R"
    || SPI0SEL == "RCU_SPISRC_PLL0Q" || ((CK48MSEL == "RCU_CK48MSRC_PLL48M") && (PLL48MSEL == "RCU_PLL48MSRC_PLL0Q"))) && (SCS != "RCU_CKSYSSRC_PLL0P"))]
    [#if PLLSEL == ""]
        rcu_osci_on(RCU_IRC64M);
        rcu_irc64m_adjust_value_set(${RCU_ResetAndClockAdjustParameters_IRC64MClockTrimAdjustValue});
        while(rcu_osci_stab_wait(RCU_IRC64M) != SUCCESS);
        rcu_irc64mdiv_clock_config(${IRC64MDIV});
    [/#if]

    [#if SCS != "RCU_CKSYSSRC_PLL0P"]
        rcu_pll_source_config(${PLLSEL});
    [/#if]
    [#if PLL0P != "" && PLL0Q != "" && PLL0R != ""]
        rcu_pll0_config((${PLL0PSC}U), (${PLL0N}U), (${PLL0P}U), (${PLL0Q}U), (${PLL0R}U));
    [#elseif PLL0P != "" && PLL0Q != "" && PLL0R = ""]
        rcu_pll0_config((${PLL0PSC}U), (${PLL0N}U), (${PLL0P}U), (${PLL0Q}U), (1U));
    [#elseif PLL0P != "" && PLL0Q = "" && PLL0R != ""]
        rcu_pll0_config((${PLL0PSC}U), (${PLL0N}U), (${PLL0P}U), (2U), (${PLL0R}U));
    [#elseif PLL0P != "" && PLL0Q = "" && PLL0R = ""]
        rcu_pll0_config((${PLL0PSC}U), (${PLL0N}U), (${PLL0P}U), (2U), (1U));
    [#elseif PLL0P = "" && PLL0Q != "" && PLL0R != ""]
        rcu_pll0_config((${PLL0PSC}U), (${PLL0N}U), (1U), (${PLL0Q}U), (${PLL0R}U));
    [#elseif PLL0P != "" && PLL0Q != "" && PLL0R = ""]
        rcu_pll0_config((${PLL0PSC}U), (${PLL0N}U), (1U), (${PLL0Q}U), (1U));
    [#elseif PLL0P = "" && PLL0Q = "" && PLL0R != ""]
        rcu_pll0_config((${PLL0PSC}U), (${PLL0N}U), (1U), (2U), (${PLL0R}U));
    [#elseif PLL0P = "" && PLL0Q = "" && PLL0R = ""]
        rcu_pll0_config((${PLL0PSC}U), (128U), (1U), (2U), (1U));
    [/#if]

    rcu_pll_fractional_config(IDX_PLL0, (${PLL0FRAN}U));
    rcu_pll_fractional_latch_enable(IDX_PLL0);
    [#if RCU_PLLRangeParameter_PLL0InputClockRange == "Between 1 And 2 MHz" && RCU_PLLRangeParameter_PLL0VCORange == "Wide Range(Between 192 And 836 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL0, RCU_PLL0RNG_1M_2M, RCU_PLL0VCO_192M_836M);
    [#elseif RCU_PLLRangeParameter_PLL0InputClockRange == "Between 1 And 2 MHz" && RCU_PLLRangeParameter_PLL0VCORange == "Narrow Range(Between 150 And 420 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL0, RCU_PLL0RNG_1M_2M, RCU_PLL0VCO_150M_420M);
    [#elseif RCU_PLLRangeParameter_PLL0InputClockRange == "Between 2 And 4 MHz" && RCU_PLLRangeParameter_PLL0VCORange == "Wide Range(Between 192 And 836 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL0, RCU_PLL0RNG_2M_4M, RCU_PLL0VCO_192M_836M);
    [#elseif RCU_PLLRangeParameter_PLL0InputClockRange == "Between 2 And 4 MHz" && RCU_PLLRangeParameter_PLL0VCORange == "Narrow Range(Between 150 And 420 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL0, RCU_PLL0RNG_2M_4M, RCU_PLL0VCO_150M_420M);
    [#elseif RCU_PLLRangeParameter_PLL0InputClockRange == "Between 4 And 8 MHz" && RCU_PLLRangeParameter_PLL0VCORange == "Wide Range(Between 192 And 836 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL0, RCU_PLL0RNG_4M_8M, RCU_PLL0VCO_192M_836M);
    [#elseif RCU_PLLRangeParameter_PLL0InputClockRange == "Between 4 And 8 MHz" && RCU_PLLRangeParameter_PLL0VCORange == "Narrow Range(Between 150 And 420 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL0, RCU_PLL0RNG_4M_8M, RCU_PLL0VCO_150M_420M);
    [#elseif RCU_PLLRangeParameter_PLL0InputClockRange == "Between 8 And 16 MHz" && RCU_PLLRangeParameter_PLL0VCORange == "Wide Range(Between 192 And 836 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL0, RCU_PLL0RNG_8M_16M, RCU_PLL0VCO_192M_836M);
    [#elseif RCU_PLLRangeParameter_PLL0InputClockRange == "Between 8 And 16 MHz" && RCU_PLLRangeParameter_PLL0VCORange == "Narrow Range(Between 150 And 420 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL0, RCU_PLL0RNG_8M_16M, RCU_PLL0VCO_150M_420M);
    [/#if]

    rcu_pll_clock_output_enable(RCU_PLL0P);
    rcu_pll_clock_output_enable(RCU_PLL0Q);
    rcu_pll_clock_output_enable(RCU_PLL0R);

    rcu_osci_on(RCU_PLL0_CK);
    while(rcu_osci_stab_wait(RCU_PLL0_CK) != SUCCESS);
[/#if]

[#if CKOUT1SEL == "RCU_CKOUT1SRC_PLL1R" || USBHS048MSEL == "RCU_USB48MSRC_PLL1Q" || USBHS148MSEL == "RCU_USB48MSRC_PLL1Q"
    || EXMCSEL == "RCU_EXMCSRC_PLL1R"   || SPI0SEL == "RCU_SPISRC_PLL1P"         || SPI1SEL == "RCU_SPISRC_PLL1P"
    || SPI2SEL == "RCU_SPISRC_PLL1P"    || SPI3SEL == "RCU_SPISRC_PLL1Q"         || SPI4SEL == "RCU_SPISRC_PLL1Q"
    || SPI5SEL == "RCU_SPISRC_PLL1Q"    || HPDFASEL == "RCU_HPDFASRC_PLL1P"      || ADC01SEL == "RCU_ADCSRC_PLL1P" || ADC2SEL == "RCU_ADCSRC_PLL1P"]
    [#if (PLLSEL == "") && !(((CKOUT1SEL == "RCU_CKOUT1SRC_PLL0P" || CKOUT0SEL == "RCU_CKOUT0SRC_PLL0P" || USBHS148MSEL == "RCU_USB48MSRC_PLL0R" || HPDFASEL == "RCU_HPDFASRC_PLL0Q"
    || SPI2SEL == "RCU_SPISRC_PLL0Q" || SPI1SEL == "RCU_SPISRC_PLL0Q" || EXMCSEL == "RCU_EXMC_CKSRC_CK_PLL0Q" || USBHS048MSEL == "RCU_USB48MSRC_PLL0R"
    || SPI0SEL == "RCU_SPISRC_PLL0Q" || CK48MSEL == "RCU_CK48MSRC_PLL48M") && (SCS != "RCU_CKSYSSRC_PLL0P")))]
        rcu_osci_on(RCU_IRC64M);
        rcu_irc64m_adjust_value_set(${RCU_ResetAndClockAdjustParameters_IRC64MClockTrimAdjustValue});
        while(rcu_osci_stab_wait(RCU_IRC64M) != SUCCESS);
        rcu_irc64mdiv_clock_config(${IRC64MDIV});
    [/#if]

    [#if !((CKOUT1SEL == "RCU_CKOUT1SRC_PLL0P" || CKOUT0SEL == "RCU_CKOUT0SRC_PLL0P" || USBHS148MSEL == "RCU_USB48MSRC_PLL0R" || HPDFASEL == "RCU_HPDFASRC_PLL0Q"
    || SPI2SEL == "RCU_SPISRC_PLL0Q" || SPI1SEL == "RCU_SPISRC_PLL0Q" || EXMCSEL == "RCU_EXMC_CKSRC_CK_PLL0Q" || USBHS048MSEL == "RCU_USB48MSRC_PLL0R"
    || SPI0SEL == "RCU_SPISRC_PLL0Q" || ((CK48MSEL == "RCU_CK48MSRC_PLL48M") && (PLL48MSEL == "RCU_PLL48MSRC_PLL0Q"))) && (SCS != "RCU_CKSYSSRC_PLL0P"))]
        rcu_pll_source_config(${PLLSEL});
    [/#if]
    [#if PLL1P != "" && PLL1Q != "" && PLL1R != ""]
        rcu_pll1_config((${PLL1PSC}U), (${PLL1N}U), (${PLL1P}U), (${PLL1Q}U), (${PLL1R}U));
    [#elseif PLL1P != "" && PLL1Q != "" && PLL1R = ""]
        rcu_pll1_config((${PLL1PSC}U), (${PLL1N}U), (${PLL1P}U), (${PLL1Q}U), (1U));
    [#elseif PLL1P != "" && PLL1Q = "" && PLL1R != ""]
        rcu_pll1_config((${PLL1PSC}U), (${PLL1N}U), (${PLL1P}U), (2U), (${PLL1R}U));
    [#elseif PLL1P != "" && PLL1Q = "" && PLL1R = ""]
        rcu_pll1_config((${PLL1PSC}U), (${PLL1N}U), (${PLL1P}U), (2U), (1U));
    [#elseif PLL1P = "" && PLL1Q != "" && PLL1R != ""]
        rcu_pll1_config((${PLL1PSC}U), (${PLL1N}U), (1U), (${PLL1Q}U), (${PLL1R}U));
    [#elseif PLL1P = "" && PLL1Q != "" && PLL1R = ""]
        rcu_pll1_config((${PLL1PSC}U), (${PLL1N}U), (1U), (${PLL1Q}U), (1U));
    [#elseif PLL1P = "" && PLL1Q = "" && PLL1R != ""]
        rcu_pll1_config((${PLL1PSC}U), (${PLL1N}U), (1U), (2U), (${PLL1R}U));
    [#elseif PLL1P = "" && PLL1Q = "" && PLL1R = ""]
        rcu_pll1_config((${PLL1PSC}U), (128U), (1U), (2U), (1U));
    [/#if]

    rcu_pll_fractional_config(IDX_PLL1, (${PLL1FRAN}U));
    rcu_pll_fractional_latch_enable(IDX_PLL1);
    [#if RCU_PLLRangeParameter_PLL1InputClockRange == "Between 1 And 2 MHz" && RCU_PLLRangeParameter_PLL1VCORange == "Wide Range(Between 192 And 836 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL1, RCU_PLL1RNG_1M_2M, RCU_PLL1VCO_192M_836M);
    [#elseif RCU_PLLRangeParameter_PLL1InputClockRange == "Between 1 And 2 MHz" && RCU_PLLRangeParameter_PLL1VCORange == "Narrow Range(Between 150 And 420 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL1, RCU_PLL1RNG_1M_2M, RCU_PLL1VCO_150M_420M);
    [#elseif RCU_PLLRangeParameter_PLL1InputClockRange == "Between 2 And 4 MHz" && RCU_PLLRangeParameter_PLL1VCORange == "Wide Range(Between 192 And 836 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL1, RCU_PLL1RNG_2M_4M, RCU_PLL1VCO_192M_836M);
    [#elseif RCU_PLLRangeParameter_PLL1InputClockRange == "Between 2 And 4 MHz" && RCU_PLLRangeParameter_PLL1VCORange == "Narrow Range(Between 150 And 420 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL1, RCU_PLL1RNG_2M_4M, RCU_PLL1VCO_150M_420M);
    [#elseif RCU_PLLRangeParameter_PLL1InputClockRange == "Between 4 And 8 MHz" && RCU_PLLRangeParameter_PLL1VCORange == "Wide Range(Between 192 And 836 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL1, RCU_PLL1RNG_4M_8M, RCU_PLL1VCO_192M_836M);
    [#elseif RCU_PLLRangeParameter_PLL1InputClockRange == "Between 4 And 8 MHz" && RCU_PLLRangeParameter_PLL1VCORange == "Narrow Range(Between 150 And 420 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL1, RCU_PLL1RNG_4M_8M, RCU_PLL1VCO_150M_420M);
    [#elseif RCU_PLLRangeParameter_PLL1InputClockRange == "Between 8 And 16 MHz" && RCU_PLLRangeParameter_PLL1VCORange == "Wide Range(Between 192 And 836 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL1, RCU_PLL1RNG_8M_16M, RCU_PLL1VCO_192M_836M);
    [#elseif RCU_PLLRangeParameter_PLL1InputClockRange == "Between 8 And 16 MHz" && RCU_PLLRangeParameter_PLL1VCORange == "Narrow Range(Between 150 And 420 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL1, RCU_PLL1RNG_8M_16M, RCU_PLL1VCO_150M_420M);
    [/#if]

    rcu_pll_clock_output_enable(RCU_PLL1P);
    rcu_pll_clock_output_enable(RCU_PLL1Q);
    rcu_pll_clock_output_enable(RCU_PLL1R);

    rcu_osci_on(RCU_PLL1_CK);
    while(rcu_osci_stab_wait(RCU_PLL1_CK) != SUCCESS);
[/#if]

[#if ((CK48MSEL == "RCU_CK48MSRC_PLL48M") && (PLL48MSEL == "RCU_PLL48MSRC_PLL2P")) || SPI0SEL == "RCU_SPISRC_PLL2P" || SPI1SEL == "RCU_SPISRC_PLL2P" || SPI2SEL == "RCU_SPISRC_PLL2P"
    || SPI3SEL == "RCU_SPISRC_PLL2Q" || SPI4SEL == "RCU_SPISRC_PLL2Q" || SPI5SEL == "RCU_SPISRC_PLL2Q"
    || HPDFASEL == "RCU_HPDFASRC_PLL2P" || I2C0SEL == "RCU_I2CSRC_PLL2R" || I2C1SEL == "RCU_I2CSRC_PLL2R" || I2C2SEL == "RCU_I2CSRC_PLL2R"
    || I2C3SEL == "RCU_I2CSRC_PLL2R" || ADC01SEL == "RCU_ADCSRC_PLL2R" || ADC2SEL == "RCU_ADCSRC_PLL2R" || CKOUT1SEL == "RCU_CKOUT1SRC_PLL2R"]
    [#if (PLLSEL == "")
    && !(((CKOUT1SEL == "RCU_CKOUT1SRC_PLL0P" || CKOUT0SEL == "RCU_CKOUT0SRC_PLL0P" || USBHS148MSEL == "RCU_USB48MSRC_PLL0R" || HPDFASEL == "RCU_HPDFASRC_PLL0Q"
    || SPI2SEL == "RCU_SPISRC_PLL0Q" || SPI1SEL == "RCU_SPISRC_PLL0Q" || EXMCSEL == "RCU_EXMC_CKSRC_CK_PLL0Q" || USBHS048MSEL == "RCU_USB48MSRC_PLL0R"
    || SPI0SEL == "RCU_SPISRC_PLL0Q" || ((CK48MSEL == "RCU_CK48MSRC_PLL48M") && (PLL48MSEL == "RCU_PLL48MSRC_PLL0Q"))) && (SCS != "RCU_CKSYSSRC_PLL0P")))
    && !(CKOUT1SEL == "RCU_CKOUT1SRC_PLL1R" || USBHS048MSEL == "RCU_USB48MSRC_PLL1Q" || USBHS148MSEL == "RCU_USB48MSRC_PLL1Q"
    || EXMCSEL == "RCU_EXMCSRC_PLL1R" || SPI0SEL == "RCU_SPISRC_PLL1P" || SPI1SEL == "RCU_SPISRC_PLL1P"
    || SPI2SEL == "RCU_SPISRC_PLL1P" || SPI3SEL == "RCU_SPISRC_PLL1Q"  || SPI4SEL == "RCU_SPISRC_PLL1Q"
    || SPI5SEL == "RCU_SPISRC_PLL1Q" || HPDFASEL == "RCU_HPDFASRC_PLL1P" || ADC01SEL == "RCU_ADCSRC_PLL1P" || ADC2SEL == "RCU_ADCSRC_PLL1P")]
        rcu_osci_on(RCU_IRC64M);
        rcu_irc64m_adjust_value_set(${RCU_ResetAndClockAdjustParameters_IRC64MClockTrimAdjustValue});
        while(rcu_osci_stab_wait(RCU_IRC64M) != SUCCESS);
        rcu_irc64mdiv_clock_config(${IRC64MDIV});
    [/#if]

    [#if !(CKOUT1SEL == "RCU_CKOUT1SRC_PLL1R" || USBHS048MSEL == "RCU_USB48MSRC_PLL1Q" || USBHS148MSEL == "RCU_USB48MSRC_PLL1Q"
    || EXMCSEL == "RCU_EXMCSRC_PLL1R"   || SPI0SEL == "RCU_SPISRC_PLL1P"         || SPI1SEL == "RCU_SPISRC_PLL1P"
    || SPI2SEL == "RCU_SPISRC_PLL1P"    || SPI3SEL == "RCU_SPISRC_PLL1Q"         || SPI4SEL == "RCU_SPISRC_PLL1Q"
    || SPI5SEL == "RCU_SPISRC_PLL1Q"    || HPDFASEL == "RCU_HPDFASRC_PLL1P"      || ADC01SEL == "RCU_ADCSRC_PLL1P" || ADC2SEL == "RCU_ADCSRC_PLL1P")
    && !((CKOUT1SEL == "RCU_CKOUT1SRC_PLL0P" || CKOUT0SEL == "RCU_CKOUT0SRC_PLL0P" || USBHS148MSEL == "RCU_USB48MSRC_PLL0R" || HPDFASEL == "RCU_HPDFASRC_PLL0Q"
    || SPI2SEL == "RCU_SPISRC_PLL0Q" || SPI1SEL == "RCU_SPISRC_PLL0Q" || EXMCSEL == "RCU_EXMC_CKSRC_CK_PLL0Q" || USBHS048MSEL == "RCU_USB48MSRC_PLL0R"
    || SPI0SEL == "RCU_SPISRC_PLL0Q" || ((CK48MSEL == "RCU_CK48MSRC_PLL48M") && (PLL48MSEL == "RCU_PLL48MSRC_PLL0Q"))))]
        rcu_pll_source_config(${PLLSEL});
    [/#if]
    [#if PLL2P != "" && PLL2Q != "" && PLL2R != ""]
        rcu_pll2_config((${PLL2PSC}U), (${PLL2N}U), (${PLL2P}U), (${PLL2Q}U), (${PLL2R}U));
    [#elseif PLL2P != "" && PLL2Q != "" && PLL2R = ""]
        rcu_pll2_config((${PLL2PSC}U), (${PLL2N}U), (${PLL2P}U), (${PLL2Q}U), (1U));
    [#elseif PLL2P != "" && PLL2Q = "" && PLL2R != ""]
        rcu_pll2_config((${PLL2PSC}U), (${PLL2N}U), (${PLL2P}U), (2U), (${PLL2R}U));
    [#elseif PLL2P != "" && PLL2Q = "" && PLL2R = ""]
        rcu_pll2_config((${PLL2PSC}U), (${PLL2N}U), (${PLL2P}U), (2U), (1U));
    [#elseif PLL2P = "" && PLL2Q != "" && PLL2R != ""]
        rcu_pll2_config((${PLL2PSC}U), (${PLL2N}U), (1U), (${PLL2Q}U), (${PLL2R}U));
    [#elseif PLL2P = "" && PLL2Q != "" && PLL2R = ""]
        rcu_pll2_config((${PLL2PSC}U), (${PLL2N}U), (1U), (${PLL2Q}U), (1U));
    [#elseif PLL2P = "" && PLL2Q = "" && PLL2R != ""]
        rcu_pll2_config((${PLL2PSC}U), (${PLL2N}U), (1U), (2U), (${PLL2R}U));
    [#elseif PLL2P = "" && PLL2Q = "" && PLL2R = ""]
        rcu_pll2_config((${PLL2PSC}U), (128U), (1U), (2U), (1U));
    [/#if]

    rcu_pll_fractional_config(IDX_PLL2, (${PLL2FRAN}U));
    rcu_pll_fractional_latch_enable(IDX_PLL2);
    [#if RCU_PLLRangeParameter_PLL2InputClockRange == "Between 1 And 2 MHz" && RCU_PLLRangeParameter_PLL2VCORange == "Wide Range(Between 192 And 836 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL2, RCU_PLL2RNG_1M_2M, RCU_PLL2VCO_192M_836M);
    [#elseif RCU_PLLRangeParameter_PLL2InputClockRange == "Between 1 And 2 MHz" && RCU_PLLRangeParameter_PLL2VCORange == "Narrow Range(Between 150 And 420 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL2, RCU_PLL2RNG_1M_2M, RCU_PLL2VCO_150M_420M);
    [#elseif RCU_PLLRangeParameter_PLL2InputClockRange == "Between 2 And 4 MHz" && RCU_PLLRangeParameter_PLL2VCORange == "Wide Range(Between 192 And 836 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL2, RCU_PLL2RNG_2M_4M, RCU_PLL2VCO_192M_836M);
    [#elseif RCU_PLLRangeParameter_PLL2InputClockRange == "Between 2 And 4 MHz" && RCU_PLLRangeParameter_PLL2VCORange == "Narrow Range(Between 150 And 420 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL2, RCU_PLL2RNG_2M_4M, RCU_PLL2VCO_150M_420M);
    [#elseif RCU_PLLRangeParameter_PLL2InputClockRange == "Between 4 And 8 MHz" && RCU_PLLRangeParameter_PLL2VCORange == "Wide Range(Between 192 And 836 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL2, RCU_PLL2RNG_4M_8M, RCU_PLL2VCO_192M_836M);
    [#elseif RCU_PLLRangeParameter_PLL2InputClockRange == "Between 4 And 8 MHz" && RCU_PLLRangeParameter_PLL2VCORange == "Narrow Range(Between 150 And 420 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL2, RCU_PLL2RNG_4M_8M, RCU_PLL2VCO_150M_420M);
    [#elseif RCU_PLLRangeParameter_PLL2InputClockRange == "Between 8 And 16 MHz" && RCU_PLLRangeParameter_PLL2VCORange == "Wide Range(Between 192 And 836 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL2, RCU_PLL2RNG_8M_16M, RCU_PLL2VCO_192M_836M);
    [#elseif RCU_PLLRangeParameter_PLL2InputClockRange == "Between 8 And 16 MHz" && RCU_PLLRangeParameter_PLL2VCORange == "Narrow Range(Between 150 And 420 MHz)"]
    rcu_pll_input_output_clock_range_config(IDX_PLL2, RCU_PLL2RNG_8M_16M, RCU_PLL2VCO_150M_420M);
    [/#if]

    rcu_pll_clock_output_enable(RCU_PLL2P);
    rcu_pll_clock_output_enable(RCU_PLL2Q);
    rcu_pll_clock_output_enable(RCU_PLL2R);

    rcu_osci_on(RCU_PLL2_CK);
    while(rcu_osci_stab_wait(RCU_PLL2_CK) != SUCCESS);
[/#if]

[#if EXMCSEL == "RCU_EXMCSRC_PER" || SPI0SEL == "RCU_SPISRC_PER" || SPI1SEL == "RCU_SPISRC_PER" || SPI2SEL == "RCU_SPISRC_PER"
    || HPDFASEL == "RCU_HPDFASRC_PER" || ADC01SEL == "RCU_ADCSRC_PER" || CKOUT0SEL == "RCU_CKOUT0SRC_PER"]
    rcu_per_clock_config(${PERSEL});
[/#if]

[#if (Peripherals?contains("USBHS1") == true) || (Peripherals?contains("USBHS0") == true)]
    pmu_usb_regulator_enable();
    pmu_usb_voltage_detector_enable();
    while(SET != pmu_flag_get(PMU_FLAG_USB33RF));
[/#if]

[#if ((Peripherals?contains("USBHS0") == true) && (USBHS0_InternalPhy != "Disable")
     && ((USBHS048MSEL == "RCU_USB48MSRC_PLLUSBHS" && (USBHS0SEL == "RCU_USBHSSEL_48M")) || (USBHS0SEL == "RCU_USBHSSEL_60M")))]
    [#if PLLUSBHS0PRESEL != ""]
        [#if (USBHS048MSEL == "RCU_USB48MSRC_PLLUSBHS" && (USBHS0SEL == "RCU_USBHSSEL_48M"))]
            rcu_pllusb0_config(${PLLUSBHS0PRESEL}, ${PLLUSBHS0PREDV}, ${PLLUSBHS0MF}, ${USBHS0DV});
        [#else]
            rcu_pllusb0_config(${PLLUSBHS0PRESEL}, ${PLLUSBHS0PREDV}, ${PLLUSBHS0MF}, RCU_USBHS_DIV2);
        [/#if]
    [#else]
        [#if (USBHS048MSEL == "RCU_USB48MSRC_PLLUSBHS" && (USBHS0SEL == "RCU_USBHSSEL_48M"))]
            rcu_pllusb0_config(RCU_PLLUSBHSPRE_HXTAL, ${PLLUSBHS0PREDV}, ${PLLUSBHS0MF}, ${USBHS0DV});
        [#else]
            rcu_pllusb0_config(RCU_PLLUSBHSPRE_HXTAL, ${PLLUSBHS0PREDV}, ${PLLUSBHS0MF}, RCU_USBHS_DIV2);
        [/#if]
    [/#if]

    rcu_osci_on(RCU_PLLUSBHS0_CK);
    while(rcu_osci_stab_wait(RCU_PLLUSBHS0_CK) != SUCCESS);

    [#if (USBHS048MSEL == "RCU_USB48MSRC_PLLUSBHS" && (USBHS0SEL == "RCU_USBHSSEL_48M"))]
        rcu_usb48m_clock_config(IDX_USBHS0, RCU_USB48MSRC_PLLUSBHS);
        rcu_usbhs_clock_config(IDX_USBHS0, RCU_USBHSSEL_48M);
    [#else]
        rcu_usbhs_clock_config(IDX_USBHS0, RCU_USBHSSEL_60M);
    [/#if]
[/#if]

[#if ((Peripherals?contains("USBHS1") == true) && ((USBHS148MSEL == "RCU_USB48MSRC_PLLUSBHS" && (USBHS1SEL == "RCU_USBHSSEL_48M")) || (USBHS1SEL == "RCU_USBHSSEL_60M")))]
    [#if PLLUSBHS1PRESEL != ""]
        [#if (USBHS148MSEL == "RCU_USB48MSRC_PLLUSBHS" && (USBHS1SEL == "RCU_USBHSSEL_48M"))]
            rcu_pllusb1_config(${PLLUSBHS1PRESEL}, ${PLLUSBHS1PREDV}, ${PLLUSBHS1MF}, ${USBHS1DV});
        [#else]
            rcu_pllusb1_config(${PLLUSBHS1PRESEL}, ${PLLUSBHS1PREDV}, ${PLLUSBHS1MF}, (2U));
        [/#if]
    [#else]
        [#if (USBHS148MSEL == "RCU_USB48MSRC_PLLUSBHS" && (USBHS1SEL == "RCU_USBHSSEL_48M"))]
            rcu_pllusb1_config(RCU_PLLUSBHSPRE_HXTAL, ${PLLUSBHS1PREDV}, ${PLLUSBHS1MF}, ${USBHS1DV});
        [#else]
            rcu_pllusb1_config(RCU_PLLUSBHSPRE_HXTAL, ${PLLUSBHS1PREDV}, ${PLLUSBHS1MF}, (2U));
        [/#if]
    [/#if]

    rcu_osci_on(RCU_PLLUSBHS1_CK);
    while(rcu_osci_stab_wait(RCU_PLLUSBHS1_CK) != SUCCESS);

    [#if (USBHS148MSEL == "RCU_USB48MSRC_PLLUSBHS" && (USBHS1SEL == "RCU_USBHSSEL_48M"))]
        rcu_usb48m_clock_config(IDX_USBHS1, RCU_USB48MSRC_PLLUSBHS);
        rcu_usbhs_clock_config(IDX_USBHS1, RCU_USBHSSEL_48M);
    [#else]
        rcu_usbhs_clock_config(IDX_USBHS1, RCU_USBHSSEL_60M);
    [/#if]
[/#if]

[#if Peripherals?contains("RTC") == true]
    [#if (Peripherals?contains("RTC") == true && (RTCSRC == "RCU_RTCSRC_HXTAL_DIV_RTCDIV"))]
        rcu_rtc_div_config(${RTCDIV});
    [/#if]
    [#if RTCSRC != ""]
        rcu_rtc_clock_config(${RTCSRC});
    [#else]
        rcu_rtc_clock_config(RCU_RTCSRC_NONE);
    [/#if]
[/#if]

[#if Peripherals?contains("TRNG") == true]
    [#if CK48MSEL == "RCU_CK48MSRC_PLL48M"]
        rcu_pll48m_clock_config(${PLL48MSEL});
        rcu_ck48m_clock_config(RCU_CK48MSRC_PLL48M);
    [#else]
        rcu_ck48m_clock_config(RCU_CK48MSRC_IRC48M);
    [/#if]
[/#if]

[#if (Peripherals?contains("USBHS0") == true) && (USBHS0_InternalPhy != "Disable")
    && !((USBHS048MSEL == "RCU_USB48MSRC_PLLUSBHS" && (USBHS0SEL == "RCU_USBHSSEL_48M")) || (USBHS0SEL == "RCU_USBHSSEL_60M"))]
    [#if USBHS048MSEL == "RCU_USB48MSRC_PLL1Q"]
        rcu_usbhs_pll1qpsc_config(IDX_USBHS0, ${USBHS0PSC});
    [/#if]
        rcu_usb48m_clock_config(IDX_USBHS0, ${USBHS048MSEL});
        rcu_usbhs_clock_config(IDX_USBHS0, RCU_USBHSSEL_48M);
[/#if]

[#if ((Peripherals?contains("USBHS1") == true) && !((USBHS148MSEL == "RCU_USB48MSRC_PLLUSBHS" && (USBHS1SEL == "RCU_USBHSSEL_48M")) || (USBHS1SEL == "RCU_USBHSSEL_60M")))]
    [#if USBHS148MSEL == "RCU_USB48MSRC_PLL1Q"]
        rcu_usbhs_pll1qpsc_config(IDX_USBHS1, ${USBHS1PSC});
    [/#if]
        rcu_usb48m_clock_config(IDX_USBHS1, ${USBHS148MSEL});
        rcu_usbhs_clock_config(IDX_USBHS1, RCU_USBHSSEL_48M);
[/#if]

[#if Peripherals?contains("CAN0") == true]
    [#if CAN0SEL != ""]
        rcu_can_clock_config(IDX_CAN0, ${CAN0SEL});
    [#else]
        rcu_can_clock_config(IDX_CAN0, RCU_CANSRC_HXTAL);
    [/#if]
[/#if]
[#if Peripherals?contains("CAN1") == true]
    [#if CAN1SEL != ""]
        rcu_can_clock_config(IDX_CAN1, ${CAN1SEL});
    [#else]
        rcu_can_clock_config(IDX_CAN1, RCU_CANSRC_HXTAL);
    [/#if]
[/#if]
[#if Peripherals?contains("CAN2") == true]
    [#if CAN2SEL != ""]
        rcu_can_clock_config(IDX_CAN2, ${CAN2SEL});
    [#else]
        rcu_can_clock_config(IDX_CAN2, RCU_CANSRC_HXTAL);
    [/#if]
[/#if]

[#if Peripherals?contains("EXMC") == true]
    [#if (EXMCSEL != "") || (EXMCSEL == "RCU_EXMCSRC_PER" && PERSEL != "")]
        rcu_exmc_clock_config(${EXMCSEL});
    [#else]
        rcu_exmc_clock_config(RCU_EXMCSRC_AHB);
    [/#if]
[/#if]

[#if Peripherals?contains("SPI0") == true || Peripherals?contains("I2S0") == true]
    [#if (SPI0SEL != "") || (SPI0SEL == "RCU_SPISRC_PER" && PERSEL != "")]
        rcu_spi_clock_config(IDX_SPI0, ${SPI0SEL});
    [#else]
        rcu_spi_clock_config(IDX_SPI0, RCU_SPISRC_PLL0Q);
    [/#if]
[/#if]
[#if Peripherals?contains("SPI1") == true || Peripherals?contains("I2S1") == true]
    [#if (SPI1SEL != "") || (SPI1SEL == "RCU_SPISRC_PER" && PERSEL != "")]
        rcu_spi_clock_config(IDX_SPI1, ${SPI1SEL});
    [#else]
        rcu_spi_clock_config(IDX_SPI1, RCU_SPISRC_PLL0Q);
    [/#if]
[/#if]
[#if Peripherals?contains("SPI2") == true || Peripherals?contains("I2S2") == true]
    [#if (SPI2SEL != "") || (SPI2SEL == "RCU_SPISRC_PER" && PERSEL != "")]
        rcu_spi_clock_config(IDX_SPI2, ${SPI2SEL});
    [#else]
        rcu_spi_clock_config(IDX_SPI2, RCU_SPISRC_PLL0Q);
    [/#if]
[/#if]
[#if Peripherals?contains("SPI3") == true]
    [#if SPI3SEL != ""]
        rcu_spi_clock_config(IDX_SPI3, ${SPI3SEL});
    [#else]
        rcu_spi_clock_config(IDX_SPI3, RCU_SPISRC_APB2);
    [/#if]
[/#if]
[#if Peripherals?contains("SPI4") == true]
    [#if SPI4SEL != ""]
        rcu_spi_clock_config(IDX_SPI4, ${SPI4SEL});
    [#else]
        rcu_spi_clock_config(IDX_SPI4, RCU_SPISRC_APB2);
    [/#if]
[/#if]
[#if Peripherals?contains("SPI5") == true || Peripherals?contains("I2S5") == true]
    [#if SPI5SEL != ""]
        rcu_spi_clock_config(IDX_SPI5, ${SPI5SEL});
    [#else]
        rcu_spi_clock_config(IDX_SPI5, RCU_SPISRC_APB2);
    [/#if]
[/#if]

[#if Peripherals?contains("USART0") == true]
    [#if USART0SEL != ""]
        rcu_usart_clock_config(IDX_USART0, ${USART0SEL});
    [#else]
        rcu_usart_clock_config(IDX_USART0, RCU_USARTSRC_APB);
    [/#if]
[/#if]
[#if Peripherals?contains("USART1") == true]
    [#if USART1SEL != ""]
        rcu_usart_clock_config(IDX_USART1, ${USART1SEL});
    [#else]
        rcu_usart_clock_config(IDX_USART1, RCU_USARTSRC_APB);
    [/#if]
[/#if]
[#if Peripherals?contains("USART2") == true]
    [#if USART2SEL != ""]
        rcu_usart_clock_config(IDX_USART2, ${USART2SEL});
    [#else]
        rcu_usart_clock_config(IDX_USART2, RCU_USARTSRC_APB);
    [/#if]
[/#if]
[#if Peripherals?contains("USART5") == true]
    [#if USART5SEL != ""]
        rcu_usart_clock_config(IDX_USART5, ${USART5SEL});
    [#else]
        rcu_usart_clock_config(IDX_USART5, RCU_USARTSRC_APB);
    [/#if]
[/#if]

[#if Peripherals?contains("HPDF") == true]
    [#if (HPDFASEL = "") || (HPDFASEL == "RCU_HPDFASRC_PER" && PERSEL = "")]
        rcu_hpdf_audio_clock_config(RCU_HPDFASRC_PLL0Q);
    [#else]
        rcu_hpdf_audio_clock_config(${HPDFASEL});
    [/#if]
[/#if]
[#if Peripherals?contains("HPDF") == true]
    rcu_hpdf_clock_config(${HPDFSEL});
[/#if]

[#if Peripherals?contains("I2C0") == true]
    rcu_i2c_clock_config(IDX_I2C0, ${I2C0SEL});
[/#if]
[#if Peripherals?contains("I2C1") == true]
    rcu_i2c_clock_config(IDX_I2C1, ${I2C1SEL});
[/#if]
[#if Peripherals?contains("I2C2") == true]
    rcu_i2c_clock_config(IDX_I2C2, ${I2C2SEL});
[/#if]
[#if Peripherals?contains("I2C3") == true]
    rcu_i2c_clock_config(IDX_I2C3, ${I2C3SEL});
[/#if]

[#if Peripherals?contains("ADC0") == true]
    [#if (ADC01SEL = "") || (ADC01SEL == "RCU_ADCSRC_PER" && PERSEL = "")]
        rcu_adc_clock_config(IDX_ADC0, RCU_ADCSRC_PLL1P);
    [#else]
        rcu_adc_clock_config(IDX_ADC0, ${ADC01SEL});
    [/#if]
[/#if]
[#if Peripherals?contains("ADC1") == true]
    [#if (ADC01SEL = "") || (ADC01SEL == "RCU_ADCSRC_PER" && PERSEL = "")]
        rcu_adc_clock_config(IDX_ADC1, RCU_ADCSRC_PLL1P);
    [#else]
        rcu_adc_clock_config(IDX_ADC1, ${ADC01SEL});
    [/#if]
[/#if]
[#if Peripherals?contains("ADC2") == true]
    [#if (ADC01SEL = "") || (ADC01SEL == "RCU_ADCSRC_PER" && PERSEL = "")]
        rcu_adc_clock_config(IDX_ADC2, RCU_ADCSRC_PLL1P);
    [#else]
        rcu_adc_clock_config(IDX_ADC2, ${ADC2SEL});
    [/#if]
[/#if]

[#if RCU_ClockOutput0 == "Enable"]
    [#if CKOUT0SEL != ""]
        rcu_ckout0_config(${CKOUT0SEL}, ${CKOUT0DIV});
    [#else]
        rcu_ckout0_config(RCU_CKOUT0SRC_IRC16M, RCU_CKOUT0_DIV1);
    [/#if]
[/#if]
[#if RCU_ClockOutput1 == "Enable"]
    [#if CKOUT1SEL != ""]
        rcu_ckout1_config(${CKOUT1SEL}, ${CKOUT1DIV});
    [#else]
        rcu_ckout1_config(RCU_CKOUT1SRC_SYSTEMCLOCK, RCU_CKOUT1_DIV1);
    [/#if]
[/#if]

[#if RCU_MonitorConfiguration_HXTALMonitor ??== true && RCU_MonitorConfiguration_HXTALMonitor == "Enable"]
    rcu_hxtal_clock_monitor_enable();
[/#if]
[#if RCU_MonitorConfiguration_LXTALMonitor ??== true && RCU_MonitorConfiguration_LXTALMonitor == "Enable"]
    rcu_lxtal_clock_monitor_enable();
[/#if]

    /* update SystemCoreClock value */
    SystemCoreClockUpdate();

[#if Peripherals?contains("SYS") == true && SYS_SystickClockSource == "Source From CKSYS/8"]
    /* setup systick timer for 1000Hz interrupts */
    if (SysTick_Config(SystemCoreClock / 8U / 1000U)){
        /* capture error */
        while (1);
    }

    systick_clksource_set(SYSTICK_CLKSOURCE_CKSYS_DIV8);
[#elseif Peripherals?contains("SYS") == true && SYS_SystickClockSource == "Disable Systick Clock Source"]
[#else]
    /* setup systick timer for 1000Hz interrupts */
    if (SysTick_Config(SystemCoreClock / 1000U)){
        /* capture error */
        while (1);
    }

    systick_clksource_set(SYSTICK_CLKSOURCE_CKSYS);
[/#if]
