[#ftl]
[#-- V1.2.0 --]
/*!
    \file    gd32h75e_libopt.h
    \brief   library optional for gd32h75e

    \version 2025-08-08, V1.3.0, firmware for GD32H75E
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef GD32H75E_LIBOPT_H
#define GD32H75E_LIBOPT_H

[#if USBHS0_USB0Mode ??== true && (Peripherals?contains("#USB0_DEVICE#") == true || Peripherals?contains("#USB0_HOST#"))]
    [#if USBHS0_USB0Mode == "USB0 Device"]
#define USE_USBHS0_DEVICE
    [#elseif USBHS0_USB0Mode == "USB0 Host"]
#define USE_USBHS0_HOST
        [#if USB0_HOST_Mode == "Human Interface Host Class (HID)"]
#define USE_USBHS0_HOST_HID
        [#elseif USB0_HOST_Mode == "Mass Storage Class (MSC)"]
#define USE_USBHS0_HOST_MSC
        [/#if]
    [/#if]
[/#if]

[#if USBHS1_USB1Mode ??== true && (Peripherals?contains("#USB1_DEVICE#") == true || Peripherals?contains("#USB1_HOST#"))]
    [#if USBHS1_USB1Mode == "USB1 Device"]
#define USE_USBHS1_DEVICE
    [#elseif USBHS1_USB1Mode == "USB1 Host"]
#define USE_USBHS1_HOST
        [#if USB1_HOST_Mode == "Human Interface Host Class (HID)"]
#define USE_USBHS1_HOST_HID
        [#elseif USB1_HOST_Mode == "Mass Storage Class (MSC)"]
#define USE_USBHS1_HOST_MSC
        [/#if]
    [/#if]
[/#if]

[#if Peripherals?contains("#USB0_HOST#") == true || Peripherals?contains("#USB0_DEVICE#") == true]
#define HS0_DEFINITION_COMPLETE
[/#if]

#include "gd32h75e_adc.h"
#include "gd32h75e_axiim.h"
#include "gd32h75e_can.h"
#include "gd32h75e_cmp.h"
#include "gd32h75e_crc.h"
#include "gd32h75e_ctc.h"
#include "gd32h75e_dac.h"
#include "gd32h75e_dbg.h"
#include "gd32h75e_dma.h"
#include "gd32h75e_edout.h"
#include "gd32h75e_efuse.h"
#include "gd32h75e_exmc.h"
#include "gd32h75e_exti.h"
#include "gd32h75e_fac.h"
#include "gd32h75e_fmc.h"
#include "gd32h75e_fwdgt.h"
#include "gd32h75e_gpio.h"
#include "gd32h75e_hpdf.h"
#include "gd32h75e_i2c.h"
#include "gd32h75e_lpdts.h"
#include "gd32h75e_mdma.h"
#include "gd32h75e_misc.h"
#include "gd32h75e_ospi.h"
#include "gd32h75e_ospim.h"
#include "gd32h75e_pmu.h"
#include "gd32h75e_rameccmu.h"
#include "gd32h75e_rcu.h"
#include "gd32h75e_rtc.h"
#include "gd32h75e_spi.h"
#include "gd32h75e_syscfg.h"
#include "gd32h75e_timer.h"
#include "gd32h75e_tmu.h"
#include "gd32h75e_trigsel.h"
#include "gd32h75e_trng.h"
#include "gd32h75e_usart.h"
#include "gd32h75e_vref.h"
#include "gd32h75e_wwdgt.h"
[#if Peripherals?contains("#USB0_DEVICE#") == true]
#include "hs0_usbd_conf.h"
[/#if]
[#if Peripherals?contains("#USB0_HOST#") == true]
#include "hs0_usbh_conf.h"
[/#if]
[#if Peripherals?contains("#USB1_DEVICE#") == true]
#include "hs1_usbd_conf.h"
[/#if]
[#if Peripherals?contains("#USB1_HOST#") == true]
#include "hs1_usbh_conf.h"
[/#if]
#endif /* GD32H75E_LIBOPT_H */
