[#ftl]
[#-- V1.9.0 --]
/*!
    \file    gd32f527_libopt.h
    \brief   library optional for gd32f527

    \version 2025-08-08, V1.3.0, firmware for GD32F527
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef GD32F527_LIBOPT_H
#define GD32F527_LIBOPT_H

[#if USBFS_WorkMode ??== true]
[#if USBFS_WorkMode == "USBFS Device" && Peripherals?contains("#USBFS_DEVICE#") == true]
#define USE_USBFS_DEVICE
[/#if]
[/#if]
[#if (USBHS_ExternalPhy ??== true || USBHS_InternalPhy ??== true) && Peripherals?contains("#USBHS_DEVICE#") == true]
[#if USBHS_ExternalPhy == "USBHS Device" || USBHS_InternalPhy == "USBHS Device"]
#define USE_USBHS_DEVICE
[/#if]
[/#if]
[#if USBFS_WorkMode ??== true]
[#if USBFS_WorkMode == "USBFS Host" && Peripherals?contains("#USBFS_HOST#") == true]
#define USE_USBFS_HOST
[#if USBFS_HOST_Mode == "Mass Storage Class (MSC)"]
#define USE_USBFS_HOST_MSC
[/#if]
[/#if]
[/#if]

[#if (USBHS_ExternalPhy ??== true || USBHS_InternalPhy ??== true) && USBHS_HOST_Mode ??== true]
[#if (USBHS_ExternalPhy == "USBHS Host" || USBHS_InternalPhy == "USBHS Host") && Peripherals?contains("#USBHS_HOST#") == true]
#define USE_USBHS_HOST
[/#if]
[#if Peripherals?contains("#USBHS_HOST#") == true && USBHS_HOST_Mode == "Mass Storage Class (MSC)"]
#define USE_USBHS_HOST_MSC
[/#if]
[/#if]
[#if USBFS_WorkMode ??== true]
[#if Peripherals?contains("#USBFS_HOST#") == true || Peripherals?contains("#USBFS_DEVICE#") == true]
#define FS_DEFINITION_COMPLETE
[/#if]
[/#if]

[#if Peripherals?contains("ENET") == true]
[#if ENET_GeneralConfiguration_DescriptorPattern == "Enhance Descriptor Pattern"]
/* define ENET enhance mode */
#define SELECT_DESCRIPTORS_ENHANCED_MODE        (1U)
[/#if]
/*!< ethernet receive buffer size */
[#if ENET_DescriptorConfiguration_RxBufferSize ??== true]
#define ENET_RXBUF_SIZE                         (${ENET_DescriptorConfiguration_RxBufferSize}U)
[#else]
#define ENET_RXBUF_SIZE                         1524U
[/#if]
/*!< ethernet transmit buffer size */
[#if ENET_DescriptorConfiguration_TxBufferSize ??== true]
#define ENET_TXBUF_SIZE                         (${ENET_DescriptorConfiguration_TxBufferSize}U)
[#else]
#define ENET_TXBUF_SIZE                         (1524U)
[/#if]
[/#if]

#include "gd32f527_adc.h"
#include "gd32f527_can.h"
#include "gd32f527_cau.h"
#include "gd32f527_crc.h"
#include "gd32f527_ctc.h"
#include "gd32f527_dac.h"
#include "gd32f527_dbg.h"
#include "gd32f527_dci.h"
#include "gd32f527_dma.h"
#include "gd32f527_enet.h"
#include "gd32f527_exmc.h"
#include "gd32f527_exti.h"
#include "gd32f527_fmc.h"
#include "gd32f527_fwdgt.h"
#include "gd32f527_gpio.h"
#include "gd32f527_hau.h"
#include "gd32f527_i2c.h"
#include "gd32f527_i2c_add.h"
#include "gd32f527_ipa.h"
#include "gd32f527_iref.h"
#include "gd32f527_misc.h"
#include "gd32f527_pkcau.h"
#include "gd32f527_pmu.h"
#include "gd32f527_rcu.h"
#include "gd32f527_rtc.h"
#include "gd32f527_sai.h"
#include "gd32f527_sdio.h"
#include "gd32f527_spi.h"
#include "gd32f527_syscfg.h"
#include "gd32f527_timer.h"
#include "gd32f527_tli.h"
#include "gd32f527_trng.h"
#include "gd32f527_usart.h"
#include "gd32f527_wwdgt.h"
[#if USBFS_WorkMode ??== true]
[#if USBFS_WorkMode == "USBFS Device" && Peripherals?contains("#USBFS_DEVICE#") == true]
#include "fs_usbd_conf.h"
[/#if]
[/#if]
[#if USBFS_WorkMode ??== true && USBFS_HOST_Mode ??== true]
[#if (USBFS_WorkMode == "USBFS Host" && USBFS_HOST_Mode == "Human Interface Host Class (HID)") || (USBFS_WorkMode == "USBFS Host" && USBFS_HOST_Mode == "Mass Storage Class (MSC)")]
#include "fs_usbh_conf.h"
[/#if]
[/#if]
[#if (USBHS_ExternalPhy ??== true || USBHS_InternalPhy ??== true) && (Peripherals?contains("#USBHS_DEVICE#") == true || Peripherals?contains("#USBHS_HOST#") == true)]
[#if (USBHS_ExternalPhy == "USBHS Device" || USBHS_InternalPhy == "USBHS Device") && Peripherals?contains("#USBHS_DEVICE#") == true]
#include "hs_usbd_conf.h"
[/#if]
[#if (USBHS_ExternalPhy == "USBHS Host" || USBHS_InternalPhy == "USBHS Host") && Peripherals?contains("#USBHS_HOST#") == true]
#include "hs_usbh_conf.h"
[/#if]
[/#if]
[#if Peripherals?contains("#SDIO#") == true]
#include "sdcard.h"
[/#if]

#endif /* GD32F527_LIBOPT_H */
