[#ftl]
[#-- V1.0.8 --]
/*
    \file  gd32f527_it.h
*/
/*
    Copyright (c) ${CurrentData}, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef GD32F527_IT_H
#define GD32F527_IT_H

#include "gd32f527.h"

#ifdef __cplusplus
extern "C" {
#endif

/* External Includes */
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Type Definitions] begin */

/* user code [Type Definitions] end */

/* Shared Macros */
/* user code [Shared Macros] begin */

/* user code [Shared Macros] end */

/* External Constants  */
/* user code [External Constants] begin */

/* user code [External Constants] end */

/* External Variables */
/* user code [External Variables] begin */

/* user code [External Variables] end */

void nvic_exception_irq_enable(IRQn_Type nvic_irq, uint8_t nvic_irq_pre_priority, uint8_t nvic_irq_sub_priority);
void nvic_exception_irq_disable(IRQn_Type nvic_irq);

[#if NVIC_NonMaskableInterrupt ??== true && NVIC_NonMaskableInterrupt_Enabled == "TRUE"]
void NMI_Handler(void);

[/#if]
[#if NVIC_SYSCFGSRAMECCErrorInterrupt ??== true && NVIC_SYSCFGSRAMECCErrorInterrupt_Enabled == "TRUE"]
void SYSCFG_SINGLE_BIT_ECC_ER_IRQHandler(void);

[/#if]
[#if NVIC_HardfaultInterrupt ??== true && NVIC_HardfaultInterrupt_Enabled == "TRUE"]
void HardFault_Handler(void);

[/#if]
[#if NVIC_MemoryManagementInterrupt ??== true && NVIC_MemoryManagementInterrupt_Enabled == "TRUE"]
void MemManage_Handler(void);

[/#if]
[#if NVIC_PrefetchFaultMemoryAccessFault ??== true && NVIC_PrefetchFaultMemoryAccessFault_Enabled == "TRUE"]
void BusFault_Handler(void);

[/#if]
[#if NVIC_UndefinedInstructionOrIllegalState ??== true && NVIC_UndefinedInstructionOrIllegalState_Enabled == "TRUE"]
void UsageFault_Handler(void);

[/#if]
[#if NVIC_SystemServiceCallViaSWIInstruction ??== true && NVIC_SystemServiceCallViaSWIInstruction_Enabled == "TRUE"]
[#if Peripherals?contains("#FREERTOS#") != true]
void SVC_Handler(void);

[/#if]
[/#if]
[#if NVIC_PendableRequestForSystemService ??== true && NVIC_PendableRequestForSystemService_Enabled == "TRUE"]
[#if Peripherals?contains("#FREERTOS#") != true]
void PendSV_Handler(void);

[/#if]
[/#if]
[#if NVIC_DebugMonitorInterrupt ??== true && NVIC_DebugMonitorInterrupt_Enabled == "TRUE"]
void DebugMon_Handler(void);

[/#if]
[#if NVIC_SystemTickTimer ??== true && NVIC_SystemTickTimer_Enabled == "TRUE"]
[#if Peripherals?contains("#FREERTOS#") != true]
void SysTick_Handler(void);

[/#if]
[/#if]
[#if NVIC_WWDGTInterrupt ??== true && NVIC_WWDGTInterrupt_Enabled == "TRUE"]
void WWDGT_IRQHandler(void);

[/#if]
[#if NVIC_LVDFromEXTIInterrupt ??== true && NVIC_LVDFromEXTIInterrupt_Enabled == "TRUE"]
void LVD_IRQHandler(void);

[/#if]
[#if NVIC_RTCTamperAndTimestampFromEXTIInterrupt ??== true && NVIC_RTCTamperAndTimestampFromEXTIInterrupt_Enabled == "TRUE"]
void TAMPER_STAMP_IRQHandler(void);

[/#if]
[#if NVIC_RTCWakeupFromEXTIInterrupt ??== true && NVIC_RTCWakeupFromEXTIInterrupt_Enabled == "TRUE"]
void RTC_WKUP_IRQHandler(void);

[/#if]
[#if NVIC_FMCGlobalInterrupt ??== true && NVIC_FMCGlobalInterrupt_Enabled == "TRUE"]
void FMC_IRQHandler(void);

[/#if]
[#if NVIC_RCUAndCTCInterrupt ??== true && NVIC_RCUAndCTCInterrupt_Enabled == "TRUE"]
void RCU_CTC_IRQHandler(void);

[/#if]
[#if NVIC_EXTILine0Interrupt ??== true && NVIC_EXTILine0Interrupt_Enabled == "TRUE"]
void EXTI0_IRQHandler(void);

[/#if]
[#if NVIC_EXTILine1Interrupt ??== true && NVIC_EXTILine1Interrupt_Enabled == "TRUE"]
void EXTI1_IRQHandler(void);

[/#if]
[#if NVIC_EXTILine2Interrupt ??== true && NVIC_EXTILine2Interrupt_Enabled == "TRUE"]
void EXTI2_IRQHandler(void);

[/#if]
[#if NVIC_EXTILine3Interrupt ??== true && NVIC_EXTILine3Interrupt_Enabled == "TRUE"]
void EXTI3_IRQHandler(void);

[/#if]
[#if NVIC_EXTILine4Interrupt ??== true && NVIC_EXTILine4Interrupt_Enabled == "TRUE"]
void EXTI4_IRQHandler(void);

[/#if]
[#if NVIC_DMA0Channel0GlobalInterrupt ??== true && NVIC_DMA0Channel0GlobalInterrupt_Enabled == "TRUE"]
void DMA0_Channel0_IRQHandler(void);

[/#if]
[#if NVIC_DMA0Channel1GlobalInterrupt ??== true && NVIC_DMA0Channel1GlobalInterrupt_Enabled == "TRUE"]
void DMA0_Channel1_IRQHandler(void);

[/#if]
[#if NVIC_DMA0Channel2GlobalInterrupt ??== true && NVIC_DMA0Channel2GlobalInterrupt_Enabled == "TRUE"]
void DMA0_Channel2_IRQHandler(void);

[/#if]
[#if NVIC_DMA0Channel3GlobalInterrupt ??== true && NVIC_DMA0Channel3GlobalInterrupt_Enabled == "TRUE"]
void DMA0_Channel3_IRQHandler(void);

[/#if]
[#if NVIC_DMA0Channel4GlobalInterrupt ??== true && NVIC_DMA0Channel4GlobalInterrupt_Enabled == "TRUE"]
void DMA0_Channel4_IRQHandler(void);

[/#if]
[#if NVIC_DMA0Channel5GlobalInterrupt ??== true && NVIC_DMA0Channel5GlobalInterrupt_Enabled == "TRUE"]
void DMA0_Channel5_IRQHandler(void);

[/#if]
[#if NVIC_DMA0Channel6GlobalInterrupt ??== true && NVIC_DMA0Channel6GlobalInterrupt_Enabled == "TRUE"]
void DMA0_Channel6_IRQHandler(void);

[/#if]
[#if NVIC_ADCGlobalInterrupt ??== true && NVIC_ADCGlobalInterrupt_Enabled == "TRUE"]
void ADC_IRQHandler(void);

[/#if]
[#if NVIC_CAN0TxInterrupt ??== true && NVIC_CAN0TxInterrupt_Enabled == "TRUE"]
void CAN0_TX_IRQHandler (void);

[/#if]
[#if NVIC_CAN0Rx0Interrupt ??== true && NVIC_CAN0Rx0Interrupt_Enabled == "TRUE"]
void CAN0_RX0_IRQHandler (void);

[/#if]
[#if NVIC_CAN0Rx1Interrupt ??== true && NVIC_CAN0Rx1Interrupt_Enabled == "TRUE"]
void CAN0_RX1_IRQHandler (void);

[/#if]
[#if NVIC_CAN0EWMCInterrupt ??== true && NVIC_CAN0EWMCInterrupt_Enabled == "TRUE"]
void CAN0_EWMC_IRQHandler (void);

[/#if]
[#if NVIC_EXTILine59Interrupt ??== true && NVIC_EXTILine59Interrupt_Enabled == "TRUE"]
void EXTI5_9_IRQHandler(void);

[/#if]
[#if NVIC_TIMER0BreakAndTIMER8GlobalInterrupt ??== true && NVIC_TIMER0BreakAndTIMER8GlobalInterrupt_Enabled == "TRUE"]
void TIMER0_BRK_TIMER8_IRQHandler(void);

[/#if]
[#if NVIC_TIMER0UpdateAndTIMER9GlobalInterrupt ??== true && NVIC_TIMER0UpdateAndTIMER9GlobalInterrupt_Enabled == "TRUE"]
void TIMER0_UP_TIMER9_IRQHandler(void);

[/#if]
[#if NVIC_TIMER0TriggerChannelCommutationAndTIMER10GlobalInterrupt ??== true && NVIC_TIMER0TriggerChannelCommutationAndTIMER10GlobalInterrupt_Enabled == "TRUE"]
void TIMER0_TRG_CMT_TIMER10_IRQHandler(void);

[/#if]
[#if NVIC_TIMER0CaptureCompareInterrupt ??== true && NVIC_TIMER0CaptureCompareInterrupt_Enabled == "TRUE"]
void TIMER0_Channel_IRQHandler(void);

[/#if]
[#if NVIC_TIMER1GlobalInterrupt ??== true && NVIC_TIMER1GlobalInterrupt_Enabled == "TRUE"]
void TIMER1_IRQHandler(void);

[/#if]
[#if NVIC_TIMER2GlobalInterrupt ??== true && NVIC_TIMER2GlobalInterrupt_Enabled == "TRUE"]
void TIMER2_IRQHandler(void);

[/#if]
[#if NVIC_TIMER3GlobalInterrupt ??== true && NVIC_TIMER3GlobalInterrupt_Enabled == "TRUE"]
void TIMER3_IRQHandler(void);

[/#if]
[#if NVIC_I2C0EventInterrupt ??== true && NVIC_I2C0EventInterrupt_Enabled == "TRUE"]
void I2C0_EV_IRQHandler(void);

[/#if]
[#if NVIC_I2C0ErrorInterrupt ??== true && NVIC_I2C0ErrorInterrupt_Enabled == "TRUE"]
void I2C0_ER_IRQHandler(void);

[/#if]
[#if NVIC_I2C1EventInterrupt ??== true && NVIC_I2C1EventInterrupt_Enabled == "TRUE"]
void I2C1_EV_IRQHandler(void);

[/#if]
[#if NVIC_I2C1ErrorInterrupt ??== true && NVIC_I2C1ErrorInterrupt_Enabled == "TRUE"]
void I2C1_ER_IRQHandler(void);

[/#if]
[#if NVIC_SPI0GlobalInterrupt ??== true && NVIC_SPI0GlobalInterrupt_Enabled == "TRUE"]
void SPI0_IRQHandler(void);

[/#if]
[#if NVIC_SPI1GlobalInterrupt ??== true && NVIC_SPI1GlobalInterrupt_Enabled == "TRUE"]
void SPI1_IRQHandler(void);

[/#if]
[#if NVIC_USART0GlobalInterrupt ??== true && NVIC_USART0GlobalInterrupt_Enabled == "TRUE"]
void USART0_IRQHandler(void);

[/#if]
[#if NVIC_USART1GlobalInterrupt ??== true && NVIC_USART1GlobalInterrupt_Enabled == "TRUE"]
void USART1_IRQHandler(void);

[/#if]
[#if NVIC_USART2GlobalInterrupt ??== true && NVIC_USART2GlobalInterrupt_Enabled == "TRUE"]
void USART2_IRQHandler(void);

[/#if]
[#if NVIC_EXTILine1015Interrupt ??== true && NVIC_EXTILine1015Interrupt_Enabled == "TRUE"]
void EXTI10_15_IRQHandler(void);

[/#if]
[#if NVIC_RTCAlarmFromEXTIInterrupt ??== true && NVIC_RTCAlarmFromEXTIInterrupt_Enabled == "TRUE"]
void RTC_Alarm_IRQHandler(void);

[/#if]
[#if NVIC_USBFSWakeupFromEXTIInterrupt ??== true && NVIC_USBFSWakeupFromEXTIInterrupt_Enabled == "TRUE"]
void USBFS_WKUP_IRQHandler(void);

[/#if]
[#if NVIC_TIMER7BreakAndTIMER11GlobalInterrupt  ??== true && NVIC_TIMER7BreakAndTIMER11GlobalInterrupt_Enabled == "TRUE"]
void TIMER7_BRK_TIMER11_IRQHandler(void);

[/#if]
[#if NVIC_TIMER7UpdateAndTIMER12GlobalInterrupt ??== true && NVIC_TIMER7UpdateAndTIMER12GlobalInterrupt_Enabled == "TRUE"]
void TIMER7_UP_TIMER12_IRQHandler(void);

[/#if]
[#if NVIC_TIMER7TriggerChannelCommutationAndTIMER13GlobalInterrupt ??== true && NVIC_TIMER7TriggerChannelCommutationAndTIMER13GlobalInterrupt_Enabled == "TRUE"]
void TIMER7_TRG_CMT_TIMER13_IRQHandler(void);

[/#if]
[#if NVIC_TIMER7CaptureCompareInterrupt ??== true && NVIC_TIMER7CaptureCompareInterrupt_Enabled == "TRUE"]
void TIMER7_Channel_IRQHandler(void);

[/#if]
[#if NVIC_DMA0Channel7GlobalInterrupt ??== true && NVIC_DMA0Channel7GlobalInterrupt_Enabled == "TRUE"]
void DMA0_Channel7_IRQHandler(void);

[/#if]
[#if NVIC_EXMCGlobalInterrupt ??== true && NVIC_EXMCGlobalInterrupt_Enabled == "TRUE"]
void EXMC_IRQHandler(void);

[/#if]
[#if NVIC_SDIOGlobalInterrupt ??== true && NVIC_SDIOGlobalInterrupt_Enabled == "TRUE"]
void SDIO_IRQHandler (void);

[/#if]
[#if NVIC_TIMER4GlobalInterrupt ??== true && NVIC_TIMER4GlobalInterrupt_Enabled == "TRUE"]
void TIMER4_IRQHandler(void);

[/#if]
[#if NVIC_SPI2GlobalInterrupt ??== true && NVIC_SPI2GlobalInterrupt_Enabled == "TRUE"]
void SPI2_IRQHandler(void);

[/#if]
[#if NVIC_UART3GlobalInterrupt ??== true && NVIC_UART3GlobalInterrupt_Enabled == "TRUE"]
void UART3_IRQHandler(void);

[/#if]
[#if NVIC_UART4GlobalInterrupt ??== true && NVIC_UART4GlobalInterrupt_Enabled == "TRUE"]
void UART4_IRQHandler(void);

[/#if]
[#if NVIC_TIMER5GlobalInterruptAndDAC0_OUT0DAC0_OUT1UnderrunErrorInterrupt ??== true && NVIC_TIMER5GlobalInterruptAndDAC0_OUT0DAC0_OUT1UnderrunErrorInterrupt_Enabled == "TRUE"]
void TIMER5_DAC_IRQHandler(void);

[/#if]
[#if NVIC_TIMER6GlobalInterrupt ??== true && NVIC_TIMER6GlobalInterrupt_Enabled == "TRUE"]
void TIMER6_IRQHandler(void);

[/#if]
[#if NVIC_DMA1Channel0GlobalInterrupt ??== true && NVIC_DMA1Channel0GlobalInterrupt_Enabled == "TRUE"]
void DMA1_Channel0_IRQHandler(void);

[/#if]
[#if NVIC_DMA1Channel1GlobalInterrupt ??== true && NVIC_DMA1Channel1GlobalInterrupt_Enabled == "TRUE"]
void DMA1_Channel1_IRQHandler(void);

[/#if]
[#if NVIC_DMA1Channel2GlobalInterrupt ??== true && NVIC_DMA1Channel2GlobalInterrupt_Enabled == "TRUE"]
void DMA1_Channel2_IRQHandler(void);

[/#if]
[#if NVIC_DMA1Channel3GlobalInterrupt ??== true && NVIC_DMA1Channel3GlobalInterrupt_Enabled == "TRUE"]
void DMA1_Channel3_IRQHandler(void);

[/#if]
[#if NVIC_DMA1Channel4GlobalInterrupt ??== true && NVIC_DMA1Channel4GlobalInterrupt_Enabled == "TRUE"]
void DMA1_Channel4_IRQHandler(void);

[/#if]
[#if NVIC_EthernetGlobalInterrupt ??== true && NVIC_EthernetGlobalInterrupt_Enabled == "TRUE"]
void ENET_IRQHandler(void);

[/#if]
[#if NVIC_EthernetWakeupFromEXTIInterrupt ??== true && NVIC_EthernetWakeupFromEXTIInterrupt_Enabled == "TRUE"]
void ENET_WKUP_IRQHandler (void);

[/#if]
[#if NVIC_CAN1TxInterrupt ??== true && NVIC_CAN1TxInterrupt_Enabled == "TRUE"]
void CAN1_TX_IRQHandler (void);

[/#if]
[#if NVIC_CAN1Rx0Interrupt ??== true && NVIC_CAN1Rx0Interrupt_Enabled == "TRUE"]
void CAN1_RX0_IRQHandler (void);

[/#if]
[#if NVIC_CAN1Rx1Interrupt ??== true && NVIC_CAN1Rx1Interrupt_Enabled == "TRUE"]
void CAN1_RX1_IRQHandler (void);

[/#if]
[#if NVIC_CAN1EWMCInterrupt ??== true && NVIC_CAN1EWMCInterrupt_Enabled == "TRUE"]
void CAN1_EWMC_IRQHandler (void);

[/#if]
[#if NVIC_USBFSGlobalInterrupt ??== true && NVIC_USBFSGlobalInterrupt_Enabled == "TRUE"]
void USBFS_IRQHandler(void);

[/#if]
[#if NVIC_DMA1Channel5GlobalInterrupt ??== true && NVIC_DMA1Channel5GlobalInterrupt_Enabled == "TRUE"]
void DMA1_Channel5_IRQHandler(void);

[/#if]
[#if NVIC_DMA1Channel6GlobalInterrupt ??== true && NVIC_DMA1Channel6GlobalInterrupt_Enabled == "TRUE"]
void DMA1_Channel6_IRQHandler(void);

[/#if]
[#if NVIC_DMA1Channel7GlobalInterrupt ??== true && NVIC_DMA1Channel7GlobalInterrupt_Enabled == "TRUE"]
void DMA1_Channel7_IRQHandler(void);

[/#if]
[#if NVIC_USART5GlobalInterrupt ??== true && NVIC_USART5GlobalInterrupt_Enabled == "TRUE"]
void USART5_IRQHandler(void);

[/#if]
[#if NVIC_I2C2EventInterrupt ??== true && NVIC_I2C2EventInterrupt_Enabled == "TRUE"]
void I2C2_EV_IRQHandler (void);

[/#if]
[#if NVIC_I2C2ErrorInterrupt ??== true && NVIC_I2C2ErrorInterrupt_Enabled == "TRUE"]
void I2C2_ER_IRQHandler(void);

[/#if]
[#if NVIC_USBHSEndpoint1OutInterrupt ??== true && NVIC_USBHSEndpoint1OutInterrupt_Enabled == "TRUE"]
void USBHS_EP1_Out_IRQHandler(void);

[/#if]
[#if NVIC_USBHSEndpoint1InInterrupt ??== true && NVIC_USBHSEndpoint1InInterrupt_Enabled == "TRUE"]
void USBHS_EP1_In_IRQHandler(void);

[/#if]
[#if NVIC_USBHSWakeupFromEXTIInterrupt ??== true && NVIC_USBHSWakeupFromEXTIInterrupt_Enabled == "TRUE"]
void USBHS_WKUP_IRQHandler(void);

[/#if]
[#if NVIC_USBHSGlobalInterrupt ??== true && NVIC_USBHSGlobalInterrupt_Enabled == "TRUE"]
void USBHS_IRQHandler(void);

[/#if]
[#if NVIC_DCIGlobalInterrupt ??== true && NVIC_DCIGlobalInterrupt_Enabled == "TRUE"]
void DCI_IRQHandler(void);

[/#if]
[#if NVIC_TRNGGlobalInterrupt ??== true && NVIC_TRNGGlobalInterrupt_Enabled == "TRUE"]
void TRNG_IRQHandler(void);

[/#if]
[#if NVIC_FPUGlobalInterrupt ??== true && NVIC_FPUGlobalInterrupt_Enabled == "TRUE"]
void FPU_IRQHandler(void);

[/#if]
[#if NVIC_UART6GlobalInterrupt ??== true && NVIC_UART6GlobalInterrupt_Enabled == "TRUE"]
void UART6_IRQHandler(void);

[/#if]
[#if NVIC_UART7GlobalInterrupt ??== true && NVIC_UART7GlobalInterrupt_Enabled == "TRUE"]
void UART7_IRQHandler(void);

[/#if]
[#if NVIC_SPI3GlobalInterrupt ??== true && NVIC_SPI3GlobalInterrupt_Enabled == "TRUE"]
void SPI3_IRQHandler(void);

[/#if]
[#if NVIC_SPI4GlobalInterrupt ??== true && NVIC_SPI4GlobalInterrupt_Enabled == "TRUE"]
void SPI4_IRQHandler(void);

[/#if]
[#if NVIC_SPI5GlobalInterrupt ??== true && NVIC_SPI5GlobalInterrupt_Enabled == "TRUE"]
void SPI5_IRQHandler(void);

[/#if]
[#if NVIC_SAIGlobalInterrupt ??== true && NVIC_SAIGlobalInterrupt_Enabled == "TRUE"]
void SAI_IRQHandler (void);

[/#if]
[#if NVIC_TLIGlobalInterrupt ??== true && NVIC_TLIGlobalInterrupt_Enabled == "TRUE"]
void TLI_IRQHandler(void);

[/#if]
[#if NVIC_TLIGlobalErrorInterrupt ??== true && NVIC_TLIGlobalErrorInterrupt_Enabled == "TRUE"]
void TLI_ER_IRQHandler(void);

[/#if]
[#if NVIC_IPAGlobalInterrupt ??== true && NVIC_IPAGlobalInterrupt_Enabled == "TRUE"]
void IPA_IRQHandler(void);

[/#if]
[#if NVIC_PKCAUGlobalInterrupt ??== true && NVIC_PKCAUGlobalInterrupt_Enabled == "TRUE"]
void PKCAU_IRQHandler(void);

[/#if]
[#if NVIC_I2C3EventInterrupt ??== true && NVIC_I2C3EventInterrupt_Enabled == "TRUE"]
void I2C3_EV_IRQHandler(void);

[/#if]
[#if NVIC_I2C3ErrorInterrupt ??== true && NVIC_I2C3ErrorInterrupt_Enabled == "TRUE"]
void I2C3_ER_IRQHandler(void);

[/#if]
[#if NVIC_I2C4EventInterrupt ??== true && NVIC_I2C4EventInterrupt_Enabled == "TRUE"]
void I2C4_EV_IRQHandler(void);

[/#if]
[#if NVIC_I2C4ErrorInterrupt ??== true && NVIC_I2C4ErrorInterrupt_Enabled == "TRUE"]
void I2C4_ER_IRQHandler(void);

[/#if]
[#if NVIC_I2C5EventInterrupt ??== true && NVIC_I2C5EventInterrupt_Enabled == "TRUE"]
void I2C5_EV_IRQHandler(void);

[/#if]
[#if NVIC_I2C5ErrorInterrupt ??== true && NVIC_I2C5ErrorInterrupt_Enabled == "TRUE"]
void I2C5_ER_IRQHandler(void);

[/#if]
[#if NVIC_I2C3WakeupFromEXTIInterrupt ??== true && NVIC_I2C3WakeupFromEXTIInterrupt_Enabled == "TRUE"]
void I2C3_WKUP_IRQHandler(void);

[/#if]
[#if NVIC_I2C4WakeupFromEXTIInterrupt ??== true && NVIC_I2C4WakeupFromEXTIInterrupt_Enabled == "TRUE"]
void I2C4_WKUP_IRQHandler(void);

[/#if]
[#if NVIC_I2C5WakeupFromEXTIInterrupt ??== true && NVIC_I2C5WakeupFromEXTIInterrupt_Enabled == "TRUE"]
void I2C5_WKUP_IRQHandler(void);

[/#if]
[#if NVIC_HAUGlobalInterrupt ??== true && NVIC_HAUGlobalInterrupt_Enabled == "TRUE"]
void HAU_IRQHandler(void);

[/#if]
[#if NVIC_CAUGlobalInterrupt ??== true && NVIC_CAUGlobalInterrupt_Enabled == "TRUE"]
void CAU_IRQHandler(void);

[/#if]
/* user code [Public Functions] begin */

/* user code [Public Functions] end */

#ifdef __cplusplus
}
#endif

#endif /*GD32F527_IT_H*/
