[#ftl]
[#-- V1.0.7 --]
/*
    \file  gd32c2x1_it.c
*/
/*
    Copyright (c) ${CurrentData}, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32c2x1_it.h"
#include "gd32c2x1.h"
#include "gd32c2x1_init.h"

/* External Includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
#define SRAM_ECC_ERROR_HANDLE(s) \
    do {                          \
    } while(1)
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */
[#if NVIC_NonMaskableInterrupt ??== true && NVIC_NonMaskableInterrupt_Enabled == "TRUE"]
/*!
    \brief      Non Maskable Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void NMI_Handler(void)
{
    /* user code [NMI_IRQn local 0] begin */

    /* user code [NMI_IRQn local 0] end */
    if(SET == syscfg_interrupt_flag_get(SYSCFG_FLAG_ECCME)) {
        SRAM_ECC_ERROR_HANDLE("SRAM two bits non-correction check error\r\n");
    } else if(SET == syscfg_interrupt_flag_get(SYSCFG_FLAG_ECCSE)) {
        SRAM_ECC_ERROR_HANDLE("RAM single bit correction check error\r\n");
    } else {
        /* if NMI exception occurs, go to infinite loop */
        /* HXTAL clock monitor NMI error or NMI pin error */
        while(1) {
            /* user code [NMI_IRQn local 1] begin */

            /* user code [NMI_IRQn local 1] end */
        }
    }

    /* user code [NMI_IRQn local 2] begin */

    /* user code [NMI_IRQn local 2] end */
}

[/#if]
[#if NVIC_HardfaultInterrupt ??== true && NVIC_HardfaultInterrupt_Enabled == "TRUE"]
/*!
    \brief      HardFault Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HardFault_Handler(void)
{
    /* user code [HardFault_IRQn local 0] begin */

    /* user code [HardFault_IRQn local 0] end */
	while(1) {
        /* user code [HardFault_IRQn local 1] begin */

        /* user code [HardFault_IRQn local 1] end */
	}
}

[/#if]
[#if NVIC_SystemServiceCallViaSWIInstruction ??== true && NVIC_SystemServiceCallViaSWIInstruction_Enabled == "TRUE"]
/*!
    \brief      System Service Call Via SWI Instruction Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SVC_Handler(void)
{
    /* user code [SVC_IRQn local 0] begin */

    /* user code [SVC_IRQn local 0] end */
    while(1) {
    	/* user code [SVC_IRQn local 1] begin */

    	/* user code [SVC_IRQn local 1] end */
    }
}

[/#if]
[#if NVIC_PendableRequestForSystemService ??== true && NVIC_PendableRequestForSystemService_Enabled == "TRUE"]
/*!
    \brief      PendSV Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void PendSV_Handler(void)
{
    /* user code [PendSV_IRQn local 0] begin */

    /* user code [PendSV_IRQn local 0] end */
    while(1) {
    	/* user code [PendSV_IRQn local 1] begin */

    	/* user code [PendSV_IRQn local 1] end */
    }
}

[/#if]
[#if NVIC_SystemTickTimer ??== true && NVIC_SystemTickTimer_Enabled == "TRUE"]
/*!
    \brief      SysTick Timer Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SysTick_Handler(void)
{
    /* user code [SysTick_IRQn local 0] begin */

    /* user code [SysTick_IRQn local 0] end */

    /* user code [SysTick_IRQn local 1] begin */

    /* user code [SysTick_IRQn local 1] end */
}

[/#if]
[#if NVIC_WindowWatchdogInterrupt ??== true && NVIC_WindowWatchdogInterrupt_Enabled == "TRUE"]
/*!
    \brief      WWDGT Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void WWDGT_IRQHandler(void)
{
    /* user code [WWDGT_IRQn local 0] begin */

    /* user code [WWDGT_IRQn local 0] end */

    /* user code [WWDGT_IRQn local 1] begin */

    /* user code [WWDGT_IRQn local 1] end */
}

[/#if]
[#if NVIC_RTCTimeStampFromEXTIInterrupts ??== true && NVIC_RTCTimeStampFromEXTIInterrupts_Enabled == "TRUE"]
/*!
    \brief      RTC Time Stamp From EXTI Interrupts Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMESTAMP_IRQHandler(void)
{
    /* user code [TIMESTAMP_IRQn local 0] begin */

    /* user code [TIMESTAMP_IRQn local 0] end */

    /* user code [TIMESTAMP_IRQn local 1] begin */

    /* user code [TIMESTAMP_IRQn local 1] end */
}

[/#if]
[#if NVIC_FMCGlobalInterrupt ??== true && NVIC_FMCGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      FMC Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void FMC_IRQHandler(void)
{
    /* user code [FMC_IRQn local 0] begin */

    /* user code [FMC_IRQn local 0] end */

    /* user code [FMC_IRQn local 1] begin */

    /* user code [FMC_IRQn local 1] end */
}

[/#if]
[#if NVIC_RCUGlobalInterrupt ??== true && NVIC_RCUGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      RCU Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void RCU_IRQHandler(void)
{
    /* user code [RCU_IRQn local 0] begin */

    /* user code [RCU_IRQn local 0] end */

    /* user code [RCU_IRQn local 1] begin */

    /* user code [RCU_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine0Interrupt ??== true && NVIC_EXTILine0Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI0_IRQHandler(void)
{
    /* user code [EXTI0_IRQn local 0] begin */

    /* user code [EXTI0_IRQn local 0] end */

    /* user code [EXTI0_IRQn local 1] begin */

    /* user code [EXTI0_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine1Interrupt ??== true && NVIC_EXTILine1Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI1 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI1_IRQHandler(void)
{
    /* user code [EXTI1_IRQn local 0] begin */

    /* user code [EXTI1_IRQn local 0] end */

    /* user code [EXTI1_IRQn local 1] begin */

    /* user code [EXTI1_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine2Interrupt ??== true && NVIC_EXTILine2Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI2 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI2_IRQHandler(void)
{
    /* user code [EXTI2_IRQn local 0] begin */

    /* user code [EXTI2_IRQn local 0] end */

    /* user code [EXTI2_IRQn local 1] begin */

    /* user code [EXTI2_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine3Interrupt ??== true && NVIC_EXTILine3Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI3 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI3_IRQHandler(void)
{
    /* user code [EXTI3_IRQn local 0] begin */

    /* user code [EXTI3_IRQn local 0] end */

    /* user code [EXTI3_IRQn local 1] begin */

    /* user code [EXTI3_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine4Interrupt ??== true && NVIC_EXTILine4Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI4 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI4_IRQHandler(void)
{
    /* user code [EXTI4_IRQn local 0] begin */

    /* user code [EXTI4_IRQn local 0] end */

    /* user code [EXTI4_IRQn local 1] begin */

    /* user code [EXTI4_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMAChannel0GlobalInterrupt ??== true && NVIC_DMAChannel0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA Channel0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA_Channel0_IRQHandler(void)
{
    /* user code [DMA_Channel0_IRQn local 0] begin */

    /* user code [DMA_Channel0_IRQn local 0] end */

    /* user code [DMA_Channel0_IRQn local 1] begin */

    /* user code [DMA_Channel0_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMAChannel1GlobalInterrupt ??== true && NVIC_DMAChannel1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA Channel1 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA_Channel1_IRQHandler(void)
{
    /* user code [DMA_Channel1_IRQn local 0] begin */

    /* user code [DMA_Channel1_IRQn local 0] end */

    /* user code [DMA_Channel1_IRQn local 1] begin */

    /* user code [DMA_Channel1_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMAChannel2GlobalInterrupt ??== true && NVIC_DMAChannel2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA Channel2 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA_Channel2_IRQHandler(void)
{
    /* user code [DMA_Channel2_IRQn local 0] begin */

    /* user code [DMA_Channel2_IRQn local 0] end */

    /* user code [DMA_Channel2_IRQn local 1] begin */

    /* user code [DMA_Channel2_IRQn local 1] end */
}

[/#if]
[#if NVIC_ADCInterrupt ??== true && NVIC_ADCInterrupt_Enabled == "TRUE"]
/*!
    \brief      ADC Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void ADC_IRQHandler(void)
{
    /* user code [ADC_IRQn local 0] begin */

    /* user code [ADC_IRQn local 0] end */

    /* user code [ADC_IRQn local 1] begin */

    /* user code [ADC_IRQn local 1] end */
}

[/#if]
[#if NVIC_USART0GlobalInterrupt ??== true && NVIC_USART0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      USART0 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USART0_IRQHandler(void)
{
    /* user code [USART0_IRQn local 0] begin */

    /* user code [USART0_IRQn local 0] end */

    /* user code [USART0_IRQn local 1] begin */

    /* user code [USART0_IRQn local 1] end */
}

[/#if]
[#if NVIC_USART1GlobalInterrupt ??== true && NVIC_USART1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      USART1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USART1_IRQHandler(void)
{
    /* user code [USART1_IRQn local 0] begin */

    /* user code [USART1_IRQn local 0] end */

    /* user code [USART1_IRQn local 1] begin */

    /* user code [USART1_IRQn local 1] end */
}

[/#if]
[#if NVIC_USART2GlobalInterrupt ??== true && NVIC_USART2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      USART2 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USART2_IRQHandler(void)
{
    /* user code [USART2_IRQn local 0] begin */

    /* user code [USART2_IRQn local 0] end */

    /* user code [USART2_IRQn local 1] begin */

    /* user code [USART2_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C0EventInterrupt ??== true && NVIC_I2C0EventInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C0 Event Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C0_EV_IRQHandler(void)
{
    /* user code [I2C0_EV_IRQn local 0] begin */

    /* user code [I2C0_EV_IRQn local 0] end */

    /* user code [I2C0_EV_IRQn local 1] begin */

    /* user code [I2C0_EV_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C0ErrorInterrupt ??== true && NVIC_I2C0ErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C0 Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C0_ER_IRQHandler(void)
{
    /* user code [I2C0_ER_IRQn local 0] begin */

    /* user code [I2C0_ER_IRQn local 0] end */

    /* user code [I2C0_ER_IRQn local 1] begin */

    /* user code [I2C0_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C1EventInterrupt ??== true && NVIC_I2C1EventInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C1 Event Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C1_EV_IRQHandler(void)
{
    /* user code [I2C1_EV_IRQn local 0] begin */

    /* user code [I2C1_EV_IRQn local 0] end */

    /* user code [I2C1_EV_IRQn local 1] begin */

    /* user code [I2C1_EV_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C1ErrorInterrupt ??== true && NVIC_I2C1ErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C1 Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C1_ER_IRQHandler(void)
{
    /* user code [I2C1_ER_IRQn local 0] begin */

    /* user code [I2C1_ER_IRQn local 0] end */

    /* user code [I2C1_ER_IRQn local 1] begin */

    /* user code [I2C1_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_SPI0GlobalInterrupt ??== true && NVIC_SPI0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SPI0 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI0_IRQHandler(void)
{
    /* user code [SPI0_IRQn local 0] begin */

    /* user code [SPI0_IRQn local 0] end */

    /* user code [SPI0_IRQn local 1] begin */

    /* user code [SPI0_IRQn local 1] end */
}

[/#if]
[#if NVIC_SPI1GlobalInterrupt ??== true && NVIC_SPI1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SPI1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI1_IRQHandler(void)
{
    /* user code [SPI1_IRQn local 0] begin */

    /* user code [SPI1_IRQn local 0] end */

    /* user code [SPI1_IRQn local 1] begin */

    /* user code [SPI1_IRQn local 1] end */
}

[/#if]
[#if NVIC_RTCAlarmFromEXTIInterrupt ??== true && NVIC_RTCAlarmFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      RTC Alarm From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void RTC_Alarm_IRQHandler(void)
{
    /* user code [RTC_Alarm_IRQn local 0] begin */

    /* user code [RTC_Alarm_IRQn local 0] end */

    /* user code [RTC_Alarm_IRQn local 1] begin */

    /* user code [RTC_Alarm_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine59Interrupt ??== true && NVIC_EXTILine59Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI Line5-9 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI5_9_IRQHandler(void)
{
    /* user code [EXTI5_9_IRQn local 0] begin */

    /* user code [EXTI5_9_IRQn local 0] end */

    /* user code [EXTI5_9_IRQn local 1] begin */

    /* user code [EXTI5_9_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER0TriggerAndChannelCommutationInterruptsOrTIMER0UpdateInterruptOrTIMER0BreakInterrupt ??== true && NVIC_TIMER0TriggerAndChannelCommutationInterruptsOrTIMER0UpdateInterruptOrTIMER0BreakInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER0 Trigger And Channel Commutation Interrupts Or
                TIMER0 Update Interrupt Or TIMER0 Break Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER0_TRG_CMT_UP_BRK_IRQHandler(void)
{
    /* user code [TIMER0_TRG_CMT_UP_BRK_IRQn local 0] begin */

    /* user code [TIMER0_TRG_CMT_UP_BRK_IRQn local 0] end */

    /* user code [TIMER0_TRG_CMT_UP_BRK_IRQn local 1] begin */

    /* user code [TIMER0_TRG_CMT_UP_BRK_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER0ChannelCaptureCompareInterrupt ??== true && NVIC_TIMER0ChannelCaptureCompareInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER0 Channel Capture Compare Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER0_Channel_IRQHandler(void)
{
    /* user code [TIMER0_Channel_IRQn local 0] begin */

    /* user code [TIMER0_Channel_IRQn local 0] end */

    /* user code [TIMER0_Channel_IRQn local 1] begin */

    /* user code [TIMER0_Channel_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER2GlobalInterrupt ??== true && NVIC_TIMER2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER2 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER2_IRQHandler(void)
{
    /* user code [TIMER2_IRQn local 0] begin */

    /* user code [TIMER2_IRQn local 0] end */

    /* user code [TIMER2_IRQn local 1] begin */

    /* user code [TIMER2_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER13GlobalInterrupt ??== true && NVIC_TIMER13GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER13 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER13_IRQHandler(void)
{
    /* user code [TIMER13_IRQn local 0] begin */

    /* user code [TIMER13_IRQn local 0] end */

    /* user code [TIMER13_IRQn local 1] begin */

    /* user code [TIMER13_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER15GlobalInterrupt ??== true && NVIC_TIMER15GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER15 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER15_IRQHandler(void)
{
    /* user code [TIMER15_IRQn local 0] begin */

    /* user code [TIMER15_IRQn local 0] end */

    /* user code [TIMER15_IRQn local 1] begin */

    /* user code [TIMER15_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER16GlobalInterrupt ??== true && NVIC_TIMER16GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER16 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER16_IRQHandler(void)
{
    /* user code [TIMER16_IRQn local 0] begin */

    /* user code [TIMER16_IRQn local 0] end */

    /* user code [TIMER16_IRQn local 1] begin */

    /* user code [TIMER16_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine1015Interrupt ??== true && NVIC_EXTILine1015Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI Line10-15 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI10_15_IRQHandler(void)
{
    /* user code [EXTI10_15_IRQn local 0] begin */

    /* user code [EXTI10_15_IRQn local 0] end */

    /* user code [EXTI10_15_IRQn local 1] begin */

    /* user code [EXTI10_15_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMAMUXInterrupt ??== true && NVIC_DMAMUXInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMAMUX Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMAMUX_IRQHandler(void)
{
    /* user code [DMAMUX_IRQn local 0] begin */

    /* user code [DMAMUX_IRQn local 0] end */

    /* user code [DMAMUX_IRQn local 1] begin */

    /* user code [DMAMUX_IRQn local 1] end */
}

[/#if]
[#if NVIC_CMP0OutputFromEXTIInterrupt ??== true && NVIC_CMP0OutputFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      CMP0 Output From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CMP0_IRQHandler(void)
{
    /* user code [CMP0_IRQn local 0] begin */

    /* user code [CMP0_IRQn local 0] end */

    /* user code [CMP0_IRQn local 1] begin */

    /* user code [CMP0_IRQn local 1] end */
}

[/#if]
[#if NVIC_CMP1OutputFromEXTIInterrupt ??== true && NVIC_CMP1OutputFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      CMP1 Output From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CMP1_IRQHandler(void)
{
    /* user code [CMP1_IRQn local 0] begin */

    /* user code [CMP1_IRQn local 0] end */

    /* user code [CMP1_IRQn local 1] begin */

    /* user code [CMP1_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C0WakeupFromEXTIInterrupt ??== true && NVIC_I2C0WakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C0 Wakeup Through EXTI Line Detection Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C0_WKUP_IRQHandler(void)
{
    /* user code [I2C0_WKUP_IRQn local 0] begin */

    /* user code [I2C0_WKUP_IRQn local 0] end */

    /* user code [I2C0_WKUP_IRQn local 1] begin */

    /* user code [I2C0_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C1WakeupFromEXTIInterrupt ??== true && NVIC_I2C1WakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C1 Wakeup Through EXTI Line Detection Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C1_WKUP_IRQHandler(void)
{
    /* user code [I2C1_WKUP_IRQn local 0] begin */

    /* user code [I2C1_WKUP_IRQn local 0] end */

    /* user code [I2C1_WKUP_IRQn local 1] begin */

    /* user code [I2C1_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_USART0WakeupFromEXTIInterrupt ??== true && NVIC_USART0WakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      USART0 Wakeup From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USART0_WKUP_IRQHandler(void)
{
    /* user code [USART0_WKUP_IRQn local 0] begin */

    /* user code [USART0_WKUP_IRQn local 0] end */

    /* user code [USART0_WKUP_IRQn local 1] begin */

    /* user code [USART0_WKUP_IRQn local 1] end */
}

[/#if]

/* user code [Global Functions Implementations] begin */

/* user code [Global Functions Implementations] end */

/* user code [Static Functions Implementations] begin */

/* user code [Static Functions Implementations] end */
