/*
    \file  main.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32g5x3.h"
#include "gd32g5x3_init.h"

/* External includes*/
/* user code [External Includes] begin */
#include <stdio.h>
/* user code [External Includes] end */

/* user code [global 0] begin */

/* user code [global 0] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */
#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
    #define __CLANG_ARM
#endif

#if defined(__CC_ARM) || defined(__CLANG_ARM) /* For ARM compiler */
    #define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
#elif defined(__GNUC__) && !defined(__clang__) /* For GNU GCC compiler */
    #define PUTCHAR_PROTOTYPE int __io_putchar(int ch)
#else
    #error Not supported toolchain
#endif

#define ARRAYSIZE 10
/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */
uint8_t spi0_send_array[ARRAYSIZE] = {0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA};
uint8_t spi1_send_array[ARRAYSIZE] = {0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA};
uint8_t spi0_receive_array[ARRAYSIZE];
uint8_t spi1_receive_array[ARRAYSIZE];
uint32_t send_n = 0, receive_n = 0;

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */
ErrStatus memory_compare(uint8_t *src, uint8_t *dst, uint8_t length);

void dma_channel_address_size_config(uint32_t dma_periph, dma_channel_enum channelx, uint32_t periph_addr, \
                                     uint32_t memory_addr, uint32_t size);

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */

    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();

    /* user code [local 1] begin */

    /* user code [local 1] end */

    msd_gpio_init();
    msd_dma_init();
    msd_spi0_init();
    msd_spi1_init();
    msd_usart0_init();

    /* user code [local 2] begin */

    /* configure DMA channel, peripheral address, memory address, transmit length */
    dma_channel_address_size_config(DMA0, DMA_CH0, (uint32_t)&SPI_DATA(SPI0), (uint32_t)spi0_send_array, ARRAYSIZE);
    dma_channel_address_size_config(DMA0, DMA_CH1, (uint32_t)&SPI_DATA(SPI0), (uint32_t)spi0_receive_array, ARRAYSIZE);
    dma_channel_address_size_config(DMA0, DMA_CH2, (uint32_t)&SPI_DATA(SPI1), (uint32_t)spi1_send_array, ARRAYSIZE);
    dma_channel_address_size_config(DMA0, DMA_CH3, (uint32_t)&SPI_DATA(SPI1), (uint32_t)spi1_receive_array, ARRAYSIZE);

    /* enable SPI DMA */
    spi_dma_enable(SPI1, SPI_DMA_TRANSMIT);
    spi_dma_enable(SPI1, SPI_DMA_RECEIVE);
    spi_dma_enable(SPI0, SPI_DMA_TRANSMIT);
    spi_dma_enable(SPI0, SPI_DMA_RECEIVE);

    spi_enable(SPI1);
    spi_enable(SPI0);

    /* wait dma transmit complete */
    while(!dma_flag_get(DMA0, DMA_CH0, DMA_INT_FLAG_FTF));
    while(!dma_flag_get(DMA0, DMA_CH2, DMA_INT_FLAG_FTF));
    while(!dma_flag_get(DMA0, DMA_CH1, DMA_INT_FLAG_FTF));
    while(!dma_flag_get(DMA0, DMA_CH3, DMA_INT_FLAG_FTF));

    /* compare receive data with send data */
    if(ERROR != memory_compare(spi1_receive_array, spi0_send_array, ARRAYSIZE)) {
        gpio_bit_set(GPIOE, GPIO_PIN_3);
    } else {
        gpio_bit_reset(GPIOE, GPIO_PIN_3);
    }

    if(ERROR != memory_compare(spi0_receive_array, spi1_send_array, ARRAYSIZE)) {
        gpio_bit_set(GPIOE, GPIO_PIN_4);
    } else {
        gpio_bit_reset(GPIOE, GPIO_PIN_4);
    }
    /* user code [local 2] end */

    while(1){
        /* user code [local 3] begin */

        /* user code [local 3] end */
    }
}

/* user code [global 1] begin */

/* user code [global 1] end */

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Function Implementations] begin */
/*!
    \brief      memory compare function
    \param[in]  src: source data pointer
    \param[in]  dst: destination data pointer
    \param[in]  length: the compare data length
    \param[out] none
    \retval     ErrStatus : ERROR or SUCCESS
*/
ErrStatus memory_compare(uint8_t *src, uint8_t *dst, uint8_t length)
{
    while(length--) {
        if(*src++ != *dst++) {
            return ERROR;
        }
    }
    return SUCCESS;
}

/*!
    \brief      configure dma info
    \param[in]  dma_periph: DMA peripheral
    \param[in]  channelx: DMA channel
    \param[in]  periph_addr: specify which DMA channel to set peripheral base address
    \param[in]  memory_addr: specify which DMA channel to set memory base address
    \param[in]  size: the size of remaining data to be transferred by the DMA
    \param[out] none
    \retval     none
*/
void dma_channel_address_size_config(uint32_t dma_periph, dma_channel_enum channelx, uint32_t periph_addr, \
                                     uint32_t memory_addr, uint32_t size)
{
    /* disable dma channel */
    dma_channel_disable(dma_periph, channelx);
    /* configure DMA peripheral base address */
    dma_periph_address_config(dma_periph, channelx, periph_addr);
    /* configure DMA memory base address */
    dma_memory_address_config(dma_periph, channelx, memory_addr);
    /* configure the number of remaining data to be transferred by the DMA */
    dma_transfer_number_config(dma_periph, channelx, size);

    /* enable dma channel */
    dma_channel_enable(dma_periph, channelx);
}

/*!
    \brief retarget the C library printf function to the USART
    \param[in]  ch: The character to be transmitted via USART.
    \param[in]  f: A standard C library file pointer, not actually used in this function.
    \param[out] none
    \retval     The character to be transmitted via USART.
*/
PUTCHAR_PROTOTYPE
{
    usart_data_transmit(USART0, (uint8_t)ch);

    while(RESET == usart_flag_get(USART0, USART_FLAG_TBE));

    return ch;
}
/* user code [Private Function Implementations] end */
