/*
    \file  main.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32g5x3.h"
#include "gd32g5x3_init.h"

/* External includes*/
/* user code [External Includes] begin */
#include "stdio.h"
/* user code [External Includes] end */

/* user code [global 0] begin */

/* user code [global 0] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */
#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
    #define __CLANG_ARM
#endif

#if defined(__CC_ARM) || defined(__CLANG_ARM) /* For ARM compiler */
    #define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
#elif defined(__GNUC__) && !defined(__clang__) /* For GNU GCC compiler */
    #define PUTCHAR_PROTOTYPE int __io_putchar(int ch)
#else
    #error Not supported toolchain
#endif
/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */
/* array of calculated filtered data by computer */
/* size = INPUT_DATA_SIZE - FAC_COEFFB + 1 */
const float reference_data[98] = {
    0.043184445016361f,  0.081810811178169f,  0.128244774527283f,  0.181747018022472f,  0.245029772512324f,
    0.320416813727530f,  0.405404917867519f,  0.491818787966269f,  0.569562281669030f,  0.631879331428592f,
    0.677683861324088f,  0.709103682126929f,  0.726611445315364f,  0.726229165936056f,  0.701414251983763f,
    0.648035491800538f,  0.568061163950519f,  0.468686346248479f,  0.357641865219304f,  0.238785354683498f,
    0.111791972130398f,  -0.023909006386698f, -0.164601046913034f, -0.301345396371116f, -0.423649024352286f,
    -0.524650070983251f, -0.603380759384717f, -0.662252964050590f, -0.702139381658027f, -0.719536424030579f,
    -0.708416200005361f, -0.665175349143770f, -0.592302137314169f, -0.497488111978141f, -0.388925987414758f,
    -0.270893489485712f, -0.143440018674432f, -0.006321722748056f, 0.136464917303466f,  0.275746203041783f,
    0.400836183864430f,  0.504718430805013f,  0.586304870567852f,  0.647917106894812f,  0.690363360074246f,
    0.710097283399365f,  0.701066123462830f,  0.659656054475456f,  0.588356136700954f,  0.494867214955035f,
    0.387397428282516f,  0.270244048206542f,  0.143478482571876f,  0.006880008154635f,  -0.135531696429985f,
    -0.274560466540054f, -0.399499198156804f, -0.503312017762724f, -0.584893358714116f, -0.646549400296632f,
    -0.689075026520866f, -0.708912586671874f, -0.699999944618863f, -0.658715664174368f, -0.587542794832356f,
    -0.494177585420843f, -0.386824805970815f, -0.269779402256090f, -0.143111325236285f, -0.006599102207918f,
    0.135737776490003f,  0.274702902995573f,  0.399588611405176f,  0.503358243888136f,  0.584905307474561f,
    0.646534978825119f,  0.689041115384931f,  0.708865056405437f,  0.699943702355506f,  0.658654721509000f,
    0.587480349472647f,  0.494116110527615f,  0.386766142306090f,  0.269724849346156f,  0.143061728709951f,
    0.006554935287805f,  -0.135776338677538f, -0.274735917060236f, -0.399616307595869f, -0.503380976217918f,
    -0.584923511758358f, -0.646549138128803f, -0.689051732255678f, -0.708872631177018f, -0.699948716788277f,
    -0.658657627023664f, -0.587481559261370f, -0.494115994868835f,

};
/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */
/* array of calculated filtered data by mcu */
/* size = INPUT_DATA_SIZE - FAC_COEFFB + 1 */
static float calculated_data[INPUT_DATA_SIZE - FAC_COEFFB + 1] = {0};

/* error between reference_data and calculated_data */
/* size = INPUT_DATA_SIZE - FAC_COEFFB + 1 */
volatile float error[INPUT_DATA_SIZE - FAC_COEFFB + 1] = {0};

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */
    uint16_t i;
    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();

    /* user code [local 1] begin */

    /* user code [local 1] end */

    msd_gpio_init();
    msd_fac_init();
    msd_usart0_init();

    /* user code [local 2] begin */

    /* start filter calculation */
    fac_start();

    /* get calculation result */
    for(i = 0; i < 98; i++) {
        while(fac_flag_get(FAC_FLAG_YBEF) != RESET);

        calculated_data[i] = (fac_float_data_read());
        error[i]           = reference_data[i] - calculated_data[i];

        printf("%f\r\n", calculated_data[i]);
    }

    /* finish calculation */
    fac_finish_calculate();

    /* user code [local 2] end */

    while(1){
        /* user code [local 3] begin */

        /* user code [local 3] end */
    }
}

/* user code [global 1] begin */

/* user code [global 1] end */

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Function Implementations] begin */
/*!
    \brief retarget the C library printf function to the USART
    \param[in] ch: The character to be transmitted via USART.
    \param[in] f: A standard C library file pointer, not actually used in this function.
    \param[out] none
    \retval ch: The character that was transmitted via USART.
*/
PUTCHAR_PROTOTYPE
{
    usart_data_transmit(USART0, (uint8_t)ch);

    while(RESET == usart_flag_get(USART0, USART_FLAG_TBE));

    return ch;
}
/* user code [Private Function Implementations] end */
