/*
    \file  gd32g5x3_init.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32g5x3_init.h"

/* user code [global 0] begin */

/* user code [global 0] end */

/* External includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
uint32_t g_cmp0to7_rcu_enable_flag = 0;

/* user code [Private Variables] begin */
volatile static uint32_t delay = 0;

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      SYSTEM initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_system_init(void)
{
    /* user code [system_init local 0] begin */

    /* user code [system_init local 0] end */

    rcu_periph_clock_enable(RCU_SYSCFG);
    nvic_priority_group_set(NVIC_PRIGROUP_PRE1_SUB3);
    systick_clksource_set(SYSTICK_CLKSOURCE_HCLK);
    nvic_exception_irq_enable(MemoryManagement_IRQn, 0, 0);
    nvic_exception_irq_enable(BusFault_IRQn, 0, 0);
    nvic_exception_irq_enable(UsageFault_IRQn, 0, 0);
    nvic_exception_irq_enable(SVCall_IRQn, 0, 0);
    nvic_exception_irq_enable(DebugMonitor_IRQn, 0, 0);
    nvic_exception_irq_enable(PendSV_IRQn, 0, 0);

    /* user code [system_init local 1] begin */

    /* user code [system_init local 1] end */
}

/*!
    \brief      CLOCK initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_clock_init(void)
{
    /* user code [clock_init local 0] begin */

    /* user code [clock_init local 0] end */

    rcu_osci_on(RCU_HXTAL);
    while (rcu_osci_stab_wait(RCU_HXTAL) != SUCCESS);

    rcu_pll_source_config(RCU_PLLSRC_HXTAL);
    rcu_pll_config((2U), (108U), (2U), (2U), (2U));
    rcu_pll_clock_output_enable(RCU_PLLP);
    fmc_wscnt_set(FMC_WAIT_STATE_7);
    rcu_system_clock_source_config(RCU_CKSYSSRC_PLLP);
    rcu_osci_on(RCU_PLL_CK);
    while (rcu_osci_stab_wait(RCU_PLL_CK) != SUCCESS);

    rcu_ahb_clock_config(RCU_AHB_CKSYS_DIV1);
    rcu_apb1_clock_config(RCU_APB1_CKAHB_DIV1);
    rcu_apb2_clock_config(RCU_APB2_CKAHB_DIV1);
    rcu_apb3_clock_config(RCU_APB3_CKAHB_DIV1);

    rcu_usart_clock_config(IDX_USART0, RCU_USARTSRC_APB);

    rcu_osci_bypass_mode_disable(RCU_HXTAL);
    rcu_osci_bypass_mode_disable(RCU_LXTAL);
    rcu_hxtal_clock_monitor_disable();
    rcu_lxtal_clock_monitor_disable();

    /* update SystemCoreClock value */
    SystemCoreClockUpdate();

    /* setup systick timer for 1000Hz interrupts */
    if (SysTick_Config(SystemCoreClock / 1000U))
    {
        /* capture error */
        while (1);
    }

    /* user code [clock_init local 1] begin */

    /* user code [clock_init local 1] end */
}

/*!
    \brief      GPIO initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_init(void)
{
    /* user code [gpio_init local 0] begin */

    /* user code [gpio_init local 0] end */

    rcu_periph_clock_enable(RCU_GPIOC);
    rcu_periph_clock_enable(RCU_GPIOE);
    rcu_periph_clock_enable(RCU_GPIOB);
    rcu_periph_clock_enable(RCU_GPIOA);

    gpio_bit_reset(GPIOE, GPIO_PIN_4);
    gpio_mode_set(GPIOE, GPIO_MODE_OUTPUT, GPIO_PUPD_NONE, GPIO_PIN_4);
    gpio_output_options_set(GPIOE, GPIO_OTYPE_PP, GPIO_OSPEED_100_220MHZ, GPIO_PIN_4);

    /* user code [gpio_init local 1] begin */

    /* user code [gpio_init local 1] end */
}

/*!
    \brief      GPIO deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_deinit(void)
{
    /* user code [gpio_deinit local 0] begin */

    /* user code [gpio_deinit local 0] end */

    rcu_periph_clock_disable(RCU_GPIOC);
    rcu_periph_clock_disable(RCU_GPIOE);
    rcu_periph_clock_disable(RCU_GPIOB);
    rcu_periph_clock_disable(RCU_GPIOA);

    /* user code [gpio_deinit local 1] begin */

    /* user code [gpio_deinit local 1] end */
}

/*!
    \brief      CMP0 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_cmp0_init(void)
{
    /* user code [cmp0_init local 0] begin */

    /* user code [cmp0_init local 0] end */

    g_cmp0to7_rcu_enable_flag++;
    if (1 == g_cmp0to7_rcu_enable_flag)
    {
        rcu_periph_clock_enable(RCU_CMP);
    }

    gpio_mode_set(GPIOB, GPIO_MODE_ANALOG, GPIO_PUPD_NONE, GPIO_PIN_1);

    cmp_voltage_scaler_enable(CMP0);
    cmp_scaler_bridge_enable(CMP0);
    cmp_noninverting_input_select(CMP0, CMP0_NONINVERTING_INPUT_PB1);
    cmp_mode_init(CMP0, CMPX_INVERTING_INPUT_VREFINT, CMP_HYSTERESIS_NO);
    cmp_output_init(CMP0, CMP_OUTPUT_POLARITY_NONINVERTED);
    cmp_blanking_init(CMP0, CMPX_BLANKING_NONE);
    cmp_reset_persist_mode_disable(CMP0);

    /* user code [cmp0_init local 1] begin */

    /* user code [cmp0_init local 1] end */
}

/*!
    \brief      CMP0 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_cmp0_deinit(void)
{
    /* user code [cmp0_deinit local 0] begin */

    /* user code [cmp0_deinit local 0] end */

    if (0 != g_cmp0to7_rcu_enable_flag)
    {
        g_cmp0to7_rcu_enable_flag--;
    }

    if (0 == g_cmp0to7_rcu_enable_flag)
    {
        rcu_periph_clock_disable(RCU_CMP);
    }

    /* user code [cmp0_deinit local 1] begin */

    /* user code [cmp0_deinit local 1] end */
}

/*!
    \brief      TIMER0 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_timer0_init(void)
{
    /* user code [timer0_init local 0] begin */

    /* user code [timer0_init local 0] end */

    timer_parameter_struct timer0_parameter;
    timer_ic_parameter_struct timer0_ic_parameter;

    rcu_periph_clock_enable(RCU_TIMER0);

    gpio_af_set(GPIOC, GPIO_AF_2, GPIO_PIN_0);
    gpio_mode_set(GPIOC, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_0);
    gpio_output_options_set(GPIOC, GPIO_OTYPE_PP, GPIO_OSPEED_60MHZ, GPIO_PIN_0);
    gpio_input_filter_set(GPIOC, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_0);

    timer_struct_para_init(&timer0_parameter);
    timer_channel_input_struct_para_init(&timer0_ic_parameter);

    timer_adjustment_mode_config(TIMER0, DISABLE);
    timer_auto_reload_shadow_disable(TIMER0);
    timer_counter_initial_register_config(TIMER0, DISABLE);
    timer_upif_backup_config(TIMER0, DISABLE);
    timer_master_slave_mode_config(TIMER0, TIMER_MASTER_SLAVE_MODE_DISABLE);
    timer_master_output0_trigger_source_select(TIMER0, TIMER_TRI_OUT0_SRC_RESET);
    timer_master_output1_trigger_source_select(TIMER0, TIMER_TRI_OUT1_SRC_RESET);
    timer0_parameter.prescaler = 215;
    timer0_parameter.alignedmode = TIMER_COUNTER_EDGE;
    timer0_parameter.counterdirection = TIMER_COUNTER_UP;
    timer0_parameter.period = 65535;
    timer0_parameter.repetitioncounter = 0x00000000;
    timer0_parameter.clockdivision = TIMER_CKDIV_DIV1;
    timer_init(TIMER0, &timer0_parameter);

    timer0_ic_parameter.icpolarity = TIMER_IC_POLARITY_RISING;
    timer0_ic_parameter.icselection = TIMER_IC_SELECTION_DIRECTTI;
    timer0_ic_parameter.icprescaler = TIMER_IC_PSC_DIV1;
    timer0_ic_parameter.icfilter = 15;
    timer_input_capture_config(TIMER0, TIMER_CH_0, &timer0_ic_parameter);

    timer_multi_mode_channel_mode_config(TIMER0, TIMER_MCH_0, TIMER_MCH_MODE_COMPLEMENTARY);

    /* user code [timer0_init local 1] begin */

    /* user code [timer0_init local 1] end */
}

/*!
    \brief      TIMER0 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_timer0_deinit(void)
{
    /* user code [timer0_deinit local 0] begin */

    /* user code [timer0_deinit local 0] end */

    rcu_periph_clock_disable(RCU_TIMER0);

    timer_deinit(TIMER0);

    /* user code [timer0_deinit local 1] begin */

    /* user code [timer0_deinit local 1] end */
}

/*!
    \brief      USART0 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_init(void)
{
    /* user code [usart0_init local 0] begin */

    /* user code [usart0_init local 0] end */

    rcu_periph_clock_enable(RCU_USART0);

    gpio_af_set(GPIOA, GPIO_AF_7, GPIO_PIN_10);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_10);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_85MHZ, GPIO_PIN_10);
    gpio_input_filter_set(GPIOA, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_10);

    gpio_af_set(GPIOA, GPIO_AF_7, GPIO_PIN_9);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_9);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_85MHZ, GPIO_PIN_9);
    gpio_input_filter_set(GPIOA, GPIO_ISPERIOD(0), GPIO_IFTYPE_ASYNC, GPIO_PIN_9);

    usart_baudrate_set(USART0, 115200);
    usart_word_length_set(USART0, USART_WL_8BIT);
    usart_parity_config(USART0, USART_PM_NONE);
    usart_stop_bit_set(USART0, USART_STB_1BIT);
    usart_receive_config(USART0, USART_RECEIVE_ENABLE);
    usart_transmit_config(USART0, USART_TRANSMIT_ENABLE);
    usart_receiver_timeout_disable(USART0);
    usart_oversample_config(USART0, USART_OVSMOD_16);
    usart_sample_bit_config(USART0, USART_OSB_3BIT);
    usart_fifo_disable(USART0);
    usart_overrun_disable(USART0);
    usart_reception_error_dma_disable(USART0);
    usart_data_first_config(USART0, USART_MSBF_LSB);
    usart_invert_config(USART0, USART_TXPIN_DISABLE);
    usart_invert_config(USART0, USART_RXPIN_DISABLE);
    usart_invert_config(USART0, USART_DINV_DISABLE);
    usart_invert_config(USART0, USART_SWAP_DISABLE);
    usart_enable(USART0);

    /* user code [usart0_init local 1] begin */

    /* user code [usart0_init local 1] end */
}

/*!
    \brief      USART0 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_deinit(void)
{
    /* user code [usart0_deinit local 0] begin */

    /* user code [usart0_deinit local 0] end */

    rcu_periph_clock_disable(RCU_USART0);

    usart_deinit(USART0);

    /* user code [usart0_deinit local 1] begin */

    /* user code [usart0_deinit local 1] end */
}

/* user code [global 1] begin */

/* user code [global 1] end */

/* user code [Public Functions Implementations] begin */
/*!
    \brief      delay a time in milliseconds
    \param[in]  count: count in milliseconds
    \param[out] none
    \retval     none
*/
void delay_1ms(uint32_t count)
{
    delay = count;
    while (0U != delay) {}
}
/*!
    \brief      delay decrement
    \param[in]  none
    \param[out] none
    \retval     none
*/
void delay_decrement(void)
{
    if (0U != delay)
    {
        delay--;
    }
}

/* user code [Public Functions Implementations] end */

/* user code [Private Functions Implementations] begin */

/* user code [Private Functions Implementations] end */
