/*
    \file  main.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32g5x3.h"
#include "gd32g5x3_init.h"

/* External includes*/
/* user code [External Includes] begin */
#include <stdio.h>
#include <string.h>
/* user code [External Includes] end */

/* user code [global 0] begin */

/* user code [global 0] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */
#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
    #define __CLANG_ARM
#endif

#if defined(__CC_ARM) || defined(__CLANG_ARM) /* For ARM compiler */
    #define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
#elif defined(__GNUC__) && !defined(__clang__) /* For GNU GCC compiler */
    #define PUTCHAR_PROTOTYPE int __io_putchar(int ch)
#else
    #error Not supported toolchain
#endif

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */
__attribute__((aligned(32))) const uint8_t ciphertext_ctr_128[TEXT_SIZE] = {
    0xA5, 0x6E, 0xC1, 0x3E, 0xDA, 0x96, 0xD5, 0xB7, 0x11, 0xC4, 0x07, 0x18, 0x67, 0xCC, 0xCE, 0x51,
    0x13, 0x4D, 0x93, 0x18, 0xB2, 0xA7, 0x07, 0x8D, 0x5C, 0x63, 0x19, 0xD5, 0x17, 0x51, 0x1F, 0xCD,
    0xD9, 0x4C, 0x31, 0x42, 0x16, 0x53, 0x0F, 0x37, 0x3A, 0x04, 0x9D, 0x95, 0x51, 0x0C, 0x9E, 0x06,
    0xF5, 0xCF, 0x4A, 0x2E, 0xA2, 0x8F, 0x97, 0xA4, 0x05, 0x64, 0xBB, 0xEA, 0x50, 0x0A, 0x16, 0x3E};
/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */
__IO uint8_t check_flag = 0;

uint8_t decrypt_result[TEXT_SIZE];

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */
void cau_aes_decrypt(void);
static void data_display(uint32_t datalength, uint8_t *data);
void data_check(uint8_t *src, uint8_t *dst, uint32_t len);
/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */
extern uint8_t encrypt_result[64];
extern uint8_t INPUT_DATA_BUFFER[64];
extern const uint8_t plaintext[PLAINTEXT_SIZE];

/* user code [Extern Variables] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */

    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();

    /* user code [local 1] begin */

    /* user code [local 1] end */

    msd_gpio_init();
    msd_cau_init();
    msd_usart0_init();

    /* user code [local 2] begin */
    printf("\r\nplain text :\r\n");
    data_display(TEXT_SIZE, (uint8_t *)plaintext);

    printf(" \r\n\r\nEncrypted Data with AES %d  Mode  CTR :\r\n\r\n", 128);
    data_display(TEXT_SIZE, encrypt_result);
    data_check((uint8_t *)&encrypt_result[0], (uint8_t *)ciphertext_ctr_128, 64);

    cau_aes_decrypt();

    /* check result */
    if(0U == check_flag) {
        gpio_bit_set(GPIOE, GPIO_PIN_3);
    }
    /* user code [local 2] end */

    while(1){
        /* user code [local 3] begin */

        /* user code [local 3] end */
    }
}

/* user code [global 1] begin */

/* user code [global 1] end */

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Function Implementations] begin */
/*!
    \brief      AES CTR 128 algorithm decrypt
    \param[in]  none
    \param[out] none
    \retval     none
*/
void cau_aes_decrypt(void)
{
    cau_parameter_struct cau_aes_parameter;

    /* --------- decryption in AES CTR 128 mode --------- */
    cau_deinit();
    cau_aes_parameter.alg_dir   = CAU_DECRYPT;
    cau_aes_parameter.key       = (uint8_t *)CAU_KEY_BUFFER;
    cau_aes_parameter.key_size  = KEY_BUFFER_SIZE;
    cau_aes_parameter.iv        = (uint8_t *)CAU_VECTOR_BUFFER;
    cau_aes_parameter.input     = (uint8_t *)encrypt_result;
    cau_aes_parameter.in_length = 64;
    if(SUCCESS == cau_aes_ctr(&cau_aes_parameter, decrypt_result)) {
        printf(" \r\n\r\nDecrypted Data with AES %d Mode CTR :\r\n\r\n", 128);
        data_display(TEXT_SIZE, decrypt_result);
        data_check((uint8_t *)&decrypt_result[0], (uint8_t *)&plaintext[0], 64);
    }
}

/*!
    \brief      printf data by a block of 16 bytes
    \param[in]  datalength: length of the data to display
    \param[in]  data: pointer to the data to display
    \param[out] none
    \retval     none
*/
static void data_display(uint32_t datalength, uint8_t *data)
{
    uint32_t i = 0, count = 0;

    for(i = 0; i < datalength; i++) {
        printf("0x%02X ", data[i]);
        count++;

        if(8 == count) {
            count = 0;
            printf("\r\n");
        }
    }
}

/*!
    \brief      check data in bytes
    \param[in]  src: source
    \param[in]  dst: destination
    \param[in]  len: length of the data to check
    \param[out] none
    \retval     none
*/
void data_check(uint8_t *src, uint8_t *dst, uint32_t len)
{
    if(memcmp((const void *)src, (const void *)dst, len) != 0) {
        check_flag++;
    }
}

/*!
    \brief retarget the C library printf function to the USART
    \param[in]  ch: The character to be transmitted via USART.
    \param[in]  f: A standard C library file pointer, not actually used in this function.
    \param[out] none
    \retval     The character to be transmitted via USART.
*/
PUTCHAR_PROTOTYPE
{
    usart_data_transmit(USART0, (uint8_t)ch);

    while(RESET == usart_flag_get(USART0, USART_FLAG_TBE));

    return ch;
}
/* user code [Private Function Implementations] end */
