/*
    \file  main.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32g5x3.h"
#include "gd32g5x3_init.h"

/* External includes*/
/* user code [External Includes] begin */
#include <stdio.h>
#include <string.h>
/* user code [External Includes] end */

/* user code [global 0] begin */

/* user code [global 0] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */
#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
    #define __CLANG_ARM
#endif

#if defined(__CC_ARM) || defined(__CLANG_ARM) /* For ARM compiler */
    #define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
#elif defined(__GNUC__) && !defined(__clang__) /* For GNU GCC compiler */
    #define PUTCHAR_PROTOTYPE int __io_putchar(int ch)
#else
    #error Not supported toolchain
#endif
/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */
__attribute__((aligned(32))) const uint8_t ciphertext_ccm[CIPHERTEXT_SIZE] = {
    0x97, 0x8E, 0x3C, 0x60, 0x10, 0xC9, 0x0D, 0x3D, 0xE9, 0x4C, 0x9C, 0x8E, 0x5D, 0x40, 0x69, 0x5F,
    0xC2, 0x30, 0xFD, 0x0A, 0x42, 0xF1, 0xC5, 0x02, 0x2C, 0x98, 0xAC, 0x1C, 0x45, 0x33, 0x1A, 0x78,
    0x84, 0x83, 0xF1, 0xEB, 0xDD, 0xD3, 0x06, 0xA2, 0xF6, 0x5D, 0xE5, 0x79, 0xB9, 0xC6, 0x63, 0x01,
    0xB8, 0x70, 0x74, 0xCA, 0xCE, 0xA3, 0x17, 0xA0, 0x97, 0xE9, 0x7E, 0xA8, 0x80, 0xEF, 0x0D, 0x77};

__attribute__((aligned(32))) const uint8_t exp_ccm_tag[6] = {0x5F, 0x00, 0x24, 0x8A, 0xA7, 0xF7};

__attribute__((aligned(32)))
const uint8_t aadmessage[AAD_SIZE] = {0x47, 0x44, 0x33, 0x32, 0x2D, 0x4D, 0x43, 0x55,
                                      0x47, 0x44, 0x33, 0x32, 0x2D, 0x4D, 0x43, 0x55};  //(ASCII)GD-32MCUGD-32MCU
/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */
__IO uint8_t check_flag = 0;

uint8_t decrypt_result[TEXT_SIZE];

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */
void cau_parameter_printf(char *name, uint8_t *data, uint32_t data_size);
static void data_display(uint32_t datalength, uint8_t *data);
void data_check(uint8_t *src, uint8_t *dst, uint32_t len);
void cau_aes_decrypt(void);
/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */
extern uint8_t INPUT_DATA_BUFFER[64];
extern __attribute__((aligned(32))) const uint8_t plaintext[PLAINTEXT_SIZE];

/* user code [Extern Variables] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */

    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();

    /* user code [local 1] begin */

    /* user code [local 1] end */

    msd_gpio_init();
    msd_cau_init();
    msd_usart0_init();

    /* user code [local 2] begin */
    printf("\r\nencryption in CCM mode\r\n");
    printf("\r\nplain text :\r\n");
    data_display(TEXT_SIZE, (uint8_t *)plaintext);
    /* print output parameters */
    cau_parameter_printf("encrypted data", encrypt_result, PLAINTEXT_SIZE);
    data_check((uint8_t *)&encrypt_result[0], (uint8_t *)&ciphertext_ccm[0], PLAINTEXT_SIZE);
    cau_parameter_printf("tag", ccm_tag, 6);
    data_check((uint8_t *)&ccm_tag[0], (uint8_t *)&exp_ccm_tag[0], 6);
    printf("\r\n");

    cau_aes_decrypt();

    /* check result */
    if(0U == check_flag) {
        gpio_bit_set(GPIOE, GPIO_PIN_3);
    }
    /* user code [local 2] end */

    while(1) {
        /* user code [local 3] begin */

        /* user code [local 3] end */
    }
}

/* user code [global 1] begin */

/* user code [global 1] end */

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Function Implementations] begin */
/*!
    \brief      AES CCM algorithm decrypt
    \param[in]  none
    \param[out] none
    \retval     none
*/
void cau_aes_decrypt(void)
{
    cau_parameter_struct cau_ccm_parameter;

    /* --------- decryption in AES CCM mode --------- */
    cau_deinit();
    cau_ccm_parameter.alg_dir   = CAU_DECRYPT;
    cau_ccm_parameter.key       = (uint8_t *)CAU_KEY_BUFFER;
    cau_ccm_parameter.key_size  = KEY_BUFFER_SIZE;
    cau_ccm_parameter.iv        = (uint8_t *)CAU_VECTOR_BUFFER;
    cau_ccm_parameter.iv_size   = 8;
    cau_ccm_parameter.input     = (uint8_t *)ciphertext_ccm;
    cau_ccm_parameter.in_length = 64;
    cau_ccm_parameter.aad       = (uint8_t *)aadmessage;
    cau_ccm_parameter.aad_size  = 16;
    cau_aes_ccm(&cau_ccm_parameter, decrypt_result, ccm_tag, 6, aad_buf);
    printf("\r\ndecryption in CCM mode\r\n");
    /* print output parameters */
    cau_parameter_printf("decrypted data", decrypt_result, CIPHERTEXT_SIZE);
    data_check((uint8_t *)&decrypt_result[0], (uint8_t *)&INPUT_DATA_BUFFER[0], PLAINTEXT_SIZE);
    cau_parameter_printf("tag", ccm_tag, 6);
    printf("\r\n");
}

/*!
    \brief      print cau parameter
    \param[in]  name: parameter name
    \param[in]  data: parameter raw data
    \param[in]  data_size: raw data size
    \param[out] none
    \retval     none
*/
void cau_parameter_printf(char *name, uint8_t *data, uint32_t data_size)
{
    uint32_t i = 0, count = 0;

    printf("%s:\n", name);
    for(i = 0; i < data_size; i++) {
        printf(" 0x%02X", data[i]);
        count++;

        if(8 == count) {
            count = 0;
            printf("\r\n");
        }
    }
}

/*!
    \brief      printf data by a block of 16 bytes
    \param[in]  datalength: length of the data to display
    \param[in]  data: pointer to the data to display
    \param[out] none
    \retval     none
*/
static void data_display(uint32_t datalength, uint8_t *data)
{
    uint32_t i = 0, count = 0;

    for(i = 0; i < datalength; i++) {
        printf("0x%02X ", data[i]);
        count++;

        if(8 == count) {
            count = 0;
            printf("\r\n");
        }
    }
}

/*!
    \brief      check data in bytes
    \param[in]  src: source
    \param[in]  dst: destination
    \param[in]  len: length of the data to check
    \param[out] none
    \retval     none
*/
void data_check(uint8_t *src, uint8_t *dst, uint32_t len)
{
    if(memcmp((const void *)src, (const void *)dst, len) != 0) {
        check_flag++;
    }
}

/*!
    \brief retarget the C library printf function to the USART
    \param[in]  ch: The character to be transmitted via USART.
    \param[in]  f: A standard C library file pointer, not actually used in this function.
    \param[out] none
    \retval     The character to be transmitted via USART.
*/
PUTCHAR_PROTOTYPE
{
    usart_data_transmit(USART0, (uint8_t)ch);

    while(RESET == usart_flag_get(USART0, USART_FLAG_TBE));

    return ch;
}
/* user code [Private Function Implementations] end */
