/*
    \file  main.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32g5x3.h"
#include "gd32g5x3_init.h"

/* External includes*/
/* user code [External Includes] begin */
#include <stdio.h>
#include <string.h>
/* user code [External Includes] end */

/* user code [global 0] begin */

/* user code [global 0] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */
/* global variable declarations */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */
#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
    #define __CLANG_ARM
#endif

#if defined(__CC_ARM) || defined(__CLANG_ARM) /* For ARM compiler */
    #define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
#elif defined(__GNUC__) && !defined(__clang__) /* For GNU GCC compiler */
    #define PUTCHAR_PROTOTYPE int __io_putchar(int ch)
#else
    #error Not supported toolchain
#endif

#define BUFFER_SIZE 8U
/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */
can_mailbox_descriptor_struct transmit_message;
can_mailbox_descriptor_struct receive_message;
/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */
static void can_loopback_process(uint32_t CANX);
static void loopback_init(can_mailbox_descriptor_struct *transmit_message, \
                          can_mailbox_descriptor_struct *receive_message);

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */
    static uint8_t flag = 0;
    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();

    /* user code [local 1] begin */

    /* user code [local 1] end */

    msd_gpio_init();
    msd_can0_init();
    msd_can1_init();
    msd_can2_init();
    msd_usart0_init();

    /* user code [local 2] begin */

    /* user code [local 2] end */

    while(1) {
        /* user code [local 3] begin */
        if(0U == gpio_input_bit_get(GPIOA, GPIO_PIN_0)) {
            delay_1ms(100U);
            gpio_bit_reset(GPIOC, GPIO_PIN_9);
            if(0U == gpio_input_bit_get(GPIOA, GPIO_PIN_0)) {
                if(flag == 0) {
                    flag++;
                    printf("This is CAN0 Loopback Test\r\n");
                    can_loopback_process(CAN0);
                } else if(flag == 1) {
                    flag++;
                    printf("This is CAN1 Loopback Test\r\n");
                    can_loopback_process(CAN1);
                } else if(flag == 2) {
                    flag = 0;
                    printf("This is CAN2 Loopback Test\r\n");
                    can_loopback_process(CAN2);
                }

                /* waiting for the KEY_A up */
                while(0U == gpio_input_bit_get(GPIOA, GPIO_PIN_0));
            }
        }
        /* user code [local 3] end */
    }
}

/* user code [global 1] begin */

/* user code [global 1] end */

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Function Implementations] begin */
/*!
    \brief      CAN Loopback Test
    \param[in]  CANX: CANx periph(x = 0,1,2)
    \param[out] none
    \retval     none
*/
static void can_loopback_process(uint32_t CANX)
{
    uint32_t timeout = 0xFFFFU;
    loopback_init(&transmit_message, &receive_message);
    can_mailbox_config(CANX, 1U, &receive_message);

    /* transmit message */
    can_mailbox_config(CANX, 0U, &transmit_message);

    /* waiting for transmit completed */
    while((RESET == can_flag_get(CANX, CAN_FLAG_MB0)) && (0U != timeout)) {
        timeout--;
    }

    /* waiting for receive completed */
    timeout = 0xFFFFU;
    while((RESET == can_flag_get(CANX, CAN_FLAG_MB1)) && (0U != timeout)) {
        timeout--;
    }

    /* check the receive message */
    can_mailbox_receive_data_read(CANX, 1U, &receive_message);

    /* check the receive message */
    if(0U == memcmp(receive_message.data, receive_message.data, receive_message.data_bytes)) {
        /* loopback test is success LED1*/
        gpio_bit_set(GPIOC, GPIO_PIN_9);
    } else {
        /* loopback test is failed LED3*/
        gpio_bit_set(GPIOC, GPIO_PIN_12);
    }
}

/*!
    \brief      CAN Loopback Test Initialize
    \param[in]  transmit_message: pointer to the transmit message structure
    \param[in]  receive_message: pointer to the receive message structure
    \param[out] none
    \retval     none
*/
static void loopback_init(can_mailbox_descriptor_struct *transmit_message, \
                          can_mailbox_descriptor_struct *receive_message)
{
    /* initialize transmit message */
    for(int i = 0; i < BUFFER_SIZE; i++) {
        transmit_message->data[i] = 0xA0 + i;
    }

    /* initialize transmit message */
    transmit_message->rtr        = 0U;
    transmit_message->ide        = 0U;
    transmit_message->code       = CAN_MB_TX_STATUS_DATA;
    transmit_message->brs        = 0U;
    transmit_message->fdf        = 0U;
    transmit_message->prio       = 0U;
    transmit_message->data_bytes = BUFFER_SIZE;
    transmit_message->id         = 0x55U;

    receive_message->rtr  = 0U;
    receive_message->ide  = 0U;
    receive_message->code = CAN_MB_RX_STATUS_EMPTY;
    receive_message->id   = 0x55U;
}

/*!
    \brief retarget the C library printf function to the USART
    \param[in] ch: The character to be transmitted via USART.
    \param[in] f: A standard C library file pointer, not actually used in this function.
    \param[out] none
    \retval ch: The character that was transmitted via USART.
*/
PUTCHAR_PROTOTYPE
{
    usart_data_transmit(USART0, (uint8_t)ch);

    while(RESET == usart_flag_get(USART0, USART_FLAG_TBE));

    return ch;
}
/* user code [Private Function Implementations] end */
