/*
    \file  main.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32g5x3.h"
#include "gd32g5x3_init.h"

/* External includes*/
/* user code [External Includes] begin */
#include <stdio.h>
#include <string.h>
/* user code [External Includes] end */

/* user code [global 0] begin */

/* user code [global 0] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */
#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
    #define __CLANG_ARM
#endif

#if defined(__CC_ARM) || defined(__CLANG_ARM) /* For ARM compiler */
    #define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
#elif defined(__GNUC__) && !defined(__clang__) /* For GNU GCC compiler */
    #define PUTCHAR_PROTOTYPE int __io_putchar(int ch)
#else
    #error Not supported toolchain
#endif

#define BUFFER_SIZE 8U
/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */
can_mailbox_descriptor_struct transmit_message;
can_mailbox_descriptor_struct receive_message;

__IO FlagStatus can0_match_flag = RESET;
__IO FlagStatus can0_timeout_flag = RESET;
/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */
static void communication_check(void);

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */
    uint8_t i               = 0;
    FlagStatus can_tx_state = RESET;
    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();

    /* user code [local 1] begin */

    /* user code [local 1] end */

    msd_gpio_init();
    msd_can0_init();
    msd_can1_init();
    msd_usart0_init();

    /* user code [local 2] begin */
    printf("\r\nPretended Networking mode test CAN0 and CAN1, please press KEY_A key to start! \r\n");

    can_struct_para_init(CAN_MDSC_STRUCT, &transmit_message);
    can_struct_para_init(CAN_MDSC_STRUCT, &receive_message);
    /* fill the data for CAN transmit */
    for(i = 0; i < BUFFER_SIZE; i++) {
        transmit_message.data[i] = 0xA0 + i;
    }

    /* initialize transmit message */
    transmit_message.rtr        = 0U;
    transmit_message.ide        = 0U;
    transmit_message.code       = CAN_MB_TX_STATUS_DATA;
    transmit_message.brs        = 0U;
    transmit_message.fdf        = 0U;
    transmit_message.prio       = 0U;
    transmit_message.data_bytes = BUFFER_SIZE;
    transmit_message.id         = 0x55U;
    /* user code [local 2] end */

    while(1) {
        /* user code [local 3] begin */
        /* test whether the KEY_A is pressed */
        if(0U == gpio_input_bit_get(GPIOA, GPIO_PIN_0)) {
            delay_1ms(100U);
            if(0U == gpio_input_bit_get(GPIOA, GPIO_PIN_0)) {
                /* enter Pretended Networking mode */
                can_operation_mode_enter(CAN0, CAN_PN_MODE);
                printf("\r\nCAN0 enter Pretended Networking mode \r\n");
                /* waiting for the KEY_A up */
                while(0U == gpio_input_bit_get(GPIOA, GPIO_PIN_0));
            }
        }

        /* test whether the KEY_B is pressed */
        if(0U == gpio_input_bit_get(GPIOC, GPIO_PIN_13)) {
            delay_1ms(100U);
            if(0U == gpio_input_bit_get(GPIOC, GPIO_PIN_13)) {
                if((RESET == can_tx_state) || (SET == can_flag_get(CAN1, CAN_FLAG_MB1))) {
                    can_tx_state = SET;
                    can_flag_clear(CAN1, CAN_FLAG_MB1);
                    /* transmit message */
                    can_mailbox_config(CAN1, 1, &transmit_message);

                    printf("\r\nCAN1 transmit data: \r\n");
                    for(i = 0U; i < transmit_message.data_bytes; i++) {
                        printf("%02x ", transmit_message.data[i]);
                    }
                    printf("\r\n");
                }
                /* waiting for the KEY_B up */
                while(0U == gpio_input_bit_get(GPIOC, GPIO_PIN_13));
            }
        }
        communication_check();
        /* user code [local 3] end */
    }
}

/* user code [global 1] begin */

/* user code [global 1] end */

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Function Implementations] begin */
/*
    \brief      communication check function
    \param[in]  none
    \param[out] none
    \retval     none
*/
static void communication_check(void)
{
    uint8_t i = 0U;
    /* CAN0 wakeup match event */
    if(SET == can0_match_flag) {
        can0_match_flag = RESET;
        can_pn_mode_data_read(CAN0, 0U, &receive_message);
        printf("\r\nCAN0 woke up with match event \r\n");
        if(0U == memcmp(receive_message.data, transmit_message.data, receive_message.data_bytes)) {
            printf("\r\nCAN0 receive data: \r\n");
            for(i = 0U; i < receive_message.data_bytes; i++) {
                printf("%02x ", receive_message.data[i]);
            }
            printf("\r\n");
            gpio_bit_toggle(GPIOE, GPIO_PIN_3);
        }
        can_pn_mode_exit(CAN0);
    }

    /* CAN0 wakeup timeout */
    if(SET == can0_timeout_flag) {
        printf("\r\nCAN0 woke up with timeout event \r\n");
        can0_timeout_flag = RESET;
        gpio_bit_toggle(GPIOE, GPIO_PIN_4);
        can_pn_mode_exit(CAN0);
    }
}

/*!
    \brief retarget the C library printf function to the USART
    \param[in] ch: The character to be transmitted via USART.
    \param[in] f: A standard C library file pointer, not actually used in this function.
    \param[out] none
    \retval ch: The character that was transmitted via USART.
*/
PUTCHAR_PROTOTYPE
{
    usart_data_transmit(USART0, (uint8_t)ch);

    while(RESET == usart_flag_get(USART0, USART_FLAG_TBE));

    return ch;
}
/* user code [Private Function Implementations] end */
