/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
#define ARRAYNUM(arr_nanme)     (uint32_t)(sizeof(arr_nanme) / sizeof(*(arr_nanme)))
#define TRANSMIT_SIZE0          (ARRAYNUM(transmitter_buffer0) - 1)
#define TRANSMIT_SIZE1          (ARRAYNUM(transmitter_buffer1) - 1)

uint8_t transmitter_buffer0[] = "\n\ra usart half-duplex test example!\n\r";
uint8_t transmitter_buffer1[] = "\n\ra usart half-duplex test example!\n\r";
uint8_t receiver_buffer0[TRANSMIT_SIZE1];
uint8_t receiver_buffer1[TRANSMIT_SIZE0];
uint8_t transfersize0;
uint8_t transfersize1;
__IO uint8_t txcount0 = 0;
__IO uint16_t rxcount0 = 0;
__IO uint8_t txcount1 = 0;
__IO uint16_t rxcount1 = 0;
ErrStatus state1 = ERROR;
ErrStatus state2 = ERROR;

ErrStatus memory_compare(uint8_t* src, uint8_t* dst, uint16_t length) ;
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */
    /* initialize the values */
    transfersize0 = TRANSMIT_SIZE0;
    transfersize1 = TRANSMIT_SIZE1;
    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */

    /* user code [local 1] end */
    msd_gpio_init();
    msd_usart0_init();
    msd_usart1_init();

    /* user code [local 2] begin */
    /* USART1 transmit and USART0 receive*/
    hals_uart_transmit_config(uart1_info.periph, USART_TRANSMIT_ENABLE);
    hals_uart_receive_config(uart1_info.periph, USART_RECEIVE_DISABLE);
    hals_uart_transmit_config(uart0_info.periph, USART_TRANSMIT_DISABLE);
    hals_uart_receive_config(uart0_info.periph, USART_RECEIVE_ENABLE);
    while(transfersize1--){
        hal_uart_transmit_poll(&uart1_info, &transmitter_buffer1[txcount1++], 1, 0x1FFF);
        hal_uart_receive_poll(&uart0_info, &receiver_buffer0[rxcount1++], 1, 0x1FFFFF);
    }
    /* USART0 transmit and USART1 receive*/
    hals_uart_transmit_config(uart0_info.periph, USART_TRANSMIT_ENABLE);
    hals_uart_receive_config(uart0_info.periph, USART_RECEIVE_DISABLE);
    hals_uart_transmit_config(uart1_info.periph, USART_TRANSMIT_DISABLE);
    hals_uart_receive_config(uart1_info.periph, USART_RECEIVE_ENABLE);
    while(transfersize0--){
        hal_uart_transmit_poll(&uart0_info, &transmitter_buffer0[txcount0++], 1, 0x1FFF);
        hal_uart_receive_poll(&uart1_info, &receiver_buffer1[rxcount0++], 1, 0x1FFFFF);
    }

    /* compare the received data with the send ones */
    state1 = memory_compare(transmitter_buffer0, receiver_buffer1, TRANSMIT_SIZE0);
    state2 = memory_compare(transmitter_buffer1, receiver_buffer0, TRANSMIT_SIZE1);
    if(SUCCESS == state1){
        /* if the data transmitted from USART0 and received by USART1 are the same */
        hal_gpio_bit_set(LED1_GPIO_PORT, LED1_PIN);
    }else{
        /* if the data transmitted from USART0 and received by USART1 are not the same */
        hal_gpio_bit_reset(LED1_GPIO_PORT, LED1_PIN);
    }
    if(SUCCESS == state2){
        /* if the data transmitted from USART1 and received by USART0 are the same */
        hal_gpio_bit_set(LED2_GPIO_PORT, LED2_PIN);
    }else{
        /* if the data transmitted from USART1 and received by USART0 are not the same */
        hal_gpio_bit_reset(LED2_GPIO_PORT, LED2_PIN);
    }
    /* user code [local 2] end */

    while(1){
    /* user code [local 3] begin */

    /* user code [local 3] end */
    }
}
/* user code [global 1] begin */
/*!
    \brief      memory compare function
    \param[in]  src : source data
    \param[in]  dst : destination data
    \param[in]  length : the compare data length
    \param[out] none
    \retval     ErrStatus : ERROR or SUCCESS
*/
ErrStatus memory_compare(uint8_t* src, uint8_t* dst, uint16_t length)
{
    while(length--){
        if (*src++ != *dst++){
            return ERROR;
        }
    }
    return SUCCESS;
}
/* user code [global 1] end */	
