/*
    \file  gd32f3x0_hal_init.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */

/* user code [global 0] end */
hal_uart_dev_struct uart0_info;
hal_uart_dev_struct uart1_info;

void msd_system_init(void)
{
    /* user code [system_init local 0] begin */
    /* user code [system_init local 0] end */
    hal_rcu_periph_clk_enable(RCU_CFGCMP);
    hal_nvic_irq_priority_group_set(NVIC_PRIGROUP_PRE4_SUB0);
    hal_sys_debug_init(SYS_DEBUG_SERIAL_WIRE);
    hal_sys_timesource_init(SYS_TIMEBASE_SOURCE_SYSTICK);

    hal_nvic_set_priority(NonMaskableInt_IRQn, 0, 0);
    hal_nvic_set_priority(SVCall_IRQn, 0, 0);
    hal_nvic_set_priority(PendSV_IRQn, 0, 0);
    hal_nvic_set_priority(SysTick_IRQn, 0, 0);
    /* user code [system_init local 1] begin */
    /* user code [system_init local 1] end */
}

void msd_clock_init(void)
{
    /* user code [clock_init local 0] begin */
    /* user code [clock_init local 0] end */
    hal_rcu_clk_struct rcu_clk_parameter;
    hal_rcu_osci_struct rcu_osci_parameter;
    hal_rcu_periphclk_struct rcu_periphclk_parameter;

    hal_rcu_struct_init(HAL_RCU_CLK_STRUCT, &rcu_clk_parameter);
    hal_rcu_struct_init(HAL_RCU_OSCI_STRUCT, &rcu_osci_parameter);
    hal_rcu_struct_init(HAL_RCU_PERIPHCLK_STRUCT, &rcu_periphclk_parameter);

    rcu_osci_parameter.hxtal.need_configure = ENABLE;
    rcu_osci_parameter.hxtal.state = RCU_OSC_ON;
    rcu_osci_parameter.irc8m.need_configure = ENABLE;
    rcu_osci_parameter.irc8m.state = RCU_OSC_ON;
    rcu_osci_parameter.irc8m.adjust_value = 0;
    rcu_osci_parameter.pll.need_configure = ENABLE;
    rcu_osci_parameter.pll.state = RCU_OSC_ON;
    rcu_osci_parameter.pll.pll_source = RCU_PLL_SRC_HXTAL_IRC48M;
    rcu_osci_parameter.pll.pll_mul = RCU_PLL_MULT27;
    rcu_osci_parameter.pll.pll_presel = RCU_PLL_PRESEL_HXTAL;
    rcu_osci_parameter.pll.pre_div = RCU_PLL_PREDIV2;
    if(HAL_ERR_NONE != hal_rcu_osci_config(&rcu_osci_parameter)){
        while(1);
    }

    rcu_clk_parameter.clock_type = RCU_CLKTYPE_SYSCLK | RCU_CLKTYPE_AHBCLK | RCU_CLKTYPE_APB1CLK | RCU_CLKTYPE_APB2CLK | RCU_CLKTYPE_CK48MCLK;
    rcu_clk_parameter.sysclk_source = RCU_SYSCLK_SRC_PLL;
    rcu_clk_parameter.ahbclk_divider = RCU_SYSCLK_AHBDIV1;
    rcu_clk_parameter.apb1clk_divider = RCU_AHBCLK_APB1DIV2;
    rcu_clk_parameter.apb2clk_divider = RCU_AHBCLK_APB2DIV2;
    rcu_clk_parameter.ck48mclk_source = RCU_USB_CK48MSRC_IRC48M;
    if(HAL_ERR_NONE != hal_rcu_clock_config(&rcu_clk_parameter)){
        while(1);
    }

    rcu_periphclk_parameter.periph_clock_type = RCU_PERIPH_CLKTYPE_USART0;
    rcu_periphclk_parameter.usart0_clock_source = RCU_USART0_CLKSRC_SYS;
    if(HAL_ERR_NONE != hal_rcu_periph_clock_config(&rcu_periphclk_parameter)){
        while(1);
    }

    /* user code [clock_init local 1] begin */
    /* user code [clock_init local 1] end */
}

void msd_gpio_init(void)
{
    /* user code [gpio_init local 0] begin */
    /* user code [gpio_init local 0] end */
    hal_gpio_init_struct gpio_init_parameter;

    hal_rcu_periph_clk_enable(RCU_GPIOC);
    hal_rcu_periph_clk_enable(RCU_GPIOF);
    hal_rcu_periph_clk_enable(RCU_GPIOA);
    hal_gpio_struct_init(&gpio_init_parameter);

    gpio_init_parameter.mode = GPIO_MODE_OUTPUT_PP;
    gpio_init_parameter.pull = GPIO_PULL_NONE;
    gpio_init_parameter.ospeed = GPIO_OSPEED_50MHZ;
    gpio_init_parameter.af = GPIO_AF_0;
    hal_gpio_init(LED2_GPIO_PORT, LED2_PIN, &gpio_init_parameter);

    gpio_init_parameter.mode = GPIO_MODE_OUTPUT_PP;
    gpio_init_parameter.pull = GPIO_PULL_NONE;
    gpio_init_parameter.ospeed = GPIO_OSPEED_50MHZ;
    gpio_init_parameter.af = GPIO_AF_0;
    hal_gpio_init(LED1_GPIO_PORT, LED1_PIN, &gpio_init_parameter);

    /* user code [gpio_init local 1] begin */
    /* user code [gpio_init local 1] end */
}

void msd_gpio_deinit(void)
{
    /* user code [gpio_deinit local 0] begin */
    /* user code [gpio_deinit local 0] end */
    hal_rcu_periph_clk_disable(RCU_GPIOC);
    hal_rcu_periph_clk_disable(RCU_GPIOF);
    hal_rcu_periph_clk_disable(RCU_GPIOA);
    hal_gpio_deinit(LED2_GPIO_PORT, LED2_PIN);
    hal_gpio_deinit(LED1_GPIO_PORT, LED1_PIN);
    /* user code [gpio_deinit local 1] begin */
    /* user code [gpio_deinit local 1] end */
}

void msd_usart0_init(void)
{
    /* user code [usart0_init local 0] begin */
    /* user code [usart0_init local 0] end */
    hal_gpio_init_struct gpio_init_parameter;
    hal_uart_init_struct uart0_init_parameter;

    hal_rcu_periph_clk_enable(RCU_USART0);
    hal_gpio_struct_init(&gpio_init_parameter);

    gpio_init_parameter.mode = GPIO_MODE_AF_PP;
    gpio_init_parameter.pull = GPIO_PULL_NONE;
    gpio_init_parameter.ospeed = GPIO_OSPEED_50MHZ;
    gpio_init_parameter.af = GPIO_AF_1;
    hal_gpio_init(GPIOA, GPIO_PIN_9, &gpio_init_parameter);

    hal_uart_struct_init(HAL_UART_INIT_STRUCT, &uart0_init_parameter);
    hal_uart_struct_init(HAL_UART_DEV_STRUCT, &uart0_info);

    uart0_init_parameter.work_mode = UART_WORK_MODE_SINGLE_WIRE;
    uart0_init_parameter.baudrate = 115200;
    uart0_init_parameter.parity = UART_PARITY_NONE;
    uart0_init_parameter.word_length = UART_WORD_LENGTH_8BIT;
    uart0_init_parameter.stop_bit = UART_STOP_BIT_1;
    uart0_init_parameter.direction = UART_DIRECTION_RX_TX;
    uart0_init_parameter.over_sample = UART_OVER_SAMPLE_16;
    uart0_init_parameter.sample_method = UART_THREE_SAMPLE_BIT;
    uart0_init_parameter.rx_fifo_en = DISABLE;
    uart0_init_parameter.timeout_enable = DISABLE;
    uart0_init_parameter.first_bit_msb = DISABLE;
    uart0_init_parameter.tx_rx_swap = DISABLE;
    uart0_init_parameter.rx_level_invert = DISABLE;
    uart0_init_parameter.tx_level_invert = DISABLE;
    uart0_init_parameter.data_bit_invert = DISABLE;
    uart0_init_parameter.overrun_disable = DISABLE;
    uart0_init_parameter.rx_error_dma_stop = DISABLE;
    hal_uart_init(&uart0_info,USART0,&uart0_init_parameter);

    /* user code [usart0_init local 1] begin */
    /* user code [usart0_init local 1] end */
}

void msd_usart0_deinit(void)
{
    /* user code [usart0_deinit local 0] begin */
    /* user code [usart0_deinit local 0] end */
    hal_rcu_periph_clk_disable(RCU_USART0);
    hal_gpio_deinit(GPIOA, GPIO_PIN_9);
    hal_uart_deinit(&uart0_info);
    /* user code [usart0_deinit local 1] begin */
    /* user code [usart0_deinit local 1] end */
}

void msd_usart1_init(void)
{
    /* user code [usart1_init local 0] begin */
    /* user code [usart1_init local 0] end */
    hal_gpio_init_struct gpio_init_parameter;
    hal_uart_init_struct uart1_init_parameter;

    hal_rcu_periph_clk_enable(RCU_USART1);
    hal_gpio_struct_init(&gpio_init_parameter);

    gpio_init_parameter.mode = GPIO_MODE_AF_PP;
    gpio_init_parameter.pull = GPIO_PULL_UP;
    gpio_init_parameter.ospeed = GPIO_OSPEED_50MHZ;
    gpio_init_parameter.af = GPIO_AF_1;
    hal_gpio_init(GPIOA, GPIO_PIN_2, &gpio_init_parameter);

    hal_uart_struct_init(HAL_UART_INIT_STRUCT, &uart1_init_parameter);
    hal_uart_struct_init(HAL_UART_DEV_STRUCT, &uart1_info);

    uart1_init_parameter.work_mode = UART_WORK_MODE_SINGLE_WIRE;
    uart1_init_parameter.baudrate = 115200;
    uart1_init_parameter.parity = UART_PARITY_NONE;
    uart1_init_parameter.word_length = UART_WORD_LENGTH_8BIT;
    uart1_init_parameter.stop_bit = UART_STOP_BIT_1;
    uart1_init_parameter.direction = UART_DIRECTION_RX_TX;
    uart1_init_parameter.over_sample = UART_OVER_SAMPLE_16;
    uart1_init_parameter.sample_method = UART_THREE_SAMPLE_BIT;
    uart1_init_parameter.rx_fifo_en = DISABLE;
    uart1_init_parameter.first_bit_msb = DISABLE;
    uart1_init_parameter.tx_rx_swap = DISABLE;
    uart1_init_parameter.rx_level_invert = DISABLE;
    uart1_init_parameter.tx_level_invert = DISABLE;
    uart1_init_parameter.data_bit_invert = DISABLE;
    uart1_init_parameter.overrun_disable = DISABLE;
    uart1_init_parameter.rx_error_dma_stop = DISABLE;
    hal_uart_init(&uart1_info,USART1,&uart1_init_parameter);

    /* user code [usart1_init local 1] begin */
    /* user code [usart1_init local 1] end */
}

void msd_usart1_deinit(void)
{
    /* user code [usart1_deinit local 0] begin */
    /* user code [usart1_deinit local 0] end */
    hal_rcu_periph_clk_disable(RCU_USART1);
    hal_gpio_deinit(GPIOA, GPIO_PIN_2);
    hal_uart_deinit(&uart1_info);
    /* user code [usart1_deinit local 1] begin */
    /* user code [usart1_deinit local 1] end */
}

/* user code [global 1] begin */

/* user code [global 1] end */
