/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
#include "gd32f3x0r_hal_eval.h"

#define BKP_VALUE  0x5555
hal_rtc_irq_struct  rtc_irq;
void func_c(void *ptr);
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */

    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */

    /* user code [local 1] end */
    msd_gpio_init();
    msd_rtc_init();

    /* user code [local 2] begin */
    gd_eval_com_init(EVAL_COM);
    gd_eval_led_off(LED1);
    gd_eval_led_off(LED2);
    hal_rtc_struct_init(HAL_RTC_IRQ_STRUCT, &rtc_irq);
    rtc_irq.rtc_tamper0_handle = func_c;
    hal_rtc_irq_handle_set(&rtc_info, &rtc_irq);
    hals_rtc_backup_data_write(0, BKP_VALUE);
    /* user code [local 2] end */

    while(1) {
        /* user code [local 3] begin */

        /* user code [local 3] end */
    }
}
/* user code [global 1] begin */
/*!
\brief      tamper interrupt callback
\param[in]  none
\param[out] none
\retval     none
*/
void func_c(void *ptr)
{
    /* if tamper0 event occurs, check if the BKP0 register has been reset or not */
    if(BKP_VALUE != RTC_BKP0) {
        gd_eval_led_toggle(LED1);
        printf("Tamper event detected!\r\n");
    } else {
        gd_eval_led_toggle(LED2);
    }
}
/* user code [global 1] end */
