/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */
    uint16_t ob_data_temp, ob_data_0, ob_data_1 ;
    uint16_t ob_wp_temp, ob_wp_0, ob_wp_1;
    hal_sector_addr_range_struct sector_addr_range;
    ob_parm_struct ob_parm_get;
    hal_ob_parm_config_struct ob_parm_config;
    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */

    /* user code [local 1] end */
    msd_gpio_init();
    msd_usart0_init();

    /* user code [local 2] begin */
    /* enable or disable write protection with address range */
    hal_ob_parm_get(&ob_parm_get);
    printf("################## currently active option byte ##################\r\n");
    printf("currently active security protection level in register OBSTAT is %x\r\n", ob_parm_get.spc);
    printf("currently active OB_USER in register OBSTAT is %x\r\n", ob_parm_get.user);
    printf("currently active OB_DATA in register OBSTAT is %x%x\r\n", ob_parm_get.data0, ob_parm_get.data1);
    printf("currently active OB_WP in register WP is %x%x\r\n", ob_parm_get.wp0, ob_parm_get.wp0);

    /* enable or disable write protection with address range */
    hal_fmc_unlock( );
    hal_ob_unlock( );
    printf("############## actually write protection address range ##############\r\n");
    sector_addr_range = hal_ob_wp_enable(0x8005400, 0x4000);
    printf("actually enable write protection start address %x\r\n", sector_addr_range.sector_start_addr);
    printf("actually enable write protection end address %x\r\n", sector_addr_range.sector_end_addr);
    sector_addr_range = hal_ob_wp_disable(0x8006030, 0x1800);
    printf("actually disable write protection start address %x\r\n", sector_addr_range.sector_start_addr);
    printf("actually disable write protection end address %x\r\n", sector_addr_range.sector_end_addr);

    /* configure option byte parameters thoroughly */
    printf("############# configure option byte parameters thoroughly #############\r\n");
    ob_parm_config.ob_type = OB_TYPE_WP | OB_TYPE_SPC | OB_TYPE_USER | OB_TYPE_DATA;
    ob_parm_config.spc_level = OB_SPC_1;
    ob_parm_config.user = 0x43;
    ob_parm_config.data_value = 0x1234;
    ob_parm_config.wp_addr = 0x8006000;
    ob_parm_config.wp_size = 0x5000;
    ob_parm_config.wp_state = OB_WP_ENABLE;
    hal_ob_parm_config(&ob_parm_config);
    printf("option byte security protection is %x\r\n", OB_SPC);
    printf("option byte user is %x\r\n", OB_USER);
    ob_data_0 = OB_DATA1 << 8U;
    ob_data_1 = OB_DATA0 ;
    ob_data_temp = ob_data_0 | ob_data_1;
    printf("option byte data is %x\r\n", (uint16_t)ob_data_temp);
    ob_wp_0 = OB_WP1 << 8U;
    ob_wp_1 = OB_WP0 ;
    ob_wp_temp = ob_wp_0 | ob_wp_1;
    printf("option byte write protection is %x\r\n", (uint16_t)ob_wp_temp);

    /* recovery option byte to default value */
    hal_fmc_unlock( );
    hal_ob_unlock( );
    hal_ob_erase( );
    hal_ob_lock();
    hal_fmc_lock();
/* user code [local 2] end */

    while(1){
    /* user code [local 3] begin */

    /* user code [local 3] end */
    }
}
/* user code [global 1] begin */
/*!
    \brief      retarget the C library printf function to the USART
    \param[in]  none
    \param[out] none
    \retval     none
*/
#ifdef __GNUC__
/* With GCC, small printf (option LD Linker->Libraries->Small printf
   set to 'Yes') calls __io_putchar() */
#define PUTCHAR_PROTOTYPE int __io_putchar(int ch)
    int __io_putchar(int ch)
    {
        hal_uart_transmit_poll(&uart0_info, (uint8_t*)&ch, 1, 0x1FFFFF);
        return ch;
    }
#else
#define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
    int fputc(int ch, FILE *f)
    {
        hal_uart_transmit_poll(&uart0_info, (uint8_t*)&ch, 1, 0x1FFFFF);
        return ch;
    }
#endif /* __GNUC__ */
/* user code [global 1] end */
