/*
    \file  gd32f3x0_hal_init.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */

/* user code [global 0] end */
hal_cmp_dev_struct cmp0_info;
hal_timer_dev_struct timer0_info;

void msd_system_init(void)
{
    /* user code [system_init local 0] begin */
    /* user code [system_init local 0] end */
    hal_rcu_periph_clk_enable(RCU_CFGCMP);
    hal_nvic_irq_priority_group_set(NVIC_PRIGROUP_PRE4_SUB0);
    hal_sys_timesource_init(SYS_TIMEBASE_SOURCE_SYSTICK);

    hal_nvic_set_priority(NonMaskableInt_IRQn, 0, 0);
    hal_nvic_set_priority(SVCall_IRQn, 0, 0);
    hal_nvic_set_priority(PendSV_IRQn, 0, 0);
    hal_nvic_set_priority(SysTick_IRQn, 0, 0);
    /* user code [system_init local 1] begin */
    /* user code [system_init local 1] end */
}

void msd_clock_init(void)
{
    /* user code [clock_init local 0] begin */
    /* user code [clock_init local 0] end */
    hal_rcu_clk_struct rcu_clk_parameter;
    hal_rcu_osci_struct rcu_osci_parameter;

    hal_rcu_struct_init(HAL_RCU_CLK_STRUCT, &rcu_clk_parameter);
    hal_rcu_struct_init(HAL_RCU_OSCI_STRUCT, &rcu_osci_parameter);

    rcu_osci_parameter.hxtal.need_configure = ENABLE;
    rcu_osci_parameter.hxtal.state = RCU_OSC_ON;
    rcu_osci_parameter.irc8m.need_configure = ENABLE;
    rcu_osci_parameter.irc8m.state = RCU_OSC_ON;
    rcu_osci_parameter.irc8m.adjust_value = 0;
    rcu_osci_parameter.pll.need_configure = ENABLE;
    rcu_osci_parameter.pll.state = RCU_OSC_ON;
    rcu_osci_parameter.pll.pll_source = RCU_PLL_SRC_HXTAL_IRC48M;
    rcu_osci_parameter.pll.pll_mul = RCU_PLL_MULT27;
    rcu_osci_parameter.pll.pll_presel = RCU_PLL_PRESEL_HXTAL;
    rcu_osci_parameter.pll.pre_div = RCU_PLL_PREDIV2;
    if(HAL_ERR_NONE != hal_rcu_osci_config(&rcu_osci_parameter)){
        while(1);
    }

    rcu_clk_parameter.clock_type = RCU_CLKTYPE_SYSCLK | RCU_CLKTYPE_AHBCLK | RCU_CLKTYPE_APB1CLK | RCU_CLKTYPE_APB2CLK | RCU_CLKTYPE_CK48MCLK;
    rcu_clk_parameter.sysclk_source = RCU_SYSCLK_SRC_PLL;
    rcu_clk_parameter.ahbclk_divider = RCU_SYSCLK_AHBDIV1;
    rcu_clk_parameter.apb1clk_divider = RCU_AHBCLK_APB1DIV2;
    rcu_clk_parameter.apb2clk_divider = RCU_AHBCLK_APB2DIV2;
    rcu_clk_parameter.ck48mclk_source = RCU_USB_CK48MSRC_IRC48M;
    if(HAL_ERR_NONE != hal_rcu_clock_config(&rcu_clk_parameter)){
        while(1);
    }

    /* user code [clock_init local 1] begin */
    /* user code [clock_init local 1] end */
}

void msd_gpio_init(void)
{
    /* user code [gpio_init local 0] begin */
    /* user code [gpio_init local 0] end */
    hal_rcu_periph_clk_enable(RCU_GPIOF);
    hal_rcu_periph_clk_enable(RCU_GPIOA);
    /* user code [gpio_init local 1] begin */
    /* user code [gpio_init local 1] end */
}

void msd_gpio_deinit(void)
{
    /* user code [gpio_deinit local 0] begin */
    /* user code [gpio_deinit local 0] end */
    hal_rcu_periph_clk_disable(RCU_GPIOF);
    hal_rcu_periph_clk_disable(RCU_GPIOA);
    /* user code [gpio_deinit local 1] begin */
    /* user code [gpio_deinit local 1] end */
}

void msd_cmp0_init(void)
{
    /* user code [cmp0_init local 0] begin */
    /* user code [cmp0_init local 0] end */
    hal_gpio_init_struct gpio_init_parameter;
    hal_cmp_init_struct cmp0_init_parameter;

    hal_gpio_struct_init(&gpio_init_parameter);

    gpio_init_parameter.mode = GPIO_MODE_ANALOG;
    gpio_init_parameter.pull = GPIO_PULL_NONE;
    gpio_init_parameter.ospeed = GPIO_OSPEED_50MHZ;
    gpio_init_parameter.af = GPIO_AF_0;
    hal_gpio_init(GPIOA, GPIO_PIN_1, &gpio_init_parameter);

    hal_cmp_struct_init(HAL_CMP_INIT_STRUCT, &cmp0_init_parameter);
    hal_cmp_struct_init(HAL_CMP_DEV_STRUCT, &cmp0_info);

    cmp0_init_parameter.noninverting_input = CMP0_IP_PA1;
    cmp0_init_parameter.inverting_input = CMP_INVERTING_INPUT_VREFINT;
    cmp0_init_parameter.mode = CMP_MODE_HIGHSPEED;
    cmp0_init_parameter.polarity = CMP_OUTPUT_POLARITY_NONINVERTED;
    cmp0_init_parameter.hysteresis = CMP_HYSTERESIS_NO;
    cmp0_init_parameter.outputsel = CMP_OUTPUT_TIMER0_IC0;
    cmp0_init_parameter.exti_type = CMP_EXTI_NONE;
    hal_cmp_init(&cmp0_info,CMP0,&cmp0_init_parameter);

    /* user code [cmp0_init local 1] begin */
    /* user code [cmp0_init local 1] end */
}

void msd_cmp0_deinit(void)
{
    /* user code [cmp0_deinit local 0] begin */
    /* user code [cmp0_deinit local 0] end */
    hal_gpio_deinit(GPIOA, GPIO_PIN_1);
    hal_cmp_deinit(&cmp0_info);
    /* user code [cmp0_deinit local 1] begin */
    /* user code [cmp0_deinit local 1] end */
}

void msd_timer0_init(void)
{
    /* user code [timer0_init local 0] begin */
    /* user code [timer0_init local 0] end */
    hal_gpio_init_struct gpio_init_parameter;
    hal_timer_init_struct timer0_init_parameter;
    hal_timer_input_capture_struct timer0_input_capture_parameter;

    hal_rcu_periph_clk_enable(RCU_TIMER0);
    hal_gpio_struct_init(&gpio_init_parameter);

    gpio_init_parameter.mode = GPIO_MODE_AF_PP;
    gpio_init_parameter.pull = GPIO_PULL_NONE;
    gpio_init_parameter.ospeed = GPIO_OSPEED_50MHZ;
    gpio_init_parameter.af = GPIO_AF_2;
    hal_gpio_init(GPIOA, GPIO_PIN_8, &gpio_init_parameter);

    hal_timer_struct_init(HAL_TIMER_INIT_STRUCT, &timer0_init_parameter);
    hal_timer_struct_init(HAL_TIMER_DEV_STRUCT, &timer0_info);
    hal_timer_struct_init(HAL_TIMER_INPUT_CAPTURE_STRUCT, &timer0_input_capture_parameter);

    timer0_init_parameter.prescaler = 107;
    timer0_init_parameter.alignedmode = TIMER_COUNTER_EDGE;
    timer0_init_parameter.counter_direction = TIMER_COUNTER_UP;
    timer0_init_parameter.period = 65535;
    timer0_init_parameter.clock_division = TIMER_CKDIV_DIV1;
    timer0_init_parameter.repetition_counter = 0;
    timer0_init_parameter.autoreload_shadow = TIMER_CARL_SHADOW_DISABLE;
    timer0_init_parameter.master_slave_mode = DISABLE;
    timer0_init_parameter.trgo_selection = TIMER_TRI_OUT_SRC_RESET;
    hal_timer_init(&timer0_info,TIMER0,&timer0_init_parameter);

    timer0_input_capture_parameter.ic_polarity = TIMER_IC_POLARITY_RISING;
    timer0_input_capture_parameter.ic_selection = TIMER_IC_SELECTION_DIRECTTI;
    timer0_input_capture_parameter.ic_prescaler = TIMER_IC_PRESCALER_OFF;
    timer0_input_capture_parameter.ic_filter = 15;
    hal_timer_input_capture_config(&timer0_info,TIMER_CH_0,&timer0_input_capture_parameter);

    /* user code [timer0_init local 1] begin */
    /* user code [timer0_init local 1] end */
}

void msd_timer0_deinit(void)
{
    /* user code [timer0_deinit local 0] begin */
    /* user code [timer0_deinit local 0] end */
    hal_rcu_periph_clk_disable(RCU_TIMER0);
    hal_gpio_deinit(GPIOA, GPIO_PIN_8);
    hal_timer_deinit(&timer0_info);
    /* user code [timer0_deinit local 1] begin */
    /* user code [timer0_deinit local 1] end */
}

/* user code [global 1] begin */

/* user code [global 1] end */
