/*
    \file  gd32f3x0_hal_init.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */

/* user code [global 0] end */
hal_adc_dev_struct adc_info;
hal_timer_dev_struct timer2_info;

void msd_system_init(void)
{
    /* user code [system_init local 0] begin */
    /* user code [system_init local 0] end */
    hal_rcu_periph_clk_enable(RCU_CFGCMP);
    hal_nvic_irq_priority_group_set(NVIC_PRIGROUP_PRE4_SUB0);
    hal_sys_timesource_init(SYS_TIMEBASE_SOURCE_SYSTICK);

    hal_nvic_set_priority(NonMaskableInt_IRQn, 0, 0);
    hal_nvic_set_priority(SVCall_IRQn, 0, 0);
    hal_nvic_set_priority(PendSV_IRQn, 0, 0);
    hal_nvic_set_priority(SysTick_IRQn, 0, 0);
    /* user code [system_init local 1] begin */
    /* user code [system_init local 1] end */
}

void msd_clock_init(void)
{
    /* user code [clock_init local 0] begin */
    /* user code [clock_init local 0] end */
    hal_rcu_clk_struct rcu_clk_parameter;
    hal_rcu_osci_struct rcu_osci_parameter;
    hal_rcu_periphclk_struct rcu_periphclk_parameter;

    hal_rcu_struct_init(HAL_RCU_CLK_STRUCT, &rcu_clk_parameter);
    hal_rcu_struct_init(HAL_RCU_OSCI_STRUCT, &rcu_osci_parameter);
    hal_rcu_struct_init(HAL_RCU_PERIPHCLK_STRUCT, &rcu_periphclk_parameter);

    rcu_osci_parameter.irc8m.need_configure = ENABLE;
    rcu_osci_parameter.irc8m.state = RCU_OSC_ON;
    rcu_osci_parameter.irc8m.adjust_value = 0;
    /*If IRC48M is selected as USB clock source, please configure CTC calibration operation*/
    rcu_osci_parameter.irc48m.need_configure = ENABLE;
    rcu_osci_parameter.irc48m.state = RCU_OSC_ON;
    rcu_osci_parameter.pll.need_configure = ENABLE;
    rcu_osci_parameter.pll.state = RCU_OSC_ON;
    rcu_osci_parameter.pll.pll_source = RCU_PLL_SRC_IRC8M_DIV2;
    rcu_osci_parameter.pll.pll_mul = RCU_PLL_MULT27;
    rcu_osci_parameter.pll.pll_presel = RCU_PLL_PRESEL_IRC48M;
    if(HAL_ERR_NONE != hal_rcu_osci_config(&rcu_osci_parameter)){
        while(1);
    }

    rcu_clk_parameter.clock_type = RCU_CLKTYPE_SYSCLK | RCU_CLKTYPE_AHBCLK | RCU_CLKTYPE_APB1CLK | RCU_CLKTYPE_APB2CLK | RCU_CLKTYPE_CK48MCLK;
    rcu_clk_parameter.sysclk_source = RCU_SYSCLK_SRC_PLL;
    rcu_clk_parameter.ahbclk_divider = RCU_SYSCLK_AHBDIV1;
    rcu_clk_parameter.apb1clk_divider = RCU_AHBCLK_APB1DIV2;
    rcu_clk_parameter.apb2clk_divider = RCU_AHBCLK_APB2DIV2;
    rcu_clk_parameter.ck48mclk_source = RCU_USB_CK48MSRC_IRC48M;
    if(HAL_ERR_NONE != hal_rcu_clock_config(&rcu_clk_parameter)){
        while(1);
    }

    rcu_periphclk_parameter.periph_clock_type = RCU_PERIPH_CLKTYPE_ADC;
    rcu_periphclk_parameter.adc_clock_source = RCU_ADCCK_APB2_DIV6;
    if(HAL_ERR_NONE != hal_rcu_periph_clock_config(&rcu_periphclk_parameter)){
        while(1);
    }

    /* user code [clock_init local 1] begin */
    /* user code [clock_init local 1] end */
}

void msd_gpio_init(void)
{
    /* user code [gpio_init local 0] begin */
    /* user code [gpio_init local 0] end */
    hal_rcu_periph_clk_enable(RCU_GPIOA);
    /* user code [gpio_init local 1] begin */
    /* user code [gpio_init local 1] end */
}

void msd_gpio_deinit(void)
{
    /* user code [gpio_deinit local 0] begin */
    /* user code [gpio_deinit local 0] end */
    hal_rcu_periph_clk_disable(RCU_GPIOA);
    /* user code [gpio_deinit local 1] begin */
    /* user code [gpio_deinit local 1] end */
}

void msd_adc_init(void)
{
    /* user code [adc_init local 0] begin */
    /* user code [adc_init local 0] end */
    hal_gpio_init_struct gpio_init_parameter;
    hal_adc_init_struct adc_init_parameter;
    hal_adc_inserted_config_struct adc_inserted_config_parameter;
    hal_adc_inserted_rank_config_struct adc_inserted_rank_config_parameter;

    hal_rcu_periph_clk_enable(RCU_ADC);
    hal_gpio_struct_init(&gpio_init_parameter);

    gpio_init_parameter.mode = GPIO_MODE_ANALOG;
    gpio_init_parameter.pull = GPIO_PULL_NONE;
    gpio_init_parameter.ospeed = GPIO_OSPEED_50MHZ;
    gpio_init_parameter.af = GPIO_AF_0;
    hal_gpio_init(GPIOA, GPIO_PIN_2, &gpio_init_parameter);

    hal_adc_struct_init(HAL_ADC_INIT_STRUCT, &adc_init_parameter);
    hal_adc_struct_init(HAL_ADC_DEV_STRUCT, &adc_info);
    hal_adc_struct_init(HAL_ADC_INSERTED_CONFIG_STRUCT, &adc_inserted_config_parameter);
    hal_adc_struct_init(HAL_ADC_INSERTED_RANK_CONFIG_STRUCT, &adc_inserted_rank_config_parameter);

    adc_init_parameter.data_alignment = ADC_LSB_ALIGNMENT;
    adc_init_parameter.resolution = ADC_RESOLUTION_12B;
    adc_init_parameter.scan_mode = DISABLE;
    adc_init_parameter.hardware_oversampling = DISABLE;
    hal_adc_init(&adc_info,&adc_init_parameter);

    adc_inserted_config_parameter.inserted_sequence_conversions = ENABLE;
    adc_inserted_config_parameter.inserted_sequence_length = 1;
    adc_inserted_config_parameter.inserted_sequence_external_trigger_select = ADC_EXTTRIG_INSERTED_T2_CH3;
    adc_inserted_config_parameter.discontinuous_mode = DISABLE;
    adc_inserted_config_parameter.auto_convert = DISABLE;
    hal_adc_inserted_channel_config(&adc_info,&adc_inserted_config_parameter);

    adc_inserted_rank_config_parameter.data_offset = 0;
    adc_inserted_rank_config_parameter.channel = ADC_CHANNEL_2;
    adc_inserted_rank_config_parameter.sampling_time = ADC_SAMPLETIME_1POINT5;
    adc_inserted_rank_config_parameter.inserted_sequence = ADC_INSERTED_SEQUENCE_0;
    hal_adc_inserted_rank_config(&adc_info,&adc_inserted_rank_config_parameter);

    /* user code [adc_init local 1] begin */
    /* user code [adc_init local 1] end */
}

void msd_adc_deinit(void)
{
    /* user code [adc_deinit local 0] begin */
    /* user code [adc_deinit local 0] end */
    hal_rcu_periph_clk_disable(RCU_ADC);
    hal_gpio_deinit(GPIOA, GPIO_PIN_2);
    hal_adc_deinit(&adc_info);
    /* user code [adc_deinit local 1] begin */
    /* user code [adc_deinit local 1] end */
}

void msd_timer2_init(void)
{
    /* user code [timer2_init local 0] begin */
    /* user code [timer2_init local 0] end */
    hal_timer_init_struct timer2_init_parameter;
    hal_timer_clock_source_struct timer2_clock_source_parameter;
    hal_timer_output_compare_struct timer2_output_compare_parameter;

    hal_rcu_periph_clk_enable(RCU_TIMER2);
    hal_timer_struct_init(HAL_TIMER_INIT_STRUCT, &timer2_init_parameter);
    hal_timer_struct_init(HAL_TIMER_DEV_STRUCT, &timer2_info);
    hal_timer_struct_init(HAL_TIMER_CLOCK_SOURCE_STRUCT, &timer2_clock_source_parameter);
    hal_timer_struct_init(HAL_TIMER_OUTPUT_COMPARE_STRUCT, &timer2_output_compare_parameter);

    timer2_init_parameter.prescaler = 71;
    timer2_init_parameter.alignedmode = TIMER_COUNTER_EDGE;
    timer2_init_parameter.counter_direction = TIMER_COUNTER_UP;
    timer2_init_parameter.period = 9999;
    timer2_init_parameter.clock_division = TIMER_CKDIV_DIV1;
    timer2_init_parameter.autoreload_shadow = TIMER_CARL_SHADOW_DISABLE;
    timer2_init_parameter.master_slave_mode = DISABLE;
    timer2_init_parameter.trgo_selection = TIMER_TRI_OUT_SRC_RESET;
    hal_timer_init(&timer2_info,TIMER2,&timer2_init_parameter);

    timer2_clock_source_parameter.clock_source = TIMER_CLOCK_SOURCE_CK_TIMER;
    hal_timer_clock_source_config(&timer2_info,&timer2_clock_source_parameter);

    timer2_output_compare_parameter.compare_mode = TIMER_OC_MODE_PWM1;
    timer2_output_compare_parameter.oc_pulse_value = 5000;
    timer2_output_compare_parameter.oc_polarity = TIMER_OC_POLARITY_HIGH;
    timer2_output_compare_parameter.oc_shadow = TIMER_OC_SHADOW_DISABLE;
    timer2_output_compare_parameter.oc_fastmode = TIMER_OC_FAST_DISABLE;
    timer2_output_compare_parameter.oc_clearmode = TIMER_OC_CLEAR_DISABLE;
    hal_timer_output_compare_config(&timer2_info,TIMER_CH_3,&timer2_output_compare_parameter);

    /* user code [timer2_init local 1] begin */
    /* user code [timer2_init local 1] end */
}

void msd_timer2_deinit(void)
{
    /* user code [timer2_deinit local 0] begin */
    /* user code [timer2_deinit local 0] end */
    hal_rcu_periph_clk_disable(RCU_TIMER2);
    hal_timer_deinit(&timer2_info);
    /* user code [timer2_deinit local 1] begin */
    /* user code [timer2_deinit local 1] end */
}

/* user code [global 1] begin */

/* user code [global 1] end */
