/*
    \file  gd32c2x1_init.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32c2x1_init.h"

/* External Includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */
volatile static uint32_t delay;
/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      SYSTEM initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_system_init(void)
{
    /* user code [system_init local 0] begin */

    /* user code [system_init local 0] end */

    rcu_periph_clock_enable(RCU_SYSCFG);

    nvic_irq_enable(NonMaskableInt_IRQn, 0);
    nvic_irq_enable(HardFault_IRQn, 0);
    nvic_irq_enable(SVCall_IRQn, 0);
    nvic_irq_enable(PendSV_IRQn, 0);
    nvic_irq_enable(SysTick_IRQn, 0);

    /* user code [system_init local 1] begin */

    /* user code [system_init local 1] end */
}

/*!
    \brief      CLOCK initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_clock_init(void)
{
    /* user code [clock_init local 0] begin */

    /* user code [clock_init local 0] end */

    rcu_osci_on(RCU_IRC48M);
    while (rcu_osci_stab_wait(RCU_IRC48M) != SUCCESS);
    rcu_irc48m_adjust_value_set(16);

    fmc_wscnt_set(FMC_WAIT_STATE_1);
    rcu_ahb_clock_config(RCU_AHB_CKSYS_DIV1);
    rcu_apb_clock_config(RCU_APB_CKAHB_DIV1);

    rcu_irc48mdiv_sys_clock_config(RCU_IRC48MDIV_SYS_1);
    rcu_system_clock_source_config(RCU_CKSYSSRC_IRC48MDIV_SYS);
    while (RCU_SCSS_IRC48MDIV != rcu_system_clock_source_get());

    rcu_usart_clock_config(IDX_USART0, RCU_USART0SRC_CKAPB);

    rcu_i2c_clock_config(IDX_I2C1, RCU_I2CSRC_CKAPB);

    /* update SystemCoreClock value */
    SystemCoreClockUpdate();

    /* setup systick timer for 1000Hz interrupts */
    if (SysTick_Config(SystemCoreClock / 1000U))
    {
        /* capture error */
        while (1);
    }

    systick_clksource_set(SYSTICK_CLKSOURCE_HCLK);

    /* user code [clock_init local 1] begin */

    /* user code [clock_init local 1] end */
}

/*!
    \brief      GPIO initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_init(void)
{
    /* user code [gpio_init local 0] begin */

    /* user code [gpio_init local 0] end */

    rcu_periph_clock_enable(RCU_GPIOB);
    rcu_periph_clock_enable(RCU_GPIOA);

    /* user code [gpio_init local 1] begin */

    /* user code [gpio_init local 1] end */
}

/*!
    \brief      GPIO deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_gpio_deinit(void)
{
    /* user code [gpio_deinit local 0] begin */

    /* user code [gpio_deinit local 0] end */

    rcu_periph_clock_disable(RCU_GPIOB);
    rcu_periph_clock_disable(RCU_GPIOA);

    /* user code [gpio_deinit local 1] begin */

    /* user code [gpio_deinit local 1] end */
}

/*!
    \brief      I2C1 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_i2c1_init(void)
{
    /* user code [i2c1_init local 0] begin */

    /* user code [i2c1_init local 0] end */

    rcu_periph_clock_enable(RCU_I2C1);

    gpio_af_set(GPIOB, GPIO_AF_6, GPIO_PIN_10);
    gpio_mode_set(GPIOB, GPIO_MODE_AF, GPIO_PUPD_PULLUP, GPIO_PIN_10);
    gpio_output_options_set(GPIOB, GPIO_OTYPE_OD, GPIO_OSPEED_LEVEL_1, GPIO_PIN_10);

    gpio_af_set(GPIOB, GPIO_AF_6, GPIO_PIN_11);
    gpio_mode_set(GPIOB, GPIO_MODE_AF, GPIO_PUPD_PULLUP, GPIO_PIN_11);
    gpio_output_options_set(GPIOB, GPIO_OTYPE_OD, GPIO_OSPEED_LEVEL_1, GPIO_PIN_11);

    i2c_digital_noise_filter_config(I2C1, FILTER_DISABLE);
    i2c_analog_noise_filter_disable(I2C1);
    i2c_timing_config(I2C1, 0x00, 0x03, 0x00);
    i2c_master_clock_config(I2C1, 0x13, 0x36);
    i2c_stretch_scl_low_enable(I2C1);
    i2c_address10_enable(I2C1);
    i2c_address_config(I2C1, 0x322, I2C_ADDFORMAT_10BITS);
    i2c_second_address_disable(I2C1);
    i2c_slave_response_to_gcall_disable(I2C1);
    i2c_enable(I2C1);

    /* user code [i2c1_init local 1] begin */
    /* configure slave address */
    i2c_master_addressing(I2C1, 0x322, I2C_MASTER_RECEIVE);
    i2c_transfer_byte_number_config(I2C1, 16);

    /* user code [i2c1_init local 1] end */
}

/*!
    \brief      I2C1 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_i2c1_deinit(void)
{
    /* user code [i2c1_deinit local 0] begin */

    /* user code [i2c1_deinit local 0] end */
    i2c_deinit(I2C1);

    rcu_periph_clock_disable(RCU_I2C1);

    /* user code [i2c1_deinit local 1] begin */

    /* user code [i2c1_deinit local 1] end */
}

/*!
    \brief      USART0 initialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_init(void)
{
    /* user code [usart0_init local 0] begin */

    /* user code [usart0_init local 0] end */

    rcu_periph_clock_enable(RCU_USART0);

    gpio_af_set(GPIOA, GPIO_AF_1, GPIO_PIN_10);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_10);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_10);

    gpio_af_set(GPIOA, GPIO_AF_1, GPIO_PIN_9);
    gpio_mode_set(GPIOA, GPIO_MODE_AF, GPIO_PUPD_NONE, GPIO_PIN_9);
    gpio_output_options_set(GPIOA, GPIO_OTYPE_PP, GPIO_OSPEED_LEVEL_0, GPIO_PIN_9);

    usart_baudrate_set(USART0, 115200);
    usart_word_length_set(USART0, USART_WL_8BIT);
    usart_parity_config(USART0, USART_PM_NONE);
    usart_stop_bit_set(USART0, USART_STB_1BIT);
    usart_receive_config(USART0, USART_RECEIVE_ENABLE);
    usart_transmit_config(USART0, USART_TRANSMIT_ENABLE);
    usart_oversample_config(USART0, USART_OVSMOD_16);
    usart_sample_bit_config(USART0, USART_OSB_3BIT);
    usart_overrun_enable(USART0);
    usart_reception_error_dma_enable(USART0);
    usart_data_first_config(USART0, USART_MSBF_LSB);
    usart_invert_config(USART0, USART_TXPIN_DISABLE);
    usart_invert_config(USART0, USART_RXPIN_DISABLE);
    usart_invert_config(USART0, USART_DINV_DISABLE);
    usart_invert_config(USART0, USART_SWAP_DISABLE);
    usart_enable(USART0);

    /* user code [usart0_init local 1] begin */

    /* user code [usart0_init local 1] end */
}

/*!
    \brief      USART0 deinitialization function
    \param[in]  none
    \param[out] none
    \retval     none
*/
void msd_usart0_deinit(void)
{
    /* user code [usart0_deinit local 0] begin */

    /* user code [usart0_deinit local 0] end */
    usart_deinit(USART0);

    rcu_periph_clock_disable(RCU_USART0);

    /* user code [usart0_deinit local 1] begin */

    /* user code [usart0_deinit local 1] end */
}

/* user code [Public Functions Implementations] begin */
/*!
    \brief      delay a time in milliseconds
    \param[in]  count: count in milliseconds
    \param[out] none
    \retval     none
*/
void delay_1ms(uint32_t count)
{
    delay = count;
    while (0U != delay) {}
}
/*!
    \brief      delay decrement
    \param[in]  none
    \param[out] none
    \retval     none
*/
void delay_decrement(void)
{
    if (0U != delay)
    {
        delay--;
    }
}
/* user code [Public Functions Implementations] end */

/* user code [Private Functions Implementations] begin */

/* user code [Private Functions Implementations] end */
