/*
    \file  main.c
*/
/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32c2x1.h"
#include "gd32c2x1_init.h"

/* External Includes*/
/* user code [External Includes] begin */
#include <stdio.h>
/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
    #define __CLANG_ARM
#endif

#if defined(__CC_ARM) || defined(__CLANG_ARM) /* For ARM compiler */
    #define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
#elif defined(__GNUC__) && !defined(__clang__) /* For GNU GCC compiler */
    #define PUTCHAR_PROTOTYPE int __io_putchar(int ch)
#else
    #error Not supported toolchain
#endif
/* user code [Private Type Definitions] end */

/* Private Macros */
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */
__IO uint16_t adc_value[8];
/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */
void dma_channel_address_size_config(dma_channel_enum channelx, uint32_t periph_addr, uint32_t memory_addr, \
                                     uint32_t size);
/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */

    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();

    /* user code [local 1] begin */

    /* user code [local 1] end */


    msd_gpio_init();
    msd_dma_init();
    msd_adc_init();
    msd_usart0_init();

    /* user code [local 2] begin */
    dma_channel_address_size_config(DMA_CH0, (uint32_t)(&ADC_RDATA), (uint32_t)(&adc_value), 5);
    adc_dma_mode_enable();

    /* enable ADC interface */
    adc_enable();
    delay_1ms(1U);

    /* enable DMA transfer complete interrupt */
    dma_interrupt_enable(DMA_CH0, DMA_INT_FTF);

    printf("\r /**** ADC Demo ****/\r\n");
    /* user code [local 2] end */

    while(1){
        /* user code [local 3] begin */
        /* ADC software trigger enable */
        adc_software_trigger_enable(ADC_ROUTINE_CHANNEL);
        delay_1ms(1000);
        printf("\r\n ***********************************\r\n");
        printf("\r\n ADC routine channel data 0, PA0 = %04X \r\n", adc_value[0]);
        printf("\r\n ADC routine channel data 1, PA1 = %04X \r\n", adc_value[1]);
        printf("\r\n ADC routine channel data 2, PA4 = %04X \r\n", adc_value[2]);
        printf("\r\n ADC routine channel data 3, PA5 = %04X \r\n", adc_value[3]);
        printf("\r\n ADC routine channel data 4, PA6 = %04X \r\n", adc_value[4]);
        printf("\r\n ***********************************\r\n");
        /* user code [local 3] end */
    }
}

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Function Implementations] begin */
/*!
    \brief      configure dma info
    \param[in]  channelx: DMA channel
    \param[in]  periph_addr: specify which DMA channel to set peripheral base address
    \param[in]  memory_addr: specify which DMA channel to set memory base address
    \param[in]  size: the size of remaining data to be transferred by the DMA
    \param[out] none
    \retval     none
*/
void dma_channel_address_size_config(dma_channel_enum channelx, uint32_t periph_addr, uint32_t memory_addr, \
                                     uint32_t size)
{
    /* disable dma channel */
    dma_channel_disable(channelx);
    /* configure DMA peripheral base address */
    dma_periph_address_config(channelx, periph_addr);
    /* configure DMA memory base address */
    dma_memory_address_config(channelx, memory_addr);
    /* configure the number of remaining data to be transferred by the DMA */
    dma_transfer_number_config(channelx, size);

    /* enable dma channel */
    dma_channel_enable(channelx);
}

/*!
    \brief retarget the C library printf function to the USART
    \param[in]  ch: The character to be transmitted via USART.
    \param[in]  f: A standard C library file pointer, not actually used in this function.
    \param[out] none
    \retval     The character to be transmitted via USART.
*/
PUTCHAR_PROTOTYPE
{
    usart_data_transmit(USART0, (uint8_t)ch);

    while(RESET == usart_flag_get(USART0, USART_FLAG_TBE));

    return ch;
}
/* user code [Private Function Implementations] end */
