/*!
    \file    gd32f50x_libopt.h
    \brief   library optional for gd32f50x

    \version 2025-11-10, V1.0.1, firmware for GD32F50x
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/

#ifndef GD32F50X_LIBOPT_H
#define GD32F50X_LIBOPT_H

#include "gd32f50x_adc.h"
#include "gd32f50x_bkp.h"
#include "gd32f50x_can.h"
#include "gd32f50x_cau.h"
#include "gd32f50x_cmp.h"
#include "gd32f50x_crc.h"
#include "gd32f50x_ctc.h"
#include "gd32f50x_dac.h"
#include "gd32f50x_dbg.h"
#include "gd32f50x_dma.h"
#include "gd32f50x_exmc.h"
#include "gd32f50x_exti.h"
#include "gd32f50x_fmc.h"
#include "gd32f50x_fwdgt.h"
#include "gd32f50x_gpio.h"
#include "gd32f50x_hau.h"
#include "gd32f50x_i2c.h"
#include "gd32f50x_misc.h"
#include "gd32f50x_pmu.h"
#include "gd32f50x_rcu.h"
#include "gd32f50x_rtc.h"
#include "gd32f50x_spi.h"
#include "gd32f50x_syscfg.h"
#include "gd32f50x_timer.h"
#include "gd32f50x_trigsel.h"
#include "gd32f50x_trng.h"
#include "gd32f50x_usart.h"
#include "gd32f50x_wwdgt.h"

#endif /* GD32F50X_LIBOPT_H */
