/*!
    \file    gd32e502_libopt.h
    \brief   library optional for gd32e502

     \version 2025-08-09, V1.6.0, firmware for GD32E502
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef GD32E502_LIBOPT_H
#define GD32E502_LIBOPT_H

#include "gd32e502_adc.h"
#include "gd32e502_bkp.h"
#include "gd32e502_can.h"
#include "gd32e502_cmp.h"
#include "gd32e502_crc.h"
#include "gd32e502_dac.h"
#include "gd32e502_dbg.h"
#include "gd32e502_dma.h"
#include "gd32e502_exti.h"
#include "gd32e502_fmc.h"
#include "gd32e502_fwdgt.h"
#include "gd32e502_gpio.h"
#include "gd32e502_i2c.h"
#include "gd32e502_mfcom.h"
#include "gd32e502_misc.h"
#include "gd32e502_pmu.h"
#include "gd32e502_rcu.h"
#include "gd32e502_spi.h"
#include "gd32e502_syscfg.h"
#include "gd32e502_timer.h"
#include "gd32e502_trigsel.h"
#include "gd32e502_usart.h"
#include "gd32e502_wwdgt.h"
#include "gd32e502_rtc.h"

#endif /* GD32E502_LIBOPT_H */
