/*!
    \file    gd32c2x1_libopt.h
    \brief   library optional for gd32c2x1

    \version 2025-10-28, V2.0.2, firmware for gd32c2x1
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef GD32C2X1_LIBOPT_H
#define GD32C2X1_LIBOPT_H

#include "gd32c2x1_adc.h"
#include "gd32c2x1_cmp.h"
#include "gd32c2x1_crc.h"
#include "gd32c2x1_dbg.h"
#include "gd32c2x1_dma.h"
#include "gd32c2x1_exti.h"
#include "gd32c2x1_fmc.h"
#include "gd32c2x1_fwdgt.h"
#include "gd32c2x1_gpio.h"
#include "gd32c2x1_i2c.h"
#include "gd32c2x1_misc.h"
#include "gd32c2x1_pmu.h"
#include "gd32c2x1_rcu.h"
#include "gd32c2x1_rtc.h"
#include "gd32c2x1_spi.h"
#include "gd32c2x1_syscfg.h"
#include "gd32c2x1_timer.h"
#include "gd32c2x1_usart.h"
#include "gd32c2x1_wwdgt.h"
#include "gd32c2x1_err_report.h"

#endif /* gd32c2x1_LIBOPT_H */
