[#ftl]
/*!
    \file    main.h
    \brief   the header file of main

    \version 2024-09-01, V1.0.0, HAL firmware for GD32H7xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef MAIN_H
#define MAIN_H

#include "gd32h7xx_hal.h"
#include "netif.h"
#include "stdint.h"

[#if Peripherals?contains("ENET0") == true]
/* MAC address: BOARD0_MAC_ADDR0:BOARD0_MAC_ADDR1:BOARD0_MAC_ADDR2:BOARD0_MAC_ADDR3:BOARD0_MAC_ADDR4:BOARD0_MAC_ADDR5 */
#define BOARD0_MAC_ADDR0   0x${ENET0_GeneralConfiguration_MACAddress_1}
#define BOARD0_MAC_ADDR1   0x${ENET0_GeneralConfiguration_MACAddress_2}
#define BOARD0_MAC_ADDR2   0x${ENET0_GeneralConfiguration_MACAddress_3}
#define BOARD0_MAC_ADDR3   0x${ENET0_GeneralConfiguration_MACAddress_4}
#define BOARD0_MAC_ADDR4   0x${ENET0_GeneralConfiguration_MACAddress_5}
#define BOARD0_MAC_ADDR5   0x${ENET0_GeneralConfiguration_MACAddress_6}

/* remote IP address: BOARD0_IP_S_ADDR0.BOARD0_IP_S_ADDR1.BOARD0_IP_S_ADDR2.BOARD0_IP_S_ADDR3 */
#define BOARD0_IP_S_ADDR0   10
#define BOARD0_IP_S_ADDR1   50
#define BOARD0_IP_S_ADDR2   3
#define BOARD0_IP_S_ADDR3   140

[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPDHCP == "Disable"]
/* static IP address: BOARD0_IP_ADDR0.BOARD0_IP_ADDR1.BOARD0_IP_ADDR2.BOARD0_IP_ADDR3 */
#define BOARD0_IP_ADDR0   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration0_IP0Address_1}
#define BOARD0_IP_ADDR1   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration0_IP0Address_2}
#define BOARD0_IP_ADDR2   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration0_IP0Address_3}
#define BOARD0_IP_ADDR3   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration0_IP0Address_4}

/* net mask */
#define BOARD0_NETMASK_ADDR0   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration0_Netmask0Address_1}
#define BOARD0_NETMASK_ADDR1   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration0_Netmask0Address_2}
#define BOARD0_NETMASK_ADDR2   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration0_Netmask0Address_3}
#define BOARD0_NETMASK_ADDR3   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration0_Netmask0Address_4}

/* gateway address */
#define BOARD0_GW_ADDR0   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration0_Gateway0Address_1}
#define BOARD0_GW_ADDR1   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration0_Gateway0Address_2}
#define BOARD0_GW_ADDR2   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration0_Gateway0Address_3}
#define BOARD0_GW_ADDR3   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration0_Gateway0Address_4}
[/#if]

[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPDHCP == "Enable"]
/* static IP address: BOARD0_IP_ADDR0.BOARD0_IP_ADDR1.BOARD0_IP_ADDR2.BOARD0_IP_ADDR3 */
#define BOARD0_IP_ADDR0   10
#define BOARD0_IP_ADDR1   50
#define BOARD0_IP_ADDR2   3
#define BOARD0_IP_ADDR3   210

/* net mask */
#define BOARD0_NETMASK_ADDR0   255
#define BOARD0_NETMASK_ADDR1   255
#define BOARD0_NETMASK_ADDR2   255
#define BOARD0_NETMASK_ADDR3   0

/* gateway address */
#define BOARD0_GW_ADDR0   10
#define BOARD0_GW_ADDR1   50
#define BOARD0_GW_ADDR2   3
#define BOARD0_GW_ADDR3   1
[/#if]
[/#if]
[#if Peripherals?contains("ENET1") == true]
/* MAC address: BOARD1_MAC_ADDR1:BOARD1_MAC_ADDR1:BOARD1_MAC_ADDR2:BOARD1_MAC_ADDR3:BOARD1_MAC_ADDR4:BOARD1_MAC_ADDR5 */
#define BOARD1_MAC_ADDR0   0x${ENET1_GeneralConfiguration_MACAddress_1}
#define BOARD1_MAC_ADDR1   0x${ENET1_GeneralConfiguration_MACAddress_2}
#define BOARD1_MAC_ADDR2   0x${ENET1_GeneralConfiguration_MACAddress_3}
#define BOARD1_MAC_ADDR3   0x${ENET1_GeneralConfiguration_MACAddress_4}
#define BOARD1_MAC_ADDR4   0x${ENET1_GeneralConfiguration_MACAddress_5}
#define BOARD1_MAC_ADDR5   0x${ENET1_GeneralConfiguration_MACAddress_6}

/* remote IP address: BOARD1_IP_S_ADDR1.BOARD1_IP_S_ADDR1.BOARD1_IP_S_ADDR2.BOARD1_IP_S_ADDR3 */
#define BOARD1_IP_S_ADDR0   10
#define BOARD1_IP_S_ADDR1   50
#define BOARD1_IP_S_ADDR2   3
#define BOARD1_IP_S_ADDR3   144

[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPDHCP == "Disable"]
/* static IP address: BOARD1_IP_ADDR0.BOARD1_IP_ADDR1.BOARD1_IP_ADDR2.BOARD1_IP_ADDR3 */
#define BOARD1_IP_ADDR0   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration1_IP1Address_1}
#define BOARD1_IP_ADDR1   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration1_IP1Address_2}
#define BOARD1_IP_ADDR2   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration1_IP1Address_3}
#define BOARD1_IP_ADDR3   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration1_IP1Address_4}

/* net mask */
#define BOARD1_NETMASK_ADDR0   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration1_Netmask1Address_1}
#define BOARD1_NETMASK_ADDR1   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration1_Netmask1Address_2}
#define BOARD1_NETMASK_ADDR2   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration1_Netmask1Address_3}
#define BOARD1_NETMASK_ADDR3   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration1_Netmask1Address_4}

/* gateway address */
#define BOARD1_GW_ADDR0   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration1_Gateway1Address_1}
#define BOARD1_GW_ADDR1   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration1_Gateway1Address_2}
#define BOARD1_GW_ADDR2   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration1_Gateway1Address_3}
#define BOARD1_GW_ADDR3   ${LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration1_Gateway1Address_4}
[/#if]
[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPDHCP == "Enable"]
/* static IP address: BOARD1_IP_ADDR0.BOARD1_IP_ADDR1.BOARD1_IP_ADDR2.BOARD1_IP_ADDR3 */
#define BOARD1_IP_ADDR0   10
#define BOARD1_IP_ADDR1   50
#define BOARD1_IP_ADDR2   3
#define BOARD1_IP_ADDR3   180

/* net mask */
#define BOARD1_NETMASK_ADDR0   255
#define BOARD1_NETMASK_ADDR1   255
#define BOARD1_NETMASK_ADDR2   255
#define BOARD1_NETMASK_ADDR3   0

/* gateway address */
#define BOARD1_GW_ADDR0   10
#define BOARD1_GW_ADDR1   50
#define BOARD1_GW_ADDR2   3
#define BOARD1_GW_ADDR3   6
[/#if]
[/#if]

/* function declarations */
/* updates the system local time */
void time_update(void);
/* insert a delay time */
void delay_10ms(uint32_t ncount);

#endif /* MAIN_H */
