[#ftl]
/*!
    \file    fs_usbh_conf.h
    \brief   USB host driver configuration

    \version 2025-07-30, V1.0.0, firmware for GD32F5xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef __FS_USBH_CONF_H
#define __FS_USBH_CONF_H

#include "fs_usb_conf.h"
#include "gd32f527_init.h"

extern uint32_t fs_usbh_irq (void);
extern void fs_usbhs_wakeup_irq(void);

#define FS_HOST_MAX_EP_NUM                         ${USBFS_HOST_Mode_MassStorageClassParametersConfiguration_HostMaximumEndpointNumber}
#define FS_HOST_MAX_INTERFACES_NUM                 ${USBFS_HOST_Mode_MassStorageClassParametersConfiguration_HostMaximumInterfaceNumber}
#define FS_HOST_MAX_ALT_SETTING                    ${USBFS_HOST_Mode_MassStorageClassParametersConfiguration_HostMaximumAlternateSetting}
#define FS_HOST_MAX_SUPPORTED_CLASS                ${USBFS_HOST_Mode_MassStorageClassParametersConfiguration_HostMaximumSupportedClass}
[#if USBFS_HOST_Mode_MassStorageClassParametersConfiguration_HostConfigureDescriptorKeep == "Enable"]
#define FS_HOST_CFG_DESC_KEEP                      ENABLE
[#else]
#define FS_HOST_CFG_DESC_KEEP                      DISABLE
[/#if]
#define FS_HOST_DATA_BUF_MAX_LEN                   ${USBFS_HOST_Mode_MassStorageClassParametersConfiguration_HostDataBufferMaximumLength}
#define FS_HOST_CFGSET_MAX_LEN                     ${USBFS_HOST_Mode_MassStorageClassParametersConfiguration_HostConfigureSetMaximumLength}
[#if USBFS_HOST_Mode_MassStorageClassParametersConfiguration_HostUserDebugLog == "Enable"]
#define FS_HOST_USER_DEBUG_LOG                     ENABLE
[#else]
#define FS_HOST_USER_DEBUG_LOG                     DISABLE
[/#if]

[#if USBFS_USBFSHost_SOFSignalOutput ??==true]
[#if USBFS_USBFSHost_SOFSignalOutput == "Enable"]
#define FS_USB_SOF_OUTPUT                          ENABLE
[#elseif USBFS_USBFSHost_SOFSignalOutput == "Disable"]
#define FS_USB_SOF_OUTPUT                          DISABLE
[/#if]
[/#if]
[#if USBFS_USBFSDevice_LowPowerMode ??==true]
[#if USBFS_USBFSDevice_LowPowerMode == "Enable"]
#define FS_USB_LOW_POWER                           ENABLE
[#else]
#define FS_USB_LOW_POWER                           DISABLE
[/#if]
[/#if]

[#if USBFS_HostFIFOSize_AllocatedRXFIFOSize ??==true]
#define FS_RX_FIFO_SIZE                            ${USBFS_HostFIFOSize_AllocatedRXFIFOSize}
[#else]
#define FS_RX_FIFO_SIZE                            512
[/#if]
[#if USBFS_HostFIFOSize_AllocatedPeriodicTXFIFOSize ??==true]
#define FS_USB_HTX_PFIFO_SIZE                      ${USBFS_HostFIFOSize_AllocatedPeriodicTXFIFOSize}
[#else]
#define FS_USB_HTX_PFIFO_SIZE                      256
[/#if]
[#if USBFS_HostFIFOSize_AllocatedNonperiodicTXFIFOSize ??==true]
#define FS_USB_HTX_NPFIFO_SIZE                     ${USBFS_HostFIFOSize_AllocatedNonperiodicTXFIFOSize}
[#else]
#define FS_USB_HTX_NPFIFO_SIZE                     256
[/#if]
[#if USBFS_GeneralConfiguration_InternalDMA ??== true && USBFS_GeneralConfiguration_InternalDMA == "Enable"]
#define FS_USB_INTERNAL_DMA_ENABLED
[/#if]

#if (ENABLE == FS_HOST_USER_DEBUG_LOG)
#define User_Debug_Log(...) do { \
                                 \
                                 printf(__VA_ARGS__);\
                               } while (0)
#else
#define User_Debug_Log(...) do {} while (0)
#endif

void msd_usbfs_host_init(void);

#endif /* __FS_USBH_CONF_H */
