[#ftl]
[#-- V1.0 --]
/*!
    \file    hs_usbd_desc.c
    \brief   the descriptor file of USB device

    \version 2025-07-30, V1.0.0, firmware for GD32F5xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef __HS_USBD_CONF_H
#define __HS_USBD_CONF_H

#include "usbd_enum.h"

char* HS_VID_STR = "${USBHS_DEVICE_Mode_MassStorageClassStringConfiguration_VendorID}";
char* HS_PID_STR = "${USBHS_DEVICE_Mode_MassStorageClassStringConfiguration_ProductID}";
char* HS_LANG_ID_STR = "${USBHS_DEVICE_Mode_MassStorageClassStringConfiguration_LanguageID}";
char* HS_MANUFACTURER_STR = "${USBHS_DEVICE_Mode_MassStorageClassStringConfiguration_ManufacturerString}";
char* HS_PRODUCT_STR = "${USBHS_DEVICE_Mode_MassStorageClassStringConfiguration_ProductString}";
char* HS_CONFIGURATION_STR = "${USBHS_DEVICE_Mode_MassStorageClassStringConfiguration_ConfigurationString}";
char* HS_INTERFACE_STR = "${USBHS_DEVICE_Mode_MassStorageClassStringConfiguration_InterfaceString}";
char* HS_SERIAL_STR = "MCU F5xx";

extern usb_desc_dev hs_msc_dev_desc;

#define STRING_LENGTH(len) 2*len+2

/* USB language ID Descriptor */
usb_desc_LANGID hs_usbd_language_id_desc =
{
    .header =
     {
         .bLength         = sizeof(usb_desc_LANGID),
         .bDescriptorType = USB_DESCTYPE_STR
     }
};

/* USB manufacture string */
usb_desc_str hs_manufacturer_string =
{
    .header =
     {
         .bLength         = USB_STRING_LEN(10U),
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USB product string */
usb_desc_str hs_product_string =
{
    .header =
     {
         .bLength         = USB_STRING_LEN(17U),
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USBD serial string */
 usb_desc_str hs_serial_string =
{
    .header =
     {
         .bLength         = USB_STRING_LEN(12U),
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USB configure string */
 usb_desc_str hs_configure_string =
{
    .header =
     {
         .bLength         = USB_STRING_LEN(12U),
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USB interface string */
 usb_desc_str hs_interface_string =
{
    .header =
     {
         .bLength         = USB_STRING_LEN(12U),
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USB string descriptor */
void *hs_msc_strings_desc[] =
{
    [STR_IDX_LANGID]  = (uint8_t *)&hs_usbd_language_id_desc,
    [STR_IDX_MFC]     = (uint8_t *)&hs_manufacturer_string,
    [STR_IDX_PRODUCT] = (uint8_t *)&hs_product_string,
    [STR_IDX_SERIAL]  = (uint8_t *)&hs_serial_string,
    [STR_IDX_ITF]     = (uint8_t *)&hs_interface_string,
    [STR_IDX_CONFIG]  = (uint8_t *)&hs_configure_string
};

/*!
    \brief      initialize device descirptor and serial string descriptor
    \param[in]  none
    \param[out] none
    \retval     none
*/
void hs_string_get(void)
{
    /* initialize device descirptor and language id serial string descriptor */
    hs_msc_dev_desc.idVendor  = hs_string_to_id(HS_VID_STR);
    hs_msc_dev_desc.idProduct = hs_string_to_id(HS_PID_STR);
    hs_usbd_language_id_desc.wLANGID = hs_string_to_id(HS_LANG_ID_STR);

    /* initialize manufacturer, product and serial string descriptor */
    hs_manufacturer_string.header.bLength = STRING_LENGTH(hs_string_to_unicode(HS_MANUFACTURER_STR,(uint8_t*)&(hs_manufacturer_string.unicode_string[0])));
    hs_product_string.header.bLength      = STRING_LENGTH(hs_string_to_unicode(HS_PRODUCT_STR,(uint8_t*)&(hs_product_string.unicode_string[0])));
    hs_serial_string.header.bLength       = STRING_LENGTH(hs_string_to_unicode(HS_SERIAL_STR,(uint8_t*)&(hs_serial_string.unicode_string[0])));

    /* initialize interface and configuration string descriptor */
    hs_configure_string.header.bLength    = STRING_LENGTH(hs_string_to_unicode(HS_CONFIGURATION_STR,(uint8_t*)&(hs_configure_string.unicode_string[0])));
    hs_interface_string.header.bLength    = STRING_LENGTH(hs_string_to_unicode(HS_INTERFACE_STR,(uint8_t*)&(hs_interface_string.unicode_string[0])));
}

#endif /* __HS_USBD_CONF_H */
