[#ftl]
[#-- V1.0 --]
/*!
    \file    fs_usbd_desc.c
    \brief   the descriptor file of USB device

    \version 2025-07-30, V1.0.0, firmware for GD32F5xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef __FS_USBD_CONF_H
#define __FS_USBD_CONF_H

#include "usbd_enum.h"

char* FS_VID_STR = "${USBFS_DEVICE_Mode_MassStorageClassStringConfiguration_VendorID}";
char* FS_PID_STR = "${USBFS_DEVICE_Mode_MassStorageClassStringConfiguration_ProductID}";
char* FS_LANG_ID_STR = "${USBFS_DEVICE_Mode_MassStorageClassStringConfiguration_LanguageID}";
char* FS_MANUFACTURER_STR = "${USBFS_DEVICE_Mode_MassStorageClassStringConfiguration_ManufacturerString}";
char* FS_PRODUCT_STR = "${USBFS_DEVICE_Mode_MassStorageClassStringConfiguration_ProductString}";
char* FS_CONFIGURATION_STR = "${USBFS_DEVICE_Mode_MassStorageClassStringConfiguration_ConfigurationString}";
char* FS_INTERFACE_STR = "${USBFS_DEVICE_Mode_MassStorageClassStringConfiguration_InterfaceString}";
char* FS_SERIAL_STR = "MCU F5xx";

extern usb_desc_dev fs_msc_dev_desc;

#define STRING_LENGTH(len) 2*len+2

/* USB language ID Descriptor */
usb_desc_LANGID fs_usbd_language_id_desc =
{
    .header =
     {
         .bLength         = sizeof(usb_desc_LANGID),
         .bDescriptorType = USB_DESCTYPE_STR
     }
};

/* USB manufacture string */
usb_desc_str fs_manufacturer_string =
{
    .header =
     {
         .bLength         = USB_STRING_LEN(10U),
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USB product string */
usb_desc_str fs_product_string =
{
    .header =
     {
         .bLength         = USB_STRING_LEN(17U),
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USBD serial string */
 usb_desc_str fs_serial_string =
{
    .header =
     {
         .bLength         = USB_STRING_LEN(12U),
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USB configure string */
 usb_desc_str fs_configure_string =
{
    .header =
     {
         .bLength         = USB_STRING_LEN(12U),
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USB interface string */
 usb_desc_str fs_interface_string =
{
    .header =
     {
         .bLength         = USB_STRING_LEN(12U),
         .bDescriptorType = USB_DESCTYPE_STR,
     }
};

/* USB string descriptor */
void *fs_msc_strings_desc[] =
{
    [STR_IDX_LANGID]  = (uint8_t *)&fs_usbd_language_id_desc,
    [STR_IDX_MFC]     = (uint8_t *)&fs_manufacturer_string,
    [STR_IDX_PRODUCT] = (uint8_t *)&fs_product_string,
    [STR_IDX_SERIAL]  = (uint8_t *)&fs_serial_string,
    [STR_IDX_ITF]     = (uint8_t *)&fs_interface_string,
    [STR_IDX_CONFIG]  = (uint8_t *)&fs_configure_string
};

/*!
    \brief      initialize device descirptor and serial string descriptor
    \param[in]  none
    \param[out] none
    \retval     none
*/
void fs_string_get(void)
{
    /* initialize device descirptor and language id serial string descriptor */
    fs_msc_dev_desc.idVendor  = fs_string_to_id(FS_VID_STR);
    fs_msc_dev_desc.idProduct = fs_string_to_id(FS_PID_STR);
    fs_usbd_language_id_desc.wLANGID = fs_string_to_id(FS_LANG_ID_STR);

    /* initialize manufacturer, product and serial string descriptor */
    fs_manufacturer_string.header.bLength = STRING_LENGTH(fs_string_to_unicode(FS_MANUFACTURER_STR,(uint8_t*)&(fs_manufacturer_string.unicode_string[0])));
    fs_product_string.header.bLength      = STRING_LENGTH(fs_string_to_unicode(FS_PRODUCT_STR,(uint8_t*)&(fs_product_string.unicode_string[0])));
    fs_serial_string.header.bLength       = STRING_LENGTH(fs_string_to_unicode(FS_SERIAL_STR,(uint8_t*)&(fs_serial_string.unicode_string[0])));

    /* initialize interface and configuration string descriptor */
    fs_configure_string.header.bLength    = STRING_LENGTH(fs_string_to_unicode(FS_CONFIGURATION_STR,(uint8_t*)&(fs_configure_string.unicode_string[0])));
    fs_interface_string.header.bLength    = STRING_LENGTH(fs_string_to_unicode(FS_INTERFACE_STR,(uint8_t*)&(fs_interface_string.unicode_string[0])));
}

#endif /* __FS_USBD_CONF_H */
