/*!
    \file    hs_inter_flash_if.h
    \brief   USB DFU device flash interface header file

    \version 2025-07-30, V1.0.0, firmware for GD32F5xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef __HS_INTER_FLASH_IF_H
#define __HS_INTER_FLASH_IF_H

#include "dfu_mem.h"

#define HS_FLASH_START_ADDR        0x08000000U
#define HS_FLASH_END_ADDR          0x08780000U

#define HS_FMC_OB_START            (FMC_BASE + 0x1C)
#define HS_FMC_OB_END              (FMC_BASE + 0x57)

#define HS_OCRAM_START             0x24010000U
#define HS_OCRAM_END               0x2407FFFFU

#define HS_EFUSE_START             0x40022814U
#define HS_EFUSE_END               0x40022843U
#define HS_EFUSE_LEN               0x30U

#define HS_AES_IV_START            0x52002068U
#define HS_AES_IV_END              0x52002080U
#define HS_AES_IV_LEN              0x18U

#define HS_OB_RDPT0                0x1FFFC000U
#define HS_OB_RDPT1                0x1FFEC000U

#define HS_OB_RDPT                 0x1ffff800U

#define HS_MAL_MASK_OB             0xFFFFFF00U

#define HS_FLASH_IF_STRING         "@Internal Flash /0x08000000/2*016Ka,2*016Kg,1*064Kg,15*128Kg,4*016Kg,1*064Kg,15*128Kg,14*256Kg"

/* base address of the FMC sectors */
#define ADDR_FMC_SECTOR_0       ((uint32_t)0x08000000U) /*!< base address of sector 0,  16 kbytes */
#define ADDR_FMC_SECTOR_1       ((uint32_t)0x08004000U) /*!< base address of sector 1,  16 kbytes */
#define ADDR_FMC_SECTOR_2       ((uint32_t)0x08008000U) /*!< base address of sector 2,  16 kbytes */
#define ADDR_FMC_SECTOR_3       ((uint32_t)0x0800C000U) /*!< base address of sector 3,  16 kbytes */
#define ADDR_FMC_SECTOR_4       ((uint32_t)0x08010000U) /*!< base address of sector 4,  64 kbytes */
#define ADDR_FMC_SECTOR_5       ((uint32_t)0x08020000U) /*!< base address of sector 5,  128 kbytes */
#define ADDR_FMC_SECTOR_6       ((uint32_t)0x08040000U) /*!< base address of sector 6,  128 kbytes */
#define ADDR_FMC_SECTOR_7       ((uint32_t)0x08060000U) /*!< base address of sector 7,  128 kbytes */
#define ADDR_FMC_SECTOR_8       ((uint32_t)0x08080000U) /*!< base address of sector 8,  128 kbytes */
#define ADDR_FMC_SECTOR_9       ((uint32_t)0x080A0000U) /*!< base address of sector 9,  128 kbytes */
#define ADDR_FMC_SECTOR_10      ((uint32_t)0x080C0000U) /*!< base address of sector 10, 128 kbytes */
#define ADDR_FMC_SECTOR_11      ((uint32_t)0x080E0000U) /*!< base address of sector 11, 128 kbytes */
#define ADDR_FMC_SECTOR_12      ((uint32_t)0x08100000U) /*!< base address of sector 12, 128 kbytes */
#define ADDR_FMC_SECTOR_13      ((uint32_t)0x08120000U) /*!< base address of sector 13, 128 kbytes */
#define ADDR_FMC_SECTOR_14      ((uint32_t)0x08140000U) /*!< base address of sector 14, 128 kbytes */
#define ADDR_FMC_SECTOR_15      ((uint32_t)0x08160000U) /*!< base address of sector 15, 128 kbytes */
#define ADDR_FMC_SECTOR_16      ((uint32_t)0x08180000U) /*!< base address of sector 16, 128 kbytes */
#define ADDR_FMC_SECTOR_17      ((uint32_t)0x081A0000U) /*!< base address of sector 17, 128 kbytes */
#define ADDR_FMC_SECTOR_18      ((uint32_t)0x081C0000U) /*!< base address of sector 18, 128 kbytes */
#define ADDR_FMC_SECTOR_19      ((uint32_t)0x081E0000U) /*!< base address of sector 19, 128 kbytes */
#define ADDR_FMC_SECTOR_20      ((uint32_t)0x08200000U) /*!< base address of sector 20, 16 kbytes */
#define ADDR_FMC_SECTOR_21      ((uint32_t)0x08204000U) /*!< base address of sector 21, 16 kbytes */
#define ADDR_FMC_SECTOR_22      ((uint32_t)0x08208000U) /*!< base address of sector 22, 16 kbytes */
#define ADDR_FMC_SECTOR_23      ((uint32_t)0x0820C000U) /*!< base address of sector 23, 16 kbytes */
#define ADDR_FMC_SECTOR_24      ((uint32_t)0x08210000U) /*!< base address of sector 24, 64 kbytes */
#define ADDR_FMC_SECTOR_25      ((uint32_t)0x08220000U) /*!< base address of sector 25, 128 kbytes */
#define ADDR_FMC_SECTOR_26      ((uint32_t)0x08240000U) /*!< base address of sector 26, 128 kbytes */
#define ADDR_FMC_SECTOR_27      ((uint32_t)0x08260000U) /*!< base address of sector 27, 128 kbytes */
#define ADDR_FMC_SECTOR_28      ((uint32_t)0x08280000U) /*!< base address of sector 28, 128 kbytes */
#define ADDR_FMC_SECTOR_29      ((uint32_t)0x082A0000U) /*!< base address of sector 29, 128 kbytes */
#define ADDR_FMC_SECTOR_30      ((uint32_t)0x082C0000U) /*!< base address of sector 30, 128 kbytes */
#define ADDR_FMC_SECTOR_31      ((uint32_t)0x082E0000U) /*!< base address of sector 31, 128 kbytes */
#define ADDR_FMC_SECTOR_32      ((uint32_t)0x08300000U) /*!< base address of sector 32, 128 kbytes */
#define ADDR_FMC_SECTOR_33      ((uint32_t)0x08320000U) /*!< base address of sector 33, 128 kbytes */
#define ADDR_FMC_SECTOR_34      ((uint32_t)0x08340000U) /*!< base address of sector 34, 128 kbytes */
#define ADDR_FMC_SECTOR_35      ((uint32_t)0x08360000U) /*!< base address of sector 35, 128 kbytes */
#define ADDR_FMC_SECTOR_36      ((uint32_t)0x08380000U) /*!< base address of sector 36, 128 kbytes */
#define ADDR_FMC_SECTOR_37      ((uint32_t)0x083A0000U) /*!< base address of sector 37, 128 kbytes */
#define ADDR_FMC_SECTOR_38      ((uint32_t)0x083C0000U) /*!< base address of sector 38, 128 kbytes */
#define ADDR_FMC_SECTOR_39      ((uint32_t)0x083E0000U) /*!< base address of sector 39, 128 kbytes */
#define ADDR_FMC_SECTOR_40      ((uint32_t)0x08400000U) /*!< base address of sector 40, 256 kbytes */
#define ADDR_FMC_SECTOR_41      ((uint32_t)0x08440000U) /*!< base address of sector 41, 256 kbytes */
#define ADDR_FMC_SECTOR_42      ((uint32_t)0x08480000U) /*!< base address of sector 42, 256 kbytes */
#define ADDR_FMC_SECTOR_43      ((uint32_t)0x084C0000U) /*!< base address of sector 43, 256 kbytes */
#define ADDR_FMC_SECTOR_44      ((uint32_t)0x08500000U) /*!< base address of sector 44, 256 kbytes */
#define ADDR_FMC_SECTOR_45      ((uint32_t)0x08540000U) /*!< base address of sector 45, 256 kbytes */
#define ADDR_FMC_SECTOR_46      ((uint32_t)0x08580000U) /*!< base address of sector 46, 256 kbytes */
#define ADDR_FMC_SECTOR_47      ((uint32_t)0x085C0000U) /*!< base address of sector 47, 256 kbytes */
#define ADDR_FMC_SECTOR_48      ((uint32_t)0x08600000U) /*!< base address of sector 48, 256 kbytes */
#define ADDR_FMC_SECTOR_49      ((uint32_t)0x08640000U) /*!< base address of sector 49, 256 kbytes */
#define ADDR_FMC_SECTOR_50      ((uint32_t)0x08680000U) /*!< base address of sector 50, 256 kbytes */
#define ADDR_FMC_SECTOR_51      ((uint32_t)0x086C0000U) /*!< base address of sector 51, 256 kbytes */
#define ADDR_FMC_SECTOR_52      ((uint32_t)0x08700000U) /*!< base address of sector 52, 256 kbytes */
#define ADDR_FMC_SECTOR_53      ((uint32_t)0x08740000U) /*!< base address of sector 53, 256 kbytes */

extern dfu_mem_prop hs_dfu_inter_flash_cb;

/* function declarations */
/* write the option byte */
fmc_state_enum hs_option_byte_write(uint32_t Mem_Add,uint8_t* data);

#endif /* __INTER_FLASH_IF_H */
