[#ftl]
[#-- V1.0.4 --]
/*!
    \file    main.h
    \brief   the header file of main

    \version 2025-10-15, V1.0.0, firmware for GD32F5xx
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef MAIN_H
#define MAIN_H

/* External Includes*/
#include "gd32f527.h"
#include "netif.h"
#include "stdint.h"
[#if LWIP_LWIPEnable_TRUELWIPInformation_LWIPDependencyFreeRTOS == "Enable"]
#include "FreeRTOS.h"
#include "task.h"
[/#if]
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Type Definitions] begin */

/* user code [Type Definitions] end */

/* Shared Macros */
/* MAC address: BOARD_MAC_ADDR0:BOARD_MAC_ADDR1:BOARD_MAC_ADDR2:BOARD_MAC_ADDR3:BOARD_MAC_ADDR4:BOARD_MAC_ADDR5 */
#define BOARD_MAC_ADDR0   0x${ReflectionFunc.SplitEdit(ENET_GeneralConfiguration_MACAddress,":","^0+")[0]}
#define BOARD_MAC_ADDR1   0x${ReflectionFunc.SplitEdit(ENET_GeneralConfiguration_MACAddress,":","^0+")[1]}
#define BOARD_MAC_ADDR2   0x${ReflectionFunc.SplitEdit(ENET_GeneralConfiguration_MACAddress,":","^0+")[2]}
#define BOARD_MAC_ADDR3   0x${ReflectionFunc.SplitEdit(ENET_GeneralConfiguration_MACAddress,":","^0+")[3]}
#define BOARD_MAC_ADDR4   0x${ReflectionFunc.SplitEdit(ENET_GeneralConfiguration_MACAddress,":","^0+")[4]}
#define BOARD_MAC_ADDR5   0x${ReflectionFunc.SplitEdit(ENET_GeneralConfiguration_MACAddress,":","^0+")[5]}

[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPDHCP == "Disable"]
/* static IP address: BOARD_IP_ADDR0.BOARD_IP_ADDR1.BOARD_IP_ADDR2.BOARD_IP_ADDR3 */
#define BOARD_IP_ADDR0   ${ReflectionFunc.SplitEdit(LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration_IPAddress,":","^0+")[0]}
#define BOARD_IP_ADDR1   ${ReflectionFunc.SplitEdit(LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration_IPAddress,":","^0+")[1]}
#define BOARD_IP_ADDR2   ${ReflectionFunc.SplitEdit(LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration_IPAddress,":","^0+")[2]}
#define BOARD_IP_ADDR3   ${ReflectionFunc.SplitEdit(LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration_IPAddress,":","^0+")[3]}

/* net mask */
#define BOARD_NETMASK_ADDR0   ${ReflectionFunc.SplitEdit(LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration_NetmaskAddress,":","^0+")[0]}
#define BOARD_NETMASK_ADDR1   ${ReflectionFunc.SplitEdit(LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration_NetmaskAddress,":","^0+")[1]}
#define BOARD_NETMASK_ADDR2   ${ReflectionFunc.SplitEdit(LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration_NetmaskAddress,":","^0+")[2]}
#define BOARD_NETMASK_ADDR3   ${ReflectionFunc.SplitEdit(LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration_NetmaskAddress,":","^0+")[3]}

/* gateway address */
#define BOARD_GW_ADDR0   ${ReflectionFunc.SplitEdit(LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration_GatewayAddress,":","^0+")[0]}
#define BOARD_GW_ADDR1   ${ReflectionFunc.SplitEdit(LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration_GatewayAddress,":","^0+")[1]}
#define BOARD_GW_ADDR2   ${ReflectionFunc.SplitEdit(LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration_GatewayAddress,":","^0+")[2]}
#define BOARD_GW_ADDR3   ${ReflectionFunc.SplitEdit(LWIP_LWIPEnable_TRUELWIPIPAddressConfiguration_GatewayAddress,":","^0+")[3]}
[/#if]

[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPDHCP == "Enable"]
/* static IP address: BOARD_IP_ADDR0.BOARD_IP_ADDR1.BOARD_IP_ADDR2.BOARD_IP_ADDR3 */
#define BOARD_IP_ADDR0   10
#define BOARD_IP_ADDR1   50
#define BOARD_IP_ADDR2   3
#define BOARD_IP_ADDR3   210

/* net mask */
#define BOARD_NETMASK_ADDR0   255
#define BOARD_NETMASK_ADDR1   255
#define BOARD_NETMASK_ADDR2   255
#define BOARD_NETMASK_ADDR3   0

/* gateway address */
#define BOARD_GW_ADDR0   10
#define BOARD_GW_ADDR1   50
#define BOARD_GW_ADDR2   3
#define BOARD_GW_ADDR3   1
[/#if]
/* user code [Shared Macros] begin */

/* user code [Shared Macros] end */

/* External Constants  */
/* user code [External Constants] begin */

/* user code [External Constants] end */

/* External Variables */
/* user code [External Variables] begin */

/* user code [External Variables] end */

/* function declarations */
/* updates the system local time */
void time_update(void);
/* insert a delay time */
void delay_10ms(uint32_t ncount);

/* user code [Public Functions] begin */

/* user code [Public Functions] end */

#endif /* MAIN_H */
