/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */

/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */
    hal_timer_single_pulse_struct timer1_singlepulse_parameter;
    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */

    /* user code [local 1] end */
    msd_gpio_init();
    msd_timer1_init();

    /* user code [local 2] begin */
    /* TIMER1 single pulse mode configuration */
    timer1_singlepulse_parameter.sp_compare_mode = TIMER_OC_MODE_PWM1;
    timer1_singlepulse_parameter.sp_oc_pulse_value = 21000;
    timer1_singlepulse_parameter.sp_oc_polarity = TIMER_OC_POLARITY_HIGH;
    timer1_singlepulse_parameter.sp_oc_idlestate = TIMER_OC_IDLE_STATE_LOW;
    timer1_singlepulse_parameter.sp_ocn_polarity = TIMER_OCN_POLARITY_HIGH;
    timer1_singlepulse_parameter.sp_ocn_idlestate = TIMER_OCN_IDLE_STATE_LOW;
    timer1_singlepulse_parameter.sp_oc_fastmode = TIMER_OC_FAST_DISABLE;
    timer1_singlepulse_parameter.sp_oc_clearmode = TIMER_OC_CLEAR_DISABLE;
    timer1_singlepulse_parameter.sp_ic_polarity = TIMER_IC_POLARITY_FALLING;
    timer1_singlepulse_parameter.sp_ic_selection = TIMER_IC_SELECTION_DIRECTTI;
    timer1_singlepulse_parameter.sp_ic_filter= 0;
    hal_timer_single_pulse_mode_channel_config(&timer1_info, &timer1_singlepulse_parameter, TIMER_CH_1 , TIMER_CH_0);

    /* start TIMER single pulse mode */
    hal_timer_single_pulse_start(&timer1_info);
    /* user code [local 2] end */

    while(1){
    /* user code [local 3] begin */

    /* user code [local 3] end */
    }
}
/* user code [global 1] begin */

/* user code [global 1] end */	
